#include "rcjtest.h"
#include <stdio.h>
#include "testmak.h"
#include <cubeos.h>
#include <fastbin.h>
#include <tpu.h>
#include <tpud.h>
#include <hw_drivers.h>
#include  <ivtab.h>
#include <sys/time.h>
#include <ptimer.h>
#include "i2ccam.h"
#include <stdio.h>

#include "jpeglib.h"
//#include <setjmp.h>



#define CAM_PPL 352
#define CAM_LPI 288
#define SCALE 15
#define JPEG_QUALITY 40

void irq4wrap ();		/* wrapper code */
int int4count;
int s1, s2, t1, t2, deltatt, deltats;

int
CamTest ()
{

  int i;
  unsigned short p;
  int4count = 0;
  LED_OFF ();
  failif (RCJ_BASE == 0, "No RCJ around...");

  printf ("in CamTest\n");
  fflush (stdout);


  RCJ_init ();			/* This prepares CS3 for the GAL access */
  /* maybe the waitstates are no good yet */

  _KERN_IVTab_setvector (28, irq4wrap);	/* set the IRQ 4 autovector */

/* test the SNAP command */

  LED_ON ();
  writeshort (RCJ_BASE + 6, 0);	/* Send SNAP */
  LED_OFF ();

  for (i = 1; i < 100000; i++)
    {
      if (!(i % 10000))
	{
	  printf (".");
	  fflush (stdout);
	}
      if (int4count)
	break;
    }

  if (int4count)
    {
      printf ("Got Interrupt!\n");
    }
  else
    {
      printf ("Time out\n");
    }

  printf (" One Readout ");
  fflush (stdout);
  p = readshort (RCJ_BASE + 2);

  printf ("Reading out picture...\n");
  fflush (stdout);
  disable ();
  t1 = _time_ticks;
  s1 = _time_seconds;
  enable ();

  for (i = 1; i < CAM_LPI * CAM_PPL; i++)
    {
//              if (!(i%10000)) {printf(".");fflush(stdout);}
      p = readshort (RCJ_BASE + 2);
    }

  disable ();
  t2 = _time_ticks;
  s2 = _time_seconds;
  enable ();
  deltats = s2 - s1;
  deltatt = t2 - t1;

  if (deltatt < 0)
    {
      deltatt = deltatt + TICKS_PER_SECOND;
      deltats -= 1;
    }

  printf (" time was %d seconds, %d ticks", deltats, deltatt);


  printf ("Done...\n");
  _KERN_IVTab_clearvector (28, irq4wrap);	/* set the IRQ 4 autovector */
  return (0);
}

int
CamI2CTest ()
{

  return (I2C_DumpCamera ());

}

int
ViewTest ()
{

  int x, y, i;
  unsigned short p;
  int4count = 0;
  failif (RCJ_BASE == 0, "No RCJ around...");

  RCJ_init ();			/* This prepares CS3 for the GAL access */
  /* maybe the waitstates are no good yet */

  _KERN_IVTab_setvector (28, irq4wrap);	/* set the IRQ 4 autovector */


  writeshort (RCJ_BASE + 6, 0);	/* Send SNAP */


  for (i = 1; i < 100000; i++)
    {
      if (!(i % 10000))
	{
	  printf (".");
	  fflush (stdout);
	}
      if (int4count)
	break;
    }

  if (int4count)
    {
      printf ("Got picture!\n");
    }
  else
    {
      printf ("Time out\n");
    }


  printf ("PICTURE START\n");
  for (y = 0; y < CAM_LPI; y++)
    {
      for (x = 0; x < CAM_PPL; x++)
	{
	  p = readshort (RCJ_BASE + 2);
	  if (!(y % SCALE) && !(x % SCALE))
	    {
//                              printf("%4hx ",p);
	      printf ("%3d ", p >> 8);
//                              printf("%3d ",p&0xff);
	    }
	}
      if (!(y % SCALE))
	{
	  printf ("\n");
	  fflush (stdout);
	}
    }

  printf ("\nPICTURE END\n");
  _KERN_IVTab_clearvector (28, irq4wrap);	/* set the IRQ 4 autovector */
  return (0);
}



int
PictureTest ()
{

  int x, y, i;
  int uvcount;
  int ustore;
  int vstore;
  int ystore;
  unsigned short p;
  int4count = 0;
  failif (RCJ_BASE == 0, "No RCJ around...");

  RCJ_init ();			/* This prepares CS3 for the GAL access */
  /* maybe the waitstates are no good yet */

  _KERN_IVTab_setvector (28, irq4wrap);	/* set the IRQ 4 autovector */

/* test the SNAP command */

  writeshort (RCJ_BASE + 6, 0);	/* Send SNAP */


  for (i = 1; i < 100000; i++)
    {
      if (!(i % 10000))
	{
	  printf (".");
	  fflush (stdout);
	}
      if (int4count)
	break;
    }

  if (int4count)
    {
      printf ("Got picture!\n");
    }
  else
    {
      printf ("Time out\n");
      return (-1);
    }

  printf ("PICTURE START\n");
//      for(x=0;x<CAM_PPL;x++){
//              for(y=0;y<CAM_LPI;y++){  
//                      p=readshort(RCJ_BASE+2);                
//                      if (!(y%10) && !(x%10))
//                      {
//                              printf("%hx ",p);
//                      }
//              }
//              if(!(x%10)) { printf("\n");fflush(stdout);}
//      }
  uvcount = 0;
  for (y = 0; y < CAM_LPI; y++)
    {
      for (x = 0; x < CAM_PPL; x++)
	{
	  p = readshort (RCJ_BASE + 2);
	  if (!((uvcount++) % 2))
	    {
	      ustore = p & 0xff;
	      ystore = p >> 8;
	    }
	  else
	    {
	      vstore = p & 0xff;
	      printf ("%d %d %d %d\n", uvcount - 1, ystore, ustore, vstore);
	      printf ("%d %d %d %d\n", uvcount, p >> 8, ustore, vstore);
	    };
	}
    }

  printf ("\nPICTURE END\n");
  _KERN_IVTab_clearvector (28, irq4wrap);	/* set the IRQ 4 autovector */
  return (0);
}

int
RAWTest ()
{

  int x, y, i;
  int uvcount;
  int ustore;
  int vstore;
  int ystore;
  unsigned short p;
  int4count = 0;
  failif (RCJ_BASE == 0, "No RCJ around...");

  RCJ_init ();			/* This prepares CS3 for the GAL access */
  /* maybe the waitstates are no good yet */

  _KERN_IVTab_setvector (28, irq4wrap);	/* set the IRQ 4 autovector */

/* test the SNAP command */

  writeshort (RCJ_BASE + 6, 0);	/* Send SNAP */


  for (i = 1; i < 100000; i++)
    {
      if (!(i % 10000))
	{
	  printf (".");
	  fflush (stdout);
	}
      if (int4count)
	break;
    }

  if (int4count)
    {
      printf ("Got picture!\n");
    }
  else
    {
      printf ("Time out\n");
      return (-1);
    }

  printf ("PICTURE START\n");
  KERN_usleep(100000);
  uvcount = 0;
  for (y = 0; y < CAM_LPI; y++)
    {
      for (x = 0; x < CAM_PPL; x++)
	{
	  p = readshort (RCJ_BASE + 2);
//	  TTY_outchar(p>>8);
//	  TTY_outchar(p&0xff);
	  TTY_outchar('.');
	  KERN_usleep(1000);
	}
    }

  printf ("\nPICTURE END\n");
  _KERN_IVTab_clearvector (28, irq4wrap);	/* set the IRQ 4 autovector */
  return (0);
}



int
JPEGTest ()
{

  int x, y, i;
  int uvcount;
  int ustore;
  int vstore;
  int ystore;
  char linestore[CAM_PPL * 3];

  unsigned short p;


  struct jpeg_compress_struct cinfo;
  struct jpeg_error_mgr jerr;
  /* More stuff */
  JSAMPROW row_pointer[1];	/* pointer to JSAMPLE row[s] */
  int row_stride;		/* physical row width in image buffer */

  /* Step 1: allocate and initialize JPEG compression object */

  /* We have to set up the error handler first, in case the initialization
   * step fails.  (Unlikely, but it could happen if you are out of memory.)
   * This routine fills in the contents of struct jerr, and returns jerr's
   * address which we place into the link field in cinfo.
   */
  cinfo.err = jpeg_std_error (&jerr);
  /* Now we can initialize the JPEG compression object. */
  jpeg_create_compress (&cinfo);

  /* Step 2: specify data destination (eg, a file) */
  /* Note: steps 2 and 3 can be done in either order. */

  /* Here we use the library-supplied code to send compressed data to a
   * stdio stream.  You can also write your own code to do something else.
   * VERY IMPORTANT: use "b" option to fopen() if you are on a machine that
   * requires it in order to write binary files.
   */
  jpeg_stdio_uuen_dest (&cinfo, stdout);

  /* Step 3: set parameters for compression */

  /* First we supply a description of the input image.
   * Four fields of the cinfo struct must be filled in:
   */
  cinfo.image_width = CAM_PPL;	/* image width and height, in pixels */
  cinfo.image_height = CAM_LPI;
  cinfo.input_components = 3;	/* # of color components per pixel */
  cinfo.in_color_space = JCS_YCbCr;	/* colorspace of input image */
  /* Now use the library's routine to set default compression parameters.
   * (You must set at least cinfo.in_color_space before calling this,
   * since the defaults depend on the source color space.)
   */
  jpeg_set_defaults (&cinfo);
  /* Now you can set any non-default parameters you wish to.
   * Here we just illustrate the use of quality (quantization table) scaling:
   */
  jpeg_set_quality (&cinfo, JPEG_QUALITY,
		    TRUE /* limit to baseline-JPEG values */ );


  int4count = 0;
  failif (RCJ_BASE == 0, "No RCJ around...");

  RCJ_init ();			/* This prepares CS3 for the GAL access */
  /* maybe the waitstates are no good yet */

  _KERN_IVTab_setvector (28, irq4wrap);	/* set the IRQ 4 autovector */

/* test the SNAP command */

  writeshort (RCJ_BASE + 6, 0);	/* Send SNAP */


  for (i = 1; i < 100000; i++)
    {
      if (!(i % 10000))
	{
	  printf (".");
	  fflush (stdout);
	}
      if (int4count)
	break;
    }

  if (int4count)
    {
      printf ("Got picture!\n");
    }
  else
    {
      printf ("Time out\n");
      return (-1);
    }
  /* Step 4: Start compressor */

  /* TRUE ensures that we will write a complete interchange-JPEG file.
   * Pass TRUE unless you are very sure of what you're doing.
   */
  jpeg_start_compress (&cinfo, TRUE);


  uvcount = 0;
  for (y = 0; y < CAM_LPI; y++)
    {
      for (x = 0; x < CAM_PPL; x++)
	{
	  p = readshort (RCJ_BASE + 2);
	  if (!((uvcount++) % 2))
	    {
	      ustore = p & 0xff;
	      ystore = p >> 8;
	    }
	  else
	    {
	      vstore = p & 0xff;
	      linestore[(x - 1) * 3] = ystore;
	      linestore[(x - 1) * 3 + 1] = ustore;
	      linestore[(x - 1) * 3 + 2] = vstore;
//	      linestore[(x - 1) * 3 + 1] = 0;
//	      linestore[(x - 1) * 3 + 2] = 0;
	      linestore[(x) * 3] = p >> 8;
	      linestore[(x) * 3 + 1] = ustore;
	      linestore[(x) * 3 + 2] = vstore;
//	      linestore[(x) * 3 + 1] = 0;
//	      linestore[(x) * 3 + 2] = 0;
	    };

	}
      row_pointer[0] = linestore;
      //usleep(100000);
      if (cinfo.next_scanline < cinfo.image_height)
	{
	  (void) jpeg_write_scanlines (&cinfo, row_pointer, 1);
	}

    }
  jpeg_finish_compress (&cinfo);
  jpeg_destroy_compress (&cinfo);
  _KERN_IVTab_clearvector (28, irq4wrap);	/* set the IRQ 4 autovector */
  return (0);
}

int
JPEGGTest ()
{

  int x, y, i;
  int uvcount;
  int ustore;
  int vstore;
  int ystore;
  char linestore[CAM_PPL];
  char * imagestore;

  unsigned short p;


  struct jpeg_compress_struct cinfo;
  struct jpeg_error_mgr jerr;
  /* More stuff */
  JSAMPROW row_pointer[1];	/* pointer to JSAMPLE row[s] */
  int row_stride;		/* physical row width in image buffer */

  /* Step 1: allocate and initialize JPEG compression object */

  /* We have to set up the error handler first, in case the initialization
   * step fails.  (Unlikely, but it could happen if you are out of memory.)
   * This routine fills in the contents of struct jerr, and returns jerr's
   * address which we place into the link field in cinfo.
   */
  cinfo.err = jpeg_std_error (&jerr);
  /* Now we can initialize the JPEG compression object. */
  jpeg_create_compress (&cinfo);

  /* Step 2: specify data destination (eg, a file) */
  /* Note: steps 2 and 3 can be done in either order. */

  /* Here we use the library-supplied code to send compressed data to a
   * stdio stream.  You can also write your own code to do something else.
   * VERY IMPORTANT: use "b" option to fopen() if you are on a machine that
   * requires it in order to write binary files.
   */
  jpeg_stdio_uuen_dest (&cinfo, stdout);
//  jpeg_stdio_dest (&cinfo, stdout);

  /* Step 3: set parameters for compression */

  /* First we supply a description of the input image.
   * Four fields of the cinfo struct must be filled in:
   */
  cinfo.image_width = CAM_PPL;	/* image width and height, in pixels */
  cinfo.image_height = CAM_LPI;
  cinfo.input_components = 1;	/* # of color components per pixel */
  cinfo.in_color_space = JCS_GRAYSCALE;	/* colorspace of input image */
  /* Now use the library's routine to set default compression parameters.
   * (You must set at least cinfo.in_color_space before calling this,
   * since the defaults depend on the source color space.)
   */
  jpeg_set_defaults (&cinfo);
  /* Now you can set any non-default parameters you wish to.
   * Here we just illustrate the use of quality (quantization table) scaling:
   */
  jpeg_set_quality (&cinfo, JPEG_QUALITY,
		    TRUE /* limit to baseline-JPEG values */ );


  int4count = 0;
  failif (RCJ_BASE == 0, "No RCJ around...");

  RCJ_init ();			/* This prepares CS3 for the GAL access */
  /* maybe the waitstates are no good yet */

  _KERN_IVTab_setvector (28, irq4wrap);	/* set the IRQ 4 autovector */

/* test the SNAP command */

  writeshort (RCJ_BASE + 6, 0);	/* Send SNAP */


  for (i = 1; i < 100000; i++)
    {
      if (!(i % 10000))
	{
	  printf (".");
	  fflush (stdout);
	}
      if (int4count)
	break;
    }

  if (int4count)
    {
      printf ("Got picture!\n");
    }
  else
    {
      printf ("Time out\n");
      return (-1);
    }

  printf ("reading image\n");
   imagestore =  malloc(CAM_LPI*CAM_PPL);

  if (imagestore==0) {
	printf("malloc failed\n");
	return(-1);
  }

  for (y = 0; y < CAM_LPI; y++)
    {
      for (x = 0; x < CAM_PPL; x++)
	{
	  p = readshort (RCJ_BASE + 2);
	  imagestore[y*CAM_PPL+x] = p>>8;
	}
    }
  printf("end readout\n");

  /* Step 4: Start compressor */

  /* TRUE ensures that we will write a complete interchange-JPEG file.
   * Pass TRUE unless you are very sure of what you're doing.
   */
  jpeg_start_compress (&cinfo, TRUE);

  uvcount = 0;
  for (y = 0; y < CAM_LPI; y++)
    {
      row_pointer[0] = imagestore + y*CAM_PPL;
      if (cinfo.next_scanline < cinfo.image_height)
	{
	  (void) jpeg_write_scanlines (&cinfo, row_pointer, 1);
	}

    }
  jpeg_finish_compress (&cinfo);
  free(imagestore);
  jpeg_destroy_compress (&cinfo);
  _KERN_IVTab_clearvector (28, irq4wrap);	/* set the IRQ 4 autovector */
  return (0);
}
int
JPEGFake ()
{

  int x, y, i;
  int uvcount;
  int ustore;
  int vstore;
  int ystore;
  char linestore[CAM_PPL * 3];

  unsigned short p;


  struct jpeg_compress_struct cinfo;
  struct jpeg_error_mgr jerr;
  /* More stuff */
  JSAMPROW row_pointer[1];	/* pointer to JSAMPLE row[s] */
  int row_stride;		/* physical row width in image buffer */

  /* Step 1: allocate and initialize JPEG compression object */

  /* We have to set up the error handler first, in case the initialization
   * step fails.  (Unlikely, but it could happen if you are out of memory.)
   * This routine fills in the contents of struct jerr, and returns jerr's
   * address which we place into the link field in cinfo.
   */
  cinfo.err = jpeg_std_error (&jerr);
  /* Now we can initialize the JPEG compression object. */
  jpeg_create_compress (&cinfo);

  /* Step 2: specify data destination (eg, a file) */
  /* Note: steps 2 and 3 can be done in either order. */

  /* Here we use the library-supplied code to send compressed data to a
   * stdio stream.  You can also write your own code to do something else.
   * VERY IMPORTANT: use "b" option to fopen() if you are on a machine that
   * requires it in order to write binary files.
   */
  jpeg_stdio_uuen_dest (&cinfo, stdout);

  /* Step 3: set parameters for compression */

  /* First we supply a description of the input image.
   * Four fields of the cinfo struct must be filled in:
   */
  cinfo.image_width = CAM_PPL;	/* image width and height, in pixels */
  cinfo.image_height = CAM_LPI;
  cinfo.input_components = 3;	/* # of color components per pixel */
  cinfo.in_color_space = JCS_YCbCr;	/* colorspace of input image */
  /* Now use the library's routine to set default compression parameters.
   * (You must set at least cinfo.in_color_space before calling this,
   * since the defaults depend on the source color space.)
   */
  jpeg_set_defaults (&cinfo);
  /* Now you can set any non-default parameters you wish to.
   * Here we just illustrate the use of quality (quantization table) scaling:
   */
  jpeg_set_quality (&cinfo, JPEG_QUALITY,
		    TRUE /* limit to baseline-JPEG values */ );


  int4count = 0;
  failif (RCJ_BASE == 0, "No RCJ around...");

  RCJ_init ();			/* This prepares CS3 for the GAL access */
  /* maybe the waitstates are no good yet */

  _KERN_IVTab_setvector (28, irq4wrap);	/* set the IRQ 4 autovector */

/* test the SNAP command */

  writeshort (RCJ_BASE + 6, 0);	/* Send SNAP */


  for (i = 1; i < 100000; i++)
    {
      if (!(i % 10000))
	{
	  printf (".");
	  fflush (stdout);
	}
      if (int4count)
	break;
    }

  if (int4count)
    {
      printf ("Got picture!\n");
    }
  else
    {
      printf ("Time out\n");
      return (-1);
    }
  /* Step 4: Start compressor */

  /* TRUE ensures that we will write a complete interchange-JPEG file.
   * Pass TRUE unless you are very sure of what you're doing.
   */
  jpeg_start_compress (&cinfo, TRUE);


  uvcount = 0;
  for (y = 0; y < CAM_LPI; y++)
    {
      for (x = 0; x < CAM_PPL; x++)
	{
	  p = readshort (RCJ_BASE + 2);
	  if (!((uvcount++) % 2))
	    {
	      ustore = p & 0xff;
	      ystore = p >> 8;
	    }
	  else
	    {
	      vstore = p & 0xff;
/*	      linestore[(x - 1) * 3] = ystore;
	      linestore[(x - 1) * 3 + 1] = ustore;
	      linestore[(x - 1) * 3 + 2] = vstore;
	      linestore[(x) * 3] = p >> 8;
	      linestore[(x) * 3 + 1] = ustore;
	      linestore[(x) * 3 + 2] = vstore;
		*/
	      linestore[(x - 1) * 3] = x&0xff;
	      linestore[(x - 1) * 3 + 1] = 40;
	      linestore[(x - 1) * 3 + 2] = 80;
	      linestore[(x) * 3] = x&0xff;
	      linestore[(x) * 3 + 1] = 40;
	      linestore[(x) * 3 + 2] = 80;
/*				printf("%d %d %d %d\n",uvcount-1,ystore,ustore,vstore);
				printf("%d %d %d %d\n",uvcount,p>>8,ustore,vstore);
*/
	    };

	}
      row_pointer[0] = linestore;
      //usleep(100000);
      if (cinfo.next_scanline < cinfo.image_height)
	{
	  (void) jpeg_write_scanlines (&cinfo, row_pointer, 1);
	}

    }
  jpeg_finish_compress (&cinfo);
  jpeg_destroy_compress (&cinfo);
  _KERN_IVTab_clearvector (28, irq4wrap);	/* set the IRQ 4 autovector */
  return (0);
}



void
irq4_handler ()
{
  unsigned short d;
  int i;
  LED_ON ();
  for (i = 1; i < 100; i++);
  LED_OFF ();
  int4count++;
  d = readshort (RCJ_BASE + 6);	/* Confirm interrupt */
//      writeshort(RCJ_BASE+6,0); /* Send SNAP */


}
