#include <stdlib.h>
#include <stdio.h>
#include <cubeos.h>
#include <i2ccam.h>
#include <i2cd.h>


#define MAXCAMI2CLEN 0x50

char _I2C_camera_mbuf[MAXCAMI2CLEN];
struct i2cmess _I2C_camera_m;

int I2C_ReadCamByte(char addr)
{

/* set adress */
	_I2C_camera_m.address = 0xc0; /* only one camera */
	_I2C_camera_m.nrBytes = 1;
	_I2C_camera_m.buf = _I2C_camera_mbuf;
	_I2C_camera_mbuf[0] = addr;
	I2C_process(I2CA, I2C_MASTER, &_I2C_camera_m);

/* read value */
	_I2C_camera_m.address = 0xc0 | 0x01; /* one camera, read */
	_I2C_camera_m.nrBytes = 1;	/* Read one byte */
	_I2C_camera_mbuf[0] = 0;	/* clear buffer */
	_I2C_camera_m.buf = _I2C_camera_mbuf;


	I2C_process(I2CA, I2C_MASTER, &_I2C_camera_m);

	return ((int) (((unsigned int) _I2C_camera_mbuf[0]) & 0xff));
}

int I2C_DumpCamera()
{
	int i;

/* set adress */
	_I2C_camera_m.address = 0xc0; /* only one camera */
	_I2C_camera_m.nrBytes = 1;
	_I2C_camera_m.buf = _I2C_camera_mbuf;
	_I2C_camera_mbuf[0] = 0;
	I2C_process(I2CA, I2C_MASTER, &_I2C_camera_m);

/* read value */
	_I2C_camera_m.address = 0xc0 | 0x01; /* one camera, read */
	_I2C_camera_m.nrBytes = MAXCAMI2CLEN;	/* Read camera */
	for(i=0;i<MAXCAMI2CLEN;i++ )_I2C_camera_mbuf[i] = 0;	
		/* clear buffer */
	_I2C_camera_m.buf = _I2C_camera_mbuf;
	I2C_process(I2CA, I2C_MASTER, &_I2C_camera_m);

	if (_I2C_camera_m.status == I2C_OK){

		printf("camera register dump\n");
		
		printf(" gain: %3d\t", _I2C_camera_mbuf[0x00] & 0x3f);
		printf(" blue: %3d\t", _I2C_camera_mbuf[0x01] );
		printf(" red : %3d\t", _I2C_camera_mbuf[0x02] );
		printf(" sat : %3d\t", (unsigned char) _I2C_camera_mbuf[0x03] );
		printf(" cnt : %3d\t", (unsigned char) _I2C_camera_mbuf[0x05] );
		printf(" brt : %3d\t", (unsigned char) _I2C_camera_mbuf[0x06] );
		printf(" sh.r: %3d\t", (unsigned char) _I2C_camera_mbuf[0x07] & 0x0f  );
		printf(" sh.t: %3d\n", ((unsigned char) _I2C_camera_mbuf[0x07] & 0xF0) >> 4 );

		printf(" AWBb: %3d\t", (unsigned char) _I2C_camera_mbuf[0x0c] );
		printf(" AWBr: %3d\t", (unsigned char) _I2C_camera_mbuf[0x0d] );
		printf(" comR: %3x\t", (unsigned char) _I2C_camera_mbuf[0x0e] );
		printf(" comS: %3x\t", (unsigned char) _I2C_camera_mbuf[0x0f] );
		printf(" AECt: %3x\t", (unsigned char) _I2C_camera_mbuf[0x10] );
		printf(" CLKR: %3x\t", (unsigned char) _I2C_camera_mbuf[0x11] );
		printf(" comA: %3x\t", (unsigned char) _I2C_camera_mbuf[0x12] );
		printf(" comB: %3x\n", (unsigned char) _I2C_camera_mbuf[0x13] );

		printf(" comC: %3x\t", (unsigned char) _I2C_camera_mbuf[0x14] );
		printf(" comD: %3x\t", (unsigned char) _I2C_camera_mbuf[0x15] );
		printf(" FSD : %3x\t", (unsigned char) _I2C_camera_mbuf[0x16] );
		printf(" HRST: %3x\t", (unsigned char) _I2C_camera_mbuf[0x17] );
		printf(" HREN: %3x\t", (unsigned char) _I2C_camera_mbuf[0x18] );
		printf(" VRST: %3x\t", (unsigned char) _I2C_camera_mbuf[0x19] );
		printf(" VREN: %3x\t", (unsigned char) _I2C_camera_mbuf[0x1A] );
		printf(" PSH : %3x\n", (unsigned char) _I2C_camera_mbuf[0x1B] );

		printf(" MIDH: %3x\t", (unsigned char) _I2C_camera_mbuf[0x1C] );
		printf(" MIDL: %3x\t", (unsigned char) _I2C_camera_mbuf[0x1D] );
		printf(" comE: %3x\t", (unsigned char) _I2C_camera_mbuf[0x20] );
		printf(" YOFF: %3x\t", (unsigned char) _I2C_camera_mbuf[0x21] );
		printf(" UOFF: %3x\t", (unsigned char) _I2C_camera_mbuf[0x22] );
		printf(" REFC: %3x\t", (unsigned char) _I2C_camera_mbuf[0x23] );
		printf(" AEW : %3x\t", (unsigned char) _I2C_camera_mbuf[0x24] );
		printf(" AEB : %3x\n", (unsigned char) _I2C_camera_mbuf[0x25] );

		printf(" comF: %3x\t", (unsigned char) _I2C_camera_mbuf[0x26] );
		printf(" comG: %3x\t", (unsigned char) _I2C_camera_mbuf[0x27] );
		printf(" comH: %3x\t", (unsigned char) _I2C_camera_mbuf[0x28] );
		printf(" comI: %3x\t", (unsigned char) _I2C_camera_mbuf[0x29] );
		printf(" FRAH: %3x\t", (unsigned char) _I2C_camera_mbuf[0x2A] );
		printf(" FRAL: %3x\t", (unsigned char) _I2C_camera_mbuf[0x2B] );
		printf(" comJ: %3x\t", (unsigned char) _I2C_camera_mbuf[0x2D] );
		printf(" VCOF: %3x\n", (unsigned char) _I2C_camera_mbuf[0x2E] );

		printf(" CPP : %3x\t", (unsigned char) _I2C_camera_mbuf[0x33] );
		printf(" BIAS: %3x\t", (unsigned char) _I2C_camera_mbuf[0x34] );
		printf(" comK: %3x\t", (unsigned char) _I2C_camera_mbuf[0x38] );
		printf(" comL: %3x\t", (unsigned char) _I2C_camera_mbuf[0x39] );
		printf(" HSST: %3x\t", (unsigned char) _I2C_camera_mbuf[0x3A] );
		printf(" HSEN: %3x\t", (unsigned char) _I2C_camera_mbuf[0x3B] );
		printf(" comM: %3x\t", (unsigned char) _I2C_camera_mbuf[0x3C] );
		printf(" comN: %3x\n", (unsigned char) _I2C_camera_mbuf[0x3D] );

		printf(" comO: %3x\t", (unsigned char) _I2C_camera_mbuf[0x3E] );
		printf(" comP: %3x\t", (unsigned char) _I2C_camera_mbuf[0x3F] );
		printf(" YMXA: %3x\t", (unsigned char) _I2C_camera_mbuf[0x4D] );
		printf(" ARL : %3x\t", (unsigned char) _I2C_camera_mbuf[0x4E] );
		printf(" YMXB: %3x\n", (unsigned char) _I2C_camera_mbuf[0x4F] );

		printf("\n");

	} else {
		printf("camera register dump failed!\n");
		return(-1);
	}
		return(0);
}

int I2C_WriteCamByte(char addr, char byte)
{

/* set adress & write */
	_I2C_camera_m.address = 0xc0; /* only one camera */
	_I2C_camera_m.nrBytes = 2;
	_I2C_camera_m.buf = _I2C_camera_mbuf;
	_I2C_camera_mbuf[0] = addr;
	_I2C_camera_mbuf[1] = byte;

	I2C_process(I2CA, I2C_MASTER, &_I2C_camera_m);
        I2C_messagestatus(&_I2C_camera_m);
	return (_I2C_camera_m.status == I2C_OK);
}



int CAM_setyuv()
{
return(I2C_WriteCamByte(0x4d, 0x02));


}
int CAM_setycrcb()
{
return(I2C_WriteCamByte(0x4d, 0x12));

}

int I2C_init_camera()
{
I2C_init(I2CA, I2CA_BASE);
return 0; /* dummy */

}
