#include <stdio.h>
#include <cubeos.h>
#include <i2cd.h>
#include <analog.h>
#include <digital.h>

int I2CTest ()
{
	char a;
	int i, j;

	printf ("Calling I2C_INIT for Channel A:\n");
	printf (" Base 0x%x, IV %d\n", I2CA_BASE, I2CA_VECTORNUM);

	I2C_init(I2CA, I2CA_BASE);


	printf ("Calling I2C_INIT for Channel B...\n");
	printf (" Base 0x%x, IV %d\n", I2CB_BASE, I2CB_VECTORNUM);
	I2C_init(I2CB, I2CB_BASE);

	printf ("Seems to have worked...\n");


	printf ("Scanning i2c bus A...\n");

	printf ("found %d devices\n", I2C_scanbus(I2CA));

	printf ("Scanning i2c bus B...\n");

	printf ("Found %d devices\n", I2C_scanbus(I2CB));


	printf ("init_analog...\n");
	I2C_init_analog();
	printf ("OK\n");

	for (j = 0; j < 5; j++) {

		printf ("reading analog at adress 0x%x, channel 0 : ", _I2C_ad_data[0].address);

		a = I2C_ReadAnalogIn(0, 0);

		if (I2C_messagestatus(&_I2C_analog_m))
			return (-1);

		printf ("%d OK\n", a);
		for (i = 1; i < 100000; i++);
	}
	printf ("init_digital...\n");

	I2C_init_digital();

	printf ("OK\n");

	for (j = 0; j < 5; j++) {
		printf ("reading digital at adress 0x%x : ", _I2C_bin_data[0].address);

		a = I2C_ReadBinIn(0);

		if (I2C_messagestatus(&_I2C_digital_m))
			return (-1);

		printf ("0x%x OK\n", a);
		for (i = 1; i < 100000; i++);
	}


	return (0);
}
