#include <stdio.h>
#include <cubeos.h>
#include <ptimer.h>
#include <ttyio.h>
#include <schedule.h>
#include <sys/time.h>
#include <limits.h>
#include <i2cd.h>
#include <analog.h>
#include <digital.h>
#include <compass.h>

#include <RobLib.h>

#include <rpc/types.h>
#include <rpc/xdr.h>

#define MAXSHORT 32767

#include "cubecom.h"
#include "rescue.h"
#include "rescue_sockets.h"

#define JOY_MAX 32767

extern int data_buf[3];


//extern int myrecord[1000][2];
//extern int myrecorddone;


int global_cmd_nr;
int global_vec_nr;
int global_cmd_code;

int sig = 1;

#define FRONT_BUMPER (!(bumpreg&128))
#define BACK_BUMPER (!(bumpreg&64))
#define LEFT_BUMPER (!(bumpreg&32))
#define RIGHT_BUMPER (!(bumpreg&16))

int bumpreg;
int bumper_active;
int compass_heading;
int compass_recal;
int voltage;
int left_sensor;
int right_sensor;
int timestamp_s;
int timestamp_t;

int i2c_thread_id;

void i2c_thread() 
{
  int h;

  while(1){
    // gather sensor data
    //
    bumpreg=I2C_ReadBinIn(2);
    compass_heading = I2C_ReadCompass();
    //DRIVE_recal_x(0);
    //DRIVE_recal_y(0);
    if (compass_recal) DRIVE_recal_alpha(36000-compass_heading*10);

    //voltage=I2C_ReadAnalogIn(0,0);
    //left_sensor=I2C_ReadAnalogIn(1,0);
    //right_sensor=I2C_ReadAnalogIn(1,1);
    disable();
    timestamp_s=_time_seconds;
    timestamp_t=_time_ticks;
    enable();
    //if (bumpreg!=255) {
    //if (bumper_active==1) DRIVE_pid_speed(0,0);
    //}

    KERN_psleep(100);
  }
}



int Bumper(int i)
{
	if ((i<0) ||(i>7)) {
		return (0);
	} else {
		return (!(bumpreg& 1<<i));
	}

}

XDR xdrs;



int process_configure(COM_framehead_T * frame)
{
  int l;
  int alpha;
  configure_t theconfig;
  char buffer[128];
  buffer[0]=0;
  if (frame) {
    if (frame->data)
      {
	xdrmem_create (&xdrs, frame->data, frame->length, XDR_DECODE);
	// do something
	xdr_configure_t(&xdrs,&theconfig);
	xdr_destroy(&xdrs);
	if (theconfig.settime) {
	  disable();
	  _time_seconds = theconfig.time_s;
	  _time_ticks = theconfig.time_t;
	  enable();
	}

	if (theconfig.setod) {
	  DRIVE_recal_x(theconfig.rob_x);
	  DRIVE_recal_y(theconfig.rob_y);
	  DRIVE_recal_alpha(theconfig.rob_alpha);
	  sprintf(buffer,"configured to %d %d %d\n",theconfig.rob_x,theconfig.rob_y,theconfig.rob_alpha);
	}

	if (theconfig.setcr) {
	  if (theconfig.compass_recal) {
	    compass_recal=1;
	  } else {
	    compass_recal=0;
	  }
	}
	if (theconfig.setss) {
	  DRIVE_set_translation_scale(theconfig.trans_scale);
	  DRIVE_set_rotation_scale(theconfig.rot_scale);
	}
	COM_send(buffer,strlen(buffer),COM_CONFIG,COM_CONSOLE,0);
	free (frame-> data);
      }
    free(frame);
  }

}

int process_vector(COM_framehead_T * frame)
{
  int l;
  int alpha;
  vector_t thevector;
  char buffer[128];
  buffer[0]=0;
  if (frame) {
    if (frame->data)
      {
	xdrmem_create (&xdrs, frame->data, frame->length, XDR_DECODE);
	// do something
	xdr_vector_t(&xdrs,&thevector);
	xdr_destroy(&xdrs);
	DRIVE_fast_vector(
			  thevector.ang,
			  thevector.dist,
			  thevector.absrel,
			  thevector.astart);

	sprintf("Driving fastvector (%d,%d,%d,%d)\n",
		thevector.ang,
		thevector.dist,
		thevector.absrel,
		thevector.astart);

	COM_send(buffer,strlen(buffer),COM_VECTOR,COM_CONSOLE,0);
	free (frame-> data);
      }
    free(frame);
  }

}


int just_process_actuator(COM_framehead_T * frame)
{
  int l;
  int alpha;
  command_t thecommand;

  if (frame) {
    if (frame->data)
      {
	xdrmem_create (&xdrs, frame->data, frame->length, XDR_DECODE);
	// do something
	xdr_command_t(&xdrs,&thecommand);
	xdr_destroy(&xdrs);
	if ((thecommand.joy_button & 64) |(thecommand.joy_button &128)) {
	DRIVE_fast_vector(0,0,0,500);
	} else {
	l = thecommand.joy_y*150/MAXSHORT;
	alpha = thecommand.joy_x*4500 / MAXSHORT;
	DRIVE_fast_vector(alpha,l,0,500);
	}
	free (frame-> data);
      }
    free(frame);
  }

}

int process_actuator(COM_framehead_T * frame)
{
  just_process_actuator(frame);
  COM_send(NULL,0,COM_ACTUATOR,COM_ACTUATOR,0);

}


int send_answer(COM_framehead_T * frame)
{
  answer_t theanswer;
  int bsize;
  char * buffer;
  //  bsize = xdr_sizeof(xdr_answer_t,&theanswer);
  bsize=4*9;
  buffer = malloc(bsize);
  xdrmem_create (&xdrs, buffer, bsize, XDR_ENCODE);
  theanswer.rob_x =  DRIVE_robx() ;
  theanswer.rob_y =   DRIVE_roby() ;
  theanswer.rob_alpha =   DRIVE_robalpha();
  theanswer.comp_alpha = compass_heading;
  theanswer.bumper = bumpreg;
  theanswer.left_sensor = left_sensor;
  theanswer.right_sensor = right_sensor;
  theanswer.timestamp_s = timestamp_s;
  theanswer.timestamp_t = timestamp_t;;
  xdr_answer_t(&xdrs,&theanswer);
  xdr_destroy(&xdrs);
  COM_send(buffer,bsize,COM_SENSOR,2,0);
  free(buffer);
}


int process_command(COM_framehead_T * frame)
{

  just_process_actuator(frame);
  send_answer(frame);

}

int main (int argc, char *argv[]) {

	int 	errorflag;
	int	pacount;
	int 	i;
	int	air[5];

	int joy_x, joy_y, joy_r, joy_s;
	int command;
	int leftpwm,rightpwm;
	int leftspeed, rightspeed;

	float P, I, D, Q;
	int left_speed, right_speed;
	int old_left_speed, old_right_speed;
	int max_speed, now_max_speed;


	int dIO;
	int joy_checksum, vec_checksum;
	int speedl, speedr;
	int vec_x, vec_y, vec_alpha;
	int new_x, new_y, new_alpha;

	int bumped;
	char inkey;



	COM_framehead_T *rcvframe;
	int bo;
	int ro;

	const char theanswer = "And the answer is: No";

	pacount = 0;


	TTY_setcontty(0);

	TTY_Blocking_Serial_Out=0;

/************************************************************************/

	printf("\nCubeCom Rescue v0.1\n");
        printf("\n");
        printf("\n");

	TTY_conecho_off();

/***************************************************************************/

	printf("\n********** Init Sensors/Display...\n");
      	init_sensors();
	
	compass_recal=0;

	I2C_init_compass();
	compass_heading = I2C_ReadCompass();

	printf("Compass Heading is %d\n",compass_heading);
	

	printf("\n********** Sensors/Display ready!\n");

        printf("\n********** Init Controller...\n");
        printf("preparing lookup tables:\n");
        printf("sin and cos\n");
	TRI_init_sincos ();
        printf("atan\n");
        TRI_init_atan ();
        printf("sqrt\n");
        TRI_init_sqrt ();       
	printf("OK\n");

	printf("preparing recorder:\n");
	REC_init_recorder(1000,sizeof(record));
	printf("OK\n");

	printf("preparing drive:\n");
	config_drives();
	//init_drive(DR_RCR_BASE_V0);
	init_drive(DR_RCR_V1o1);
	printf("OK\n");

	DRIVE_recal_alpha(36000-compass_heading*10);

	printf("preparing interrupt service routine (ISR) for control:\n");
	DRIVE_init_isr();
	printf("OK\n");


	//	MOTOR_set_maxpwm(MLEFT,5000);
	//	MOTOR_set_maxpwm(MRIGHT,5000);
	//	printf("Limiting PWM to 5000\n\n");
printf("********** Controller ready!\n\n");



//for (i=8;i<=14;i++)
//	{TPU_makedio(i);
//	printf("Made dIO %d\n",i);}
//
//	TPU_setdio(10,255);
//	TPU_getdio(10);
//
//	TPU_setdio(13, 0);
//	printf("Made dios.\n");


/************************************************************************/
/* start thread for COMMAND NOTIFICATION */
       	bumper_active = 0;
       	i2c_thread_id = KERN_create(i2c_thread);
        //KERN_suspend(bump_thread_id);

/************************************************************************/
/* MAIN LOOP */


//DRIVE_set_scale(0.2);
//while(1) {
//sscanf(readcmd("P: "),"%f",&P);
//printf("\n");
//sscanf(readcmd("I: "),"%f",&I);
//printf("\n");
//scanf(readcmd("D: "),"%f",&D);
//printf("\n");
//
//DRIVE_set_pid(P,I,D);
//myrecorddone = 0;
//DRIVE_pid_speed(10000, 10000);
//while(!myrecorddone) { printf("."); }
//printf("\n"); 
//for(i=0;i<1000;i++) {
//printf("%d %d %d\n", i, myrecord[i][0], myrecord[i][1]);
//}
//myrecorddone = 0;
//DRIVE_pid_speed(0, 0);
//while(!myrecorddone) { printf("."); }
//}

	max_speed = 10000;
	left_speed = 0;
	right_speed = 0;
	old_left_speed = 0;
	old_right_speed = 0;

	DRIVE_set_translation_scale(0.70);
	DRIVE_set_rotation_scale(0.15);

	/* speed commands with 1 Hz minimum or breaking linearly over 2 sec */
	DRIVE_set_safespeed(1,2);

	// set PID control to reasonable values
	DRIVE_set_pid(0.01,0.0,0.0,-1.0);

	//	_QSM_sci_setbps(19200);




	COM_init();
	printf("\n");
	COM_printstats();

	printf("****************************\n");
	printf("* Ready to receive packets *\n");
	printf("****************************\n");

	COM_register(COM_BOTH,process_command);
	COM_register(COM_ACTUATOR,process_actuator);
	COM_register(COM_SENSOR,send_answer);
	COM_register(COM_CONFIG,process_configure);
	COM_register(COM_VECTOR,process_vector);


	//	while(1) {
	//	  printf("R: %hhx \n",COM_receive_byte(1));
	//
	//	}
	bo=0;ro=0;
	_KERN_sys_error=0;
	while(1) {
	  COM_process_one();
	}
	    //	    printf(" KSE: %d\n",_KERN_sys_error);
	    //	    if (_KERN_sys_error & SYS_ERR_SCIBUF_OVF){
	    //	      bo++;
	    //	      _KERN_sys_error =0;
	    //	    }

	    //	    if (_KERN_sys_error & SYS_ERR_SCIREG_OVF){
	    //	      ro++;
	    //	      _KERN_sys_error=0;
	    //	    }

	  //	COM_printstats();
	  //	printf("buffer overruns: %d\n",bo);
	  //	printf("buffer overruns: %d\n",ro);
	  //	printf("\n");




while(1);



while(1){
	/* ready to go... */

//	printf("@%d\n",pacount);
//	global_cmd_nr = pacount;
//	pacount++;

//	/* get a new line */
//	errorflag = getdataline();
//	if(!errorflag) {	
//	bumped = I2C_ReadBinIn(2);

//	if((bumpreg != 255)&&(bumper_active == 1)) {
  //	printf("BUMP %d \n", 255-bumped);
  //	if(FRONT_BUMPER) printf("Front Bumper\n");
  //	if(BACK_BUMPER) printf("Back Bumper\n");
  //	if(LEFT_BUMPER) printf("Left Bumper\n");
  //	if(RIGHT_BUMPER) printf("Right Bumper\n");
  //}
	printf("Enter Command.\n");
	//	command=getkey();
	printf("\n");
//	printf("got command %c",command);
	switch(command) {

		case 'b':
			printf("bumper check now: %d\n", bumper_active);
			do{
				bumper_active=2;
				printf("Activate bumper (Y/N)?");fflush(stdout);
				//				inkey=getkey();
				if (inkey=='y') bumper_active=1;
				if (inkey=='n') bumper_active=0;
				printf("\n");
			}while ((bumper_active != 0) && (bumper_active != 1));

		case 'I':
			printf("rob: x(cm) %d, y(cm) %d, alpha(deg) %d\n",(DRIVE_robx()/10),(DRIVE_roby()/10),(DRIVE_robalpha()/100));
//			printf("%d %d %d\n",DRIVE_robx(),DRIVE_roby(),DRIVE_robalpha());
			break;
		case 'i':
			printf("rob: x(gri) %d, y(gri) %d, alpha(deg) %d\n",(DRIVE_robx()/900),(DRIVE_roby()/900),(DRIVE_robalpha()/100));
//			printf("%d %d %d\n",DRIVE_robx(),DRIVE_roby(),DRIVE_robalpha());
			break;

		case 'd':
			if (bumper_active && !FRONT_BUMPER && !BACK_BUMPER && !RIGHT_BUMPER && ! LEFT_BUMPER) {
				DRIVE_set_rotation_scale(0.15);
				DRIVE_vector(9000, 0,0);
//				printf("turning by 90deg\n");
			}
			break;

		case 'f':
			if (bumper_active && !FRONT_BUMPER && !BACK_BUMPER && !RIGHT_BUMPER && ! LEFT_BUMPER) {
				DRIVE_set_rotation_scale(0.15);
				DRIVE_vector(-9000, 0,0);
//				printf("turning by -90deg\n");
			}
			break;
		case 's':
			if (bumper_active && !FRONT_BUMPER && !BACK_BUMPER && !RIGHT_BUMPER && ! LEFT_BUMPER) {
				DRIVE_set_rotation_scale(0.4);
				DRIVE_vector(9000, 0,0);
//				printf("turning by 90deg\n");
			}
			break;
		case 'g':
			if (bumper_active && !FRONT_BUMPER && !BACK_BUMPER && !RIGHT_BUMPER && ! LEFT_BUMPER) {
				DRIVE_set_rotation_scale(0.4);
				DRIVE_vector(-9000, 0,0);
//				printf("turning by -90deg\n");
			}
			break;

		case 'r':	
			if (bumper_active && !FRONT_BUMPER && !LEFT_BUMPER && !RIGHT_BUMPER) {
				DRIVE_vector(0, 250,0);
//				printf("going straight, approx. 25cm\n");
			}
			break;

		case 'c':
			if (bumper_active && !BACK_BUMPER && !LEFT_BUMPER && !RIGHT_BUMPER) {
				DRIVE_vector(0,-250,0);
//				printf("going backwards, approx. 25cm\n");
			}
			break;

		case 'a':
			if (bumper_active && !FRONT_BUMPER && !BACK_BUMPER && !RIGHT_BUMPER && ! LEFT_BUMPER) {
//			printf("Going straight. ");
			sscanf(readcmd("Going straight. Length (in cm) : "),"%d",&vec_x);
			DRIVE_vector(0,vec_x*10,0);
			}
			break;

		case ' ':
			DRIVE_pid_speed(0,0);
//			DRIVE_shutdown(); Major disaster option
			printf("STOP! Any Key to continue.\n");
			//			getkey();
			break;

//		case 'm':
//			sscanf(readcmd("Left: "),"%d",&leftpwm);
//			printf("\n");
//			sscanf(readcmd("Right: "),"%d",&rightpwm);
//			printf("\n");
//			_MOTOR_setPW(MLEFT,leftpwm);
//			_MOTOR_setPW(MRIGHT,rightpwm);
//
//			for(i=0;i<10;i++)
//			{
//				printf("mLeft: %5d\t mRight: %5d\t trans: %2.3f\t rot: %2.3f\n", DRIVE_get_leftmotor_speed(), DRIVE_get_rightmotor_speed(), DRIVE_get_translation_speed(), DRIVE_get_rotation_speed());
//				KERN_ssleep(1);
//			}
//			_MOTOR_setPW(MLEFT,0);
//			_MOTOR_setPW(MRIGHT,0);
//			break;
//
//		case ';':	
//			sscanf(readcmd("SpeedLeft: "),"%d",&leftspeed);
//			printf("\n");
//			sscanf(readcmd("SpeedRight: "),"%d",&rightspeed);
//			printf("\n");
//			DRIVE_pid_speed(leftspeed,rightspeed);
//     	       		for(i=0;i<10;i++)
//			{
//				printf("mLeft: %5d\t mRight: %5d\t trans: %2.3f\t rot: %2.3f\n", DRIVE_get_leftmotor_speed(), DRIVE_get_rightmotor_speed(), DRIVE_get_translation_speed(), DRIVE_get_rotation_speed());
//				KERN_ssleep(1);
//			}
//			DRIVE_pid_speed(0,0);
//			break;
//
//		case 'p':
//			printf("\n");
//			DRIVE_playback();
//			printf("\n");
//			break;
//
#ifdef CONFIGTEST

		case 'o':
			printf("\n");
			printf("P: %f\n",P);
			printf("I: %f\n",I);
			printf("D: %f\n",D);
			printf("Q: %f\n",Q);

			sscanf(readcmd("P: "),"%f",&P);
			printf("\n");
//			sscanf(readcmd("I: "),"%f",&I);
//			printf("\n");
//			sscanf(readcmd("D: "),"%f",&D);
//			printf("\n");			
//			sscanf(readcmd("Q: "),"%f",&Q);
//			printf("Q: %f\n",Q);
//			printf("\n");			
			DRIVE_set_pid(P,0.0,0.0,-1.0);
			break;
#endif


//
//		case 'l':
//			TPU_setdio(13, 1);
//			break;
//
//		case 'k':
//			TPU_setdio(13, 0);
//			break;
//			
		case '[':
//			printf("reading string as \%d \%d\n");


			sscanf(readcmd(""), "%d %d %d",&joy_x, &joy_y, &joy_checksum); // read in joystick values
			printf("x: %d, y: %d, check: %d", joy_x, joy_y, joy_checksum);
			/* The joystick values are in a range of 0-32??? with y-axis being inverted.
			   Additionally, the values are scaled from a circle on the game pad onto a square:
			   at 45 deg, x=y. */
			if (joy_checksum == (joy_x+joy_y)){
				joy_x = (joy_x*10000)/JOY_MAX; // scale joystick to 0-10000
//				printf("\njoy_x : %d", joy_x);
				joy_y = (joy_y*10000)/JOY_MAX;
//				printf(" joy_y : %d\n", joy_y);
				speedl = (joy_x-joy_y);	// calculate speed of chains, a non-linear scaling would be nicer, but is not yet implemented
				speedr = (-joy_x-joy_y);
				if (speedl>10000)		// clip, if our values are too large.
					speedl = 10000;
				if (speedr>10000) 
					speedr = 10000;
//				if (bumper_active && !FRONT_BUMPER && !BACK_BUMPER && !RIGHT_BUMPER && ! LEFT_BUMPER) {
					DRIVE_safe_pid_speed(speedl, speedr);
//				}
			}
			
			break;

		case ']':
//			printf("reading string as (x y alpha)\n");
			sscanf(readcmd(""), "%d %d %d",&vec_x, &vec_y, &vec_alpha);
			DRIVE_vector(vec_x, vec_y, vec_alpha);
			break;

		case 'q':
			printf("Recalibrating Dead Reckoning.\n");
			DRIVE_recal_x(0);
			DRIVE_recal_y(0);
			DRIVE_recal_alpha(0);
			break;
		case 'Q':
			printf("Please enter new Coordinates!\n");
			sscanf(readcmd("New X(cm): "),"%d",&new_x);
			printf("\n");
			sscanf(readcmd("New Y(cm): "),"%d",&new_y);
			printf("\n");
			sscanf(readcmd("Alpha(deg): "),"%d",&new_alpha);
			printf("\n");
			DRIVE_recal_x(new_x*10);
			DRIVE_recal_y(new_y*10);
			DRIVE_recal_alpha(new_alpha*100);
			break;

		default:
			printf("?\n");
			break;
	}
}
	return (0);
}
