#include <stdio.h>
#include <cubeos.h>
#include <ptimer.h>
#include <ttyio.h>
#include <schedule.h>
#include <sys/time.h>
#include <limits.h>
#include <i2cd.h>
#include <analog.h>

#include <RobLib.h>


#include "cubecom.h"

#define JOY_MAX 32767

extern int data_buf[3];


//extern int myrecord[1000][2];
//extern int myrecorddone;


int global_cmd_nr;
int global_vec_nr;
int global_cmd_code;

int sig = 1;

#define FRONT_BUMPER (!(bumpreg&128))
#define BACK_BUMPER (!(bumpreg&64))
#define LEFT_BUMPER (!(bumpreg&32))
#define RIGHT_BUMPER (!(bumpreg&16))

int bumpreg;
int bumper_active;


int bump_thread_id;

void bump_thread() {
	int h;

	while(1){
		bumpreg=I2C_ReadBinIn(2);
if (bumpreg!=255) {
	if (bumper_active==1) DRIVE_pid_speed(0,0);
//			TTY_outchar('x');
	}
//			else {
//			TTY_outchar('.');
//			}

//		h = DRIVE_check_vector_completed();
//		if(h!=0) {
//			printf("#%d %d\n",global_cmd_code,global_vec_nr);
//			KERN_suspend(output_thread_id);
//		}
	KERN_psleep(100);
	}
}



//int Bumper(int i)
//{
//	if ((i<0) ||(i>7)) {
//		return (0);
//	} else {
//		return (!(I2C_ReadBinIn(2)& 1<<i));
//	}
//
//}

int main (int argc, char *argv[]) {

	int 	errorflag;
	int	pacount;
	int 	i;
	int	air[5];

	int joy_x, joy_y, joy_r, joy_s;
	int command;
	int leftpwm,rightpwm;
	int leftspeed, rightspeed;

	float P, I, D, Q;
	int left_speed, right_speed;
	int old_left_speed, old_right_speed;
	int max_speed, now_max_speed;


	int dIO;
	int joy_checksum, vec_checksum;
	int speedl, speedr;
	int vec_x, vec_y, vec_alpha;
	int new_x, new_y, new_alpha;

	int bumped;
	char inkey;



	COM_framehead_T *rcvframe;


	pacount = 0;


//	TTY_setcontty(2);

	TTY_Blocking_Serial_Out=0;

/************************************************************************/

	printf("\nCubeCom Rescue v0.1\n");
        printf("\n");
        printf("\n");

	TTY_conecho_off();

/***************************************************************************/

	printf("\n********** Init Sensors/Display...\n");
	init_sensors();
	printf("\n********** Sensors/Display ready!\n");

        printf("\n********** Init Controller...\n");
        printf("preparing lookup tables:\n");
        printf("sin and cos\n");
        TRI_init_sincos ();
        printf("atan\n");
        TRI_init_atan ();
        printf("sqrt\n");
        TRI_init_sqrt ();       
	printf("OK\n");

	printf("preparing recorder:\n");
	REC_init_recorder(1000,sizeof(record));
	printf("OK\n");

	printf("preparing drive:\n");
	config_drives();
	init_drive(DR_RCR_BASE_V0);
	printf("OK\n");

	printf("preparing interrupt service routine (ISR) for control:\n");
	DRIVE_init_isr();
	printf("OK\n");


	//	MOTOR_set_maxpwm(MLEFT,5000);
	//	MOTOR_set_maxpwm(MRIGHT,5000);
	//	printf("Limiting PWM to 5000\n\n");
printf("********** Controller ready!\n\n");



//for (i=8;i<=14;i++)
//	{TPU_makedio(i);
//	printf("Made dIO %d\n",i);}
//
//	TPU_setdio(10,255);
//	TPU_getdio(10);
//
//	TPU_setdio(13, 0);
//	printf("Made dios.\n");


/************************************************************************/
/* start thread for COMMAND NOTIFICATION */
	//	bumper_active = 1;
	//      bump_thread_id = KERN_create(bump_thread);
        //	KERN_suspend(bump_thread_id);

/************************************************************************/
/* MAIN LOOP */


//DRIVE_set_scale(0.2);
//while(1) {
//sscanf(readcmd("P: "),"%f",&P);
//printf("\n");
//sscanf(readcmd("I: "),"%f",&I);
//printf("\n");
//scanf(readcmd("D: "),"%f",&D);
//printf("\n");
//
//DRIVE_set_pid(P,I,D);
//myrecorddone = 0;
//DRIVE_pid_speed(10000, 10000);
//while(!myrecorddone) { printf("."); }
//printf("\n"); 
//for(i=0;i<1000;i++) {
//printf("%d %d %d\n", i, myrecord[i][0], myrecord[i][1]);
//}
//myrecorddone = 0;
//DRIVE_pid_speed(0, 0);
//while(!myrecorddone) { printf("."); }
//}

	max_speed = 10000;
	left_speed = 0;
	right_speed = 0;
	old_left_speed = 0;
	old_right_speed = 0;

	DRIVE_set_translation_scale(0.70);
	DRIVE_set_rotation_scale(0.15);

	/* speed commands with 1 Hz minimum or breaking linearly over 2 sec */
	DRIVE_set_safespeed(1,2);

	// set PID control to reasonable values
	DRIVE_set_pid(0.01,0.0,0.0,-1.0);

	COM_init();
	printf("\n");
	COM_printstats();

	printf("****************************\n");
	printf("* Ready to receive packets *\n");
	printf("****************************\n");


	//	while(1) {
	//	  printf("R: %hhx \n",COM_receive_byte(1));
	//
	//	}


	while(1) {
	rcvframe=COM_receive_frame();

	printf("\n");
	COM_printstats();
	printf("\n");
	COM_printframe(rcvframe);
	printf("\n");
	}



while(1);



while(1){
	/* ready to go... */

//	printf("@%d\n",pacount);
//	global_cmd_nr = pacount;
//	pacount++;

//	/* get a new line */
//	errorflag = getdataline();
//	if(!errorflag) {	
//	bumped = I2C_ReadBinIn(2);

//	if((bumpreg != 255)&&(bumper_active == 1)) {
  //	printf("BUMP %d \n", 255-bumped);
  //	if(FRONT_BUMPER) printf("Front Bumper\n");
  //	if(BACK_BUMPER) printf("Back Bumper\n");
  //	if(LEFT_BUMPER) printf("Left Bumper\n");
  //	if(RIGHT_BUMPER) printf("Right Bumper\n");
  //}
	printf("Enter Command.\n");
	//	command=getkey();
	printf("\n");
//	printf("got command %c",command);
	switch(command) {

		case 'b':
			printf("bumper check now: %d\n", bumper_active);
			do{
				bumper_active=2;
				printf("Activate bumper (Y/N)?");fflush(stdout);
				//				inkey=getkey();
				if (inkey=='y') bumper_active=1;
				if (inkey=='n') bumper_active=0;
				printf("\n");
			}while ((bumper_active != 0) && (bumper_active != 1));

		case 'I':
			printf("rob: x(cm) %d, y(cm) %d, alpha(deg) %d\n",(DRIVE_robx()/10),(DRIVE_roby()/10),(DRIVE_robalpha()/100));
//			printf("%d %d %d\n",DRIVE_robx(),DRIVE_roby(),DRIVE_robalpha());
			break;
		case 'i':
			printf("rob: x(gri) %d, y(gri) %d, alpha(deg) %d\n",(DRIVE_robx()/900),(DRIVE_roby()/900),(DRIVE_robalpha()/100));
//			printf("%d %d %d\n",DRIVE_robx(),DRIVE_roby(),DRIVE_robalpha());
			break;

		case 'd':
			if (bumper_active && !FRONT_BUMPER && !BACK_BUMPER && !RIGHT_BUMPER && ! LEFT_BUMPER) {
				DRIVE_set_rotation_scale(0.15);
				DRIVE_vector(9000, 0,0);
//				printf("turning by 90deg\n");
			}
			break;

		case 'f':
			if (bumper_active && !FRONT_BUMPER && !BACK_BUMPER && !RIGHT_BUMPER && ! LEFT_BUMPER) {
				DRIVE_set_rotation_scale(0.15);
				DRIVE_vector(-9000, 0,0);
//				printf("turning by -90deg\n");
			}
			break;
		case 's':
			if (bumper_active && !FRONT_BUMPER && !BACK_BUMPER && !RIGHT_BUMPER && ! LEFT_BUMPER) {
				DRIVE_set_rotation_scale(0.4);
				DRIVE_vector(9000, 0,0);
//				printf("turning by 90deg\n");
			}
			break;
		case 'g':
			if (bumper_active && !FRONT_BUMPER && !BACK_BUMPER && !RIGHT_BUMPER && ! LEFT_BUMPER) {
				DRIVE_set_rotation_scale(0.4);
				DRIVE_vector(-9000, 0,0);
//				printf("turning by -90deg\n");
			}
			break;

		case 'r':	
			if (bumper_active && !FRONT_BUMPER && !LEFT_BUMPER && !RIGHT_BUMPER) {
				DRIVE_vector(0, 250,0);
//				printf("going straight, approx. 25cm\n");
			}
			break;

		case 'c':
			if (bumper_active && !BACK_BUMPER && !LEFT_BUMPER && !RIGHT_BUMPER) {
				DRIVE_vector(0,-250,0);
//				printf("going backwards, approx. 25cm\n");
			}
			break;

		case 'a':
			if (bumper_active && !FRONT_BUMPER && !BACK_BUMPER && !RIGHT_BUMPER && ! LEFT_BUMPER) {
//			printf("Going straight. ");
			sscanf(readcmd("Going straight. Length (in cm) : "),"%d",&vec_x);
			DRIVE_vector(0,vec_x*10,0);
			}
			break;

		case ' ':
			DRIVE_pid_speed(0,0);
//			DRIVE_shutdown(); Major disaster option
			printf("STOP! Any Key to continue.\n");
			//			getkey();
			break;

//		case 'm':
//			sscanf(readcmd("Left: "),"%d",&leftpwm);
//			printf("\n");
//			sscanf(readcmd("Right: "),"%d",&rightpwm);
//			printf("\n");
//			_MOTOR_setPW(MLEFT,leftpwm);
//			_MOTOR_setPW(MRIGHT,rightpwm);
//
//			for(i=0;i<10;i++)
//			{
//				printf("mLeft: %5d\t mRight: %5d\t trans: %2.3f\t rot: %2.3f\n", DRIVE_get_leftmotor_speed(), DRIVE_get_rightmotor_speed(), DRIVE_get_translation_speed(), DRIVE_get_rotation_speed());
//				KERN_ssleep(1);
//			}
//			_MOTOR_setPW(MLEFT,0);
//			_MOTOR_setPW(MRIGHT,0);
//			break;
//
//		case ';':	
//			sscanf(readcmd("SpeedLeft: "),"%d",&leftspeed);
//			printf("\n");
//			sscanf(readcmd("SpeedRight: "),"%d",&rightspeed);
//			printf("\n");
//			DRIVE_pid_speed(leftspeed,rightspeed);
//     	       		for(i=0;i<10;i++)
//			{
//				printf("mLeft: %5d\t mRight: %5d\t trans: %2.3f\t rot: %2.3f\n", DRIVE_get_leftmotor_speed(), DRIVE_get_rightmotor_speed(), DRIVE_get_translation_speed(), DRIVE_get_rotation_speed());
//				KERN_ssleep(1);
//			}
//			DRIVE_pid_speed(0,0);
//			break;
//
//		case 'p':
//			printf("\n");
//			DRIVE_playback();
//			printf("\n");
//			break;
//
#ifdef CONFIGTEST

		case 'o':
			printf("\n");
			printf("P: %f\n",P);
			printf("I: %f\n",I);
			printf("D: %f\n",D);
			printf("Q: %f\n",Q);

			sscanf(readcmd("P: "),"%f",&P);
			printf("\n");
//			sscanf(readcmd("I: "),"%f",&I);
//			printf("\n");
//			sscanf(readcmd("D: "),"%f",&D);
//			printf("\n");			
//			sscanf(readcmd("Q: "),"%f",&Q);
//			printf("Q: %f\n",Q);
//			printf("\n");			
			DRIVE_set_pid(P,0.0,0.0,-1.0);
			break;
#endif


//
//		case 'l':
//			TPU_setdio(13, 1);
//			break;
//
//		case 'k':
//			TPU_setdio(13, 0);
//			break;
//			
		case '[':
//			printf("reading string as \%d \%d\n");


			sscanf(readcmd(""), "%d %d %d",&joy_x, &joy_y, &joy_checksum); // read in joystick values
			printf("x: %d, y: %d, check: %d", joy_x, joy_y, joy_checksum);
			/* The joystick values are in a range of 0-32??? with y-axis being inverted.
			   Additionally, the values are scaled from a circle on the game pad onto a square:
			   at 45 deg, x=y. */
			if (joy_checksum == (joy_x+joy_y)){
				joy_x = (joy_x*10000)/JOY_MAX; // scale joystick to 0-10000
//				printf("\njoy_x : %d", joy_x);
				joy_y = (joy_y*10000)/JOY_MAX;
//				printf(" joy_y : %d\n", joy_y);
				speedl = (joy_x-joy_y);	// calculate speed of chains, a non-linear scaling would be nicer, but is not yet implemented
				speedr = (-joy_x-joy_y);
				if (speedl>10000)		// clip, if our values are too large.
					speedl = 10000;
				if (speedr>10000) 
					speedr = 10000;
//				if (bumper_active && !FRONT_BUMPER && !BACK_BUMPER && !RIGHT_BUMPER && ! LEFT_BUMPER) {
					DRIVE_safe_pid_speed(speedl, speedr);
//				}
			}
			
			break;

		case ']':
//			printf("reading string as (x y alpha)\n");
			sscanf(readcmd(""), "%d %d %d",&vec_x, &vec_y, &vec_alpha);
			DRIVE_vector(vec_x, vec_y, vec_alpha);
			break;

		case 'q':
			printf("Recalibrating Dead Reckoning.\n");
			DRIVE_recal_x(0);
			DRIVE_recal_y(0);
			DRIVE_recal_alpha(0);
			break;
		case 'Q':
			printf("Please enter new Coordinates!\n");
			sscanf(readcmd("New X(cm): "),"%d",&new_x);
			printf("\n");
			sscanf(readcmd("New Y(cm): "),"%d",&new_y);
			printf("\n");
			sscanf(readcmd("Alpha(deg): "),"%d",&new_alpha);
			printf("\n");
			DRIVE_recal_x(new_x*10);
			DRIVE_recal_y(new_y*10);
			DRIVE_recal_alpha(new_alpha*100);
			break;

		default:
			printf("?\n");
			break;
	}
}
	return (0);
}
