// CubeCom.h
// 

#ifndef _cubecom_h
#define _cubecom_h


// constants

#define COM_TIMEOUT 100 // in ticks
#define COM_STATE_SOF 1
#define COM_STATE_EOF 2
#define COM_STATE_RST 3

#define COM_SCRAMBLE 0xF0
#define COM_SOF 0x01
#define COM_EOF 0x02
// 0x03 is the reset char for the cube
#define COM_ESC 0x33

// data types

typedef struct {
  unsigned short length;
  unsigned short flags;
  unsigned char ssap;
  unsigned char dsap;
  unsigned short fcs;
  unsigned short hcheck;
  char * data;
} COM_framehead_T;

typedef struct {
  unsigned int counter;
  int (*function) (COM_framehead_T * frame);
} COM_receiver_T;

typedef struct {
  unsigned int goodframe;
  unsigned int badheader;
  unsigned int baddata;
  unsigned int overflow;
  unsigned int timeout;
  unsigned int framecount;
} COM_rxstat_T;

typedef struct {
  unsigned int framecount;
} COM_txstat_T;

// variables

extern int COM_Timer_Flag;
extern int COM_Timer_Thread;
extern int COM_receive_status;
extern int COM_transmit_status;

extern COM_rxstat_T COM_rxstat;
extern COM_txstat_T COM_txstat;

// function prototypes

int COM_init();
int COM_deinit();
int COM_printstats();
void COM_outchar(char c);
char COM_inchar();
char COM_receive_byte(int raw);
int COM_send_byte(char c,int raw);
int COM_checkhead(COM_framehead_T * theframe);
void COM_fixhead(COM_framehead_T * theframe);
unsigned short COM_fcs(char * data, unsigned short length);
int COM_send_frame(COM_framehead_T * theframe);
int COM_send(char * data, unsigned short length, unsigned char ssap, unsigned char dsap, unsigned char flags);
COM_framehead_T * COM_receive_frame();

#endif
