#include "unixif.h"
#include "cubecom.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#ifndef sun
#include <error.h>
#endif
#include <stdio.h>

#define BUFSIZE 256


#include "rescue.h"
#include "rescue_sockets.h"

int bootcube(int cubefd)
{
int filefd;
char buffer[BUFSIZE];
int countr,countw;
int i;

const char getprompt[1] = { 0x0d};
const char loadcommand[2] = { 'l' , 0x0d};
const char bootcommand[2] = { 'b' , 0x0d};


i= write (cubefd,getprompt,1);
sleep(1);
if (i != 1)
	{ 
	perror("cubedaemon");
	printf("can't send prompt command\n");
	exit(0);
	}



i = write(cubefd,loadcommand,2);


sleep(1);

if (i != 2)
	{ 
	perror("cubedaemon");
	printf("can't give load command\n");
	exit(0);
	}

if ((filefd = open("init.tw",O_RDONLY)) <0 )
	{ 
	perror("cubedaemon, fileread");
	printf("no init file\n");
	exit(0);
	}

do {
countr = read(filefd,buffer,BUFSIZE);
if (countr <0) {
perror("cubedaemon, fileread");
exit(0);
}
printf(".");fflush(stdout);
if (countr) {
	countw = write(cubefd,buffer,countr);
	if (countw <0) {
		perror("cubedaemon, fileread");
		exit(0);
	}
	printf("x");fflush(stdout);
}
} while ((countr!=0) && (countr==countw));

if (write(cubefd,bootcommand,2) !=2) 
	{ 
	printf("can't give boot command\n");
	exit(0);
	}
}


int process_five(COM_framehead_T * frame)
{

  //  printf(" This is #5\n");

  if (frame) {
    if (frame->data)
      {
	printf ("5: Got : %s\n",frame->data);
	free (frame-> data);
      }
    free(frame);
  }

}

int process_XDR(COM_framehead_T * frame)
{

  XDR xdrs;
  answer_t theanswer;


  if (frame) {
    if (frame->data)
      {
	xdrmem_create (&xdrs, frame->data, frame->length, XDR_DECODE);
	// do something
	xdr_answer_t(&xdrs,&theanswer);
	xdr_destroy(&xdrs);
	printf("The answer: \n");
	printf(" rob_x %d \n", theanswer.rob_x);
	printf(" rob_y %d\n",theanswer.rob_y);
	printf(" rob_alpha %d\n",theanswer.rob_alpha);
	printf(" comp_alpha %d\n",theanswer.comp_alpha);
	printf(" bumper %hhx\n",theanswer.bumper);
	free (frame-> data);
      }
    free(frame);
  }

}

int send_command(command_t * thecommand)
{
  XDR xdrs;
  int bsize;
  char * buffer;

  //  printf(" This is #5\n");
  bsize = xdr_sizeof(xdr_command_t,&thecommand);
  buffer = malloc(bsize);
  xdrmem_create (&xdrs, buffer, bsize, XDR_ENCODE);
  xdr_command_t(&xdrs,thecommand);
  xdr_destroy(&xdrs);
  COM_send(buffer,bsize,COM_BOTH,COM_BOTH,0);

}


int main()
{

  char * testpacket="This is a test packet";

  COM_framehead_T *rcvframe;

  command_t thecommand;
 
  unsigned char i=0;

int cubefd;
printf(" CubeCOM daemon starting\n");

cubefd = CUBE_open("/dev/robot");

printf("cubefd is %d\n",cubefd);

bootcube(cubefd);

 printf("cube booted \n");


 sleep(5);
 // _CUBE_configure_port_slow(cubefd);

 COM_init(cubefd);
 COM_register(5,process_five);
 COM_register(COM_BOTH,process_XDR);
 COM_register(COM_SENSOR,process_XDR);

 COM_printstats();

 printf("sending test packets\n");

while(1) {
  //  printf("Sending packed %d\n",i);
 COM_send(testpacket,strlen(testpacket)+1,5,0,0xf0);
 COM_process_one();

 thecommand.joy_x=0;
 thecommand.joy_y=0;
 thecommand.joy_button=0;
 send_command(&thecommand);
 COM_process_one();



 // rcvframe=COM_receive_frame();
 //if (rcvframe) {
 //  COM_printframe(rcvframe);
 //    if (rcvframe->data)
 //	free(rcvframe->data);
 //     free(rcvframe);
 //} else {
 //  printf("no reception\n");
 //}

 i++;
 if (i==100) {
   i=0;
   COM_printstats();
 }

 usleep(50000);
}

}
