
class quantity
{
  char *name;
  short int value;
  short int min_value;
  short int max_value;
  short int new_value; 
  actuator *act;
  short int act_arg;
  sensor   *sen;
  short int sen_arg;
  quantity *next;
  quantity(const char *name,short int max,short int min,short int init_value);
  ~quantity();

};


class actuator
{
  char *name;
  virtual short int act_set(quantity * q);
  virtual short int act_update();
  actuator *next;
};

class sensor
{
  char *name;
  virtual short int sen_get(quantity * q);
  virtual short int sen_update();
  sensor next;
};


#define value(q) ((q) -> value)
#define add_value(q,v) ((q) -> new_value) += (v)
#define set_value(q,v) (((q) -> value) = (v))
#define set_new_value(q,v) (((q) -> new_value) = (v))

#define next(q) ((q)->next)


void add_process(const char *name,void (*theprocess)());

void connect_sensor(sensor s, short int sen_arg, quantity q);
void connect_actuator(actuator a,short int act_arg, quantity q);

void init_pdl(void);
void pause_pdl(void);
void runpdl(long cyclecounter);

void pause_robot(void);

struct process_struct {
  char *name;
  void (*the_process) ();
  pdl_process next;
};



quantity *qlisthead ;
actuator *alisthead ;
sensor *slisthead ;


sensor binin[2];
sensor adin[24]
actuator daout[6];
actuator binout[2];


/* End of header */

quantity::quantity(const char *name, short int max, short int min, short int init_value)
{
	name = (char *)malloc (sizeof(char) * (strlen(name)+1));
	if(name == NULL)
        {
                printf("Could not allocate name of new quantity");
	} else { strcpy(q -> name,name); }

	value = init_value;
	max_value = max;
	min_value = min;
	new_value = 0;
	act=NULL;
	sen=NULL;
	next = qlisthead;
	qlisthead = self;
}

actuator::actuator(const char *name,short int (*act_set) (short int act_arg),  short int (*act_update) ())
{
	name = (char *)malloc (sizeof(char) * (strlen(name)+1));
	if(name == NULL)
        {
                printf("Could not allocate name of new actuator");
	} else {        strcpy(q -> name,name); }

	act_set= act_set;
        act_update = act_update;


  return q;
}

add_actuator(actuator q)
{
	q -> next = alisthead;
	alisthead = q;
}

sensor new_sensor(const char *name, short int (*sen_set) (short int, short int),  short int (*sen_update) (short int))
{
        sensor q;

        q = (sensor) malloc (sizeof (struct sensor_struct));
        if (q == NULL)
        {
                printf("Could not allocate new sensor");
                return q;
	}
	q -> name = (char *)malloc (sizeof(char) * (strlen(name)+1));
	if((q -> name) == NULL)
        {
                printf("Could not allocate name of new sensor");
                return q;
	}

        strcpy(q -> name,name);
	q -> sen_set = sen_set;
	q -> sen_set_arg = sen_set_arg;
	q -> sen_update = sen_update;
	q -> sen_update_arg = sen_update_arg;
  return q;
}

add_sensor(sensor s)
{
	q -> next = slisthead;
	slisthead = q;
}

void add_process(const char *name, void(*my_process)())
{
  pdl_process p;

  p = (pdl_process) malloc (sizeof (struct process_struct));
  if(p == NULL)
  {
    printf("Could not allocate new process_struct\n\r");
  }
  p -> name = (char *)malloc (sizeof (char) * (strlen(name) + 1));
  if((p -> name) == NULL)
  {
    printf("Could not allocate name of new process_struct\n\r");
  }
  strcpy (p -> name,name);
  p -> the_process = my_process;
  p -> next_process = first_process;
  first_process = p;
}


void init_pdl()
{

prinf("This is init_pdl !");

qlisthead = (quantity) NULL;
alisthead = (actuator) NULL;
slisthead = (sensor) NULL;

binin[0] = new_sensor("bin1",&bin1_get,&bin1_update);
binin[1] = new_sensor("bin2",&bin2_get,&bin2_update);
adin[0] = new_sensor("ad0",%ad0
}
	
