#include <cubeos.h>
#include <tpu.h>
#include <tpud.h>
#include<motor.h>

unsigned short period;
//void icontrolWrapper ();


int PWleft,PWright;


void motor_set_directionbits() {
//	printf("SetDirBits\n");
	make_fastbin(LEFT_D0,LEFT_TYPE_D0,LEFT_ID_D0);
	make_fastbin(LEFT_D1,LEFT_TYPE_D1,LEFT_ID_D1);
	make_fastbin(RIGHT_D0,RIGHT_TYPE_D0,RIGHT_ID_D0);
	make_fastbin(RIGHT_D1,RIGHT_TYPE_D1,RIGHT_ID_D1);
#ifdef GOT_KICK
	make_fastbin(KICK_D0,KICK_TYPE_D0,KICK_ID_D0);
	make_fastbin(KICK_D1,KICK_TYPE_D1,KICK_ID_D1);
#endif
}

void motor_set_frequency(int pulse_frequency) {
	period = TCR1FREQ / pulse_frequency;
        setPAR (LEFT_PWM, 2, abs (PWleft) * period / 10000);
	TPU_setpwmperiod (LEFT_PWM, period);
        setPAR (RIGHT_PWM, 2, abs (PWright) * period / 10000);
	TPU_setpwmperiod (RIGHT_PWM, period);
	setHSRR (LEFT_PWM, 2);	/* request init */
	setHSRR (RIGHT_PWM, 2);	/* request init */
}

void motor_set_tpchannels(int pulse_frequency) {
//	printf("SetTPCH\n");
	period = TCR1FREQ / pulse_frequency;

	TPU_makepwm (LEFT_PWM);
	TPU_setpwmperiod (LEFT_PWM, period);
	TPU_makepwm (RIGHT_PWM);
	TPU_setpwmperiod (RIGHT_PWM, period);
	TPU_makeqd (LEFT_QD1, LEFT_QD2);
	TPU_makeqd (RIGHT_QD1, RIGHT_QD2);
//	TPU_setisr (LEFT_PWM, icontrolWrapper);
	
//	setCIER (LEFT_PWM, 0x1);	/* Now, icontrol_int will be called */
	
	setHSRR (LEFT_PWM, 2);	/* request init */
	setHSRR (RIGHT_PWM, 2);	/* request init */

#ifdef GOT_KICK
	TPU_makepwm (KICK_PWM);
	TPU_setpwmperiod (KICK_PWM, 20000); /* About 50 Hz */
#endif
}


int motor_leftencoder() {
	return(TPU_getqd (LEFT_QD2));	
}

int motor_rightencoder() {
	return(TPU_getqd (RIGHT_QD2));	
}


void motor_setPW(int newPWleft, int newPWright) {

	PWleft = newPWleft;
	PWright = newPWright;


        if (PWleft < 0) {
                set_fastbin (LEFT_D0, 0);
                set_fastbin (LEFT_D1, 1);
        } else {
                set_fastbin (LEFT_D0, 1);
                set_fastbin (LEFT_D1, 0);
        }
        if (PWright < 0) {
                set_fastbin (RIGHT_D0, 0);
                set_fastbin (RIGHT_D1, 1);

        } else {
                set_fastbin (RIGHT_D0, 1);
                set_fastbin (RIGHT_D1, 0);
        }

        setPAR (LEFT_PWM, 2, abs (PWleft) * period / 10000);
        setPAR (RIGHT_PWM, 2, abs (PWright) * period / 10000);

}

void motor_setPWleft(int newPWleft) {

	PWleft = newPWleft;
//	printf("SetPWLeft %d\n", PWleft);

        if (PWleft < 0) {
                set_fastbin (LEFT_D0, 0);
                set_fastbin (LEFT_D1, 1);
        } else {
                set_fastbin (LEFT_D0, 1);
                set_fastbin (LEFT_D1, 0);
        }
        setPAR (LEFT_PWM, 2, abs (PWleft) * period / 10000);
}

void motor_setPWright(int newPWright) {

	PWright = newPWright;
//	printf("SetPWRight %d\n", PWright);
        if (PWright < 0) {
                set_fastbin (RIGHT_D0, 0);
                set_fastbin (RIGHT_D1, 1);

        } else {
                set_fastbin (RIGHT_D0, 1);
                set_fastbin (RIGHT_D1, 0);
        }

        setPAR (RIGHT_PWM, 2, abs (PWright) * period / 10000);

}


