#ifndef _MOTOR_H
#define _MOTOR_H

#include <fastbin.h>


/********************************************************************************/
/* definitions for fastbins. not dependent of base */
#define LEFT_D0 0 
#define LEFT_D1 1  
#define RIGHT_D0 2 
#define RIGHT_D1 3 
#define KICK_D0 4  
#define KICK_D1 5  

/* definitions of the TP channels. base dependent */
#ifdef USE_RC9PLASTICBASE
#define BASE_DEFINED

#define LEFT_PWM 0
#define LEFT_QD1 2
#define LEFT_QD2 1
#define LEFT_TYPE_D0 FBTYPE_TPU
#define LEFT_ID_D0 9
#define LEFT_TYPE_D1 FBTYPE_CPU
#define LEFT_ID_D1 FBCPU_PCS1


#define RIGHT_PWM 3
#define RIGHT_QD1 5
#define RIGHT_QD2 4
#define RIGHT_TYPE_D0 FBTYPE_TPU
#define RIGHT_ID_D0 12
#define RIGHT_TYPE_D1 FBTYPE_TPU
#define RIGHT_ID_D1 13

#define GOT_KICK
#define KICK_PWM 6
#define KICK_TYPE_D0 FBTYPE_TPU
#define KICK_ID_D0 14
#define KICK_TYPE_D1 FBTYPE_TPU
#define KICK_ID_D1 15

#endif

#ifdef USE_RC99BASE
#define BASE_DEFINED

#define LEFT_PWM 0  
#define LEFT_QD1 1
#define LEFT_QD2 2 
#define LEFT_TYPE_D1 FBTYPE_TPU
#define LEFT_ID_D1 9
#define LEFT_TYPE_D0 FBTYPE_CPU
#define LEFT_ID_D0 FBCPU_PCS1


#define RIGHT_PWM 3
#define RIGHT_QD1 4
#define RIGHT_QD2 5 
#define RIGHT_TYPE_D1 FBTYPE_TPU
#define RIGHT_ID_D1 12
#define RIGHT_TYPE_D0 FBTYPE_TPU
#define RIGHT_ID_D0 13

#define GOT_KICK
#define KICK_PWM 6 
#define KICK_TYPE_D0 FBTYPE_TPU
#define KICK_ID_D0 14
#define KICK_TYPE_D1 FBTYPE_TPU
#define KICK_ID_D1 15

#endif

#ifdef USE_RC98BASE
#define BASE_DEFINED

#define LEFT_PWM 0  
#define LEFT_QD1 1
#define LEFT_QD2 12 /* TP Ext */
#define LEFT_TYPE_D0 FBTYPE_DUART 
#define LEFT_ID_D0 2 /* OP2 DUART */
#define LEFT_TYPE_D1 FBTYPE_DUART
#define LEFT_ID_D1 3 /* OP3 DUART */

#define RIGHT_PWM 4
#define RIGHT_QD1 5
#define RIGHT_QD2 13 /* TP Ext */
#define RIGHT_TYPE_D0 FBTYPE_DUART
#define RIGHT_ID_D0 6 /* OP6 DUART */
#define RIGHT_TYPE_D1 FBTYPE_DUART
#define RIGHT_ID_D1 7 /* OP7 DUART */

#define GOT_KICK
#define KICK_PWM 2  
#define KICK_TYPE_D0 FBTYPE_DUART
#define KICK_ID_D0 4 /* OP4 DUART */
#define KICK_TYPE_D1 FBTYPE_DUART
#define KICK_ID_D1 5 /* OP5 DUART */

#endif
#ifdef USE_SMBIIBASE
#define BASE_DEFINED

#define LEFT_PWM 6  
#define LEFT_QD1 7
#define LEFT_QD2 10 /* TP Ext */
#define LEFT_TYPE_D0 FBTYPE_DUART 
#define LEFT_ID_D0 3 /* OP2 DUART */
#define LEFT_TYPE_D1 FBTYPE_DUART
#define LEFT_ID_D1 2 /* OP3 DUART */

#define RIGHT_PWM 8
#define RIGHT_QD1 11
#define RIGHT_QD2 9 /* TP Ext */
#define RIGHT_TYPE_D0 FBTYPE_DUART
#define RIGHT_ID_D0 5 /* OP6 DUART */
#define RIGHT_TYPE_D1 FBTYPE_DUART
#define RIGHT_ID_D1 4 /* OP7 DUART */

#undef GOT_KICK

#endif

#ifndef BASE_DEFINED
#error No base defined ! Check makefile
#endif

void motor_set_directionbits();
void motor_set_tpchannels(int pulse_frequency);
void motor_set_frequency(int pulse_frequency);
int motor_leftencoder();
int motor_rightencoder();
void motor_setPW(int PWleft, int PWright);
void motor_setPWleft(int PWleft);
void motor_setPWright(int PWright);

#endif

