#include "smb2pdl1.h"
#include "smb2io.h"
#include <stdio.h>
#include <stdlib.h>





quantity Bin0;
quantity LeftFrontBumper, RightFrontBumper, LeftBackBumper, RightBackBumper, TopBumper;
quantity Bin6, Bin7;
quantity Bin8, Bin9, Bin10, Bin11, Bin12, Bin13;
quantity LeftModLight, RightModLight, LeftLight, RightLight, Voltage, Current;
quantity An6, An7;
quantity IR0, LeftFrontIR, FrontIR, RightFrontIR, IR4;
quantity IR5, IR6, IR7;
quantity LeftSpeed, LeftAcceleration, RightSpeed, RightAcceleration;
quantity LeftMotor, RightMotor;
quantity IREm0,IREm1,IREm2,IREm3,IREm4,IREm5,IREm6,IREm7;
quantity Disp1,Disp2,Disp3,Disp4;


int main(void)
{

	printf("Starting Execution\n\r");
	init_pdl();
	Bin0 = add_quantity("Bin0", 1.0,0.0,1.0);
	LeftFrontBumper = add_quantity("LeftFrontBumper", 1.0,0.0,1.0);
	RightFrontBumper = add_quantity("RightFrontBumper", 1.0,0.0,1.0);
	LeftBackBumper = add_quantity("LeftBackBumper", 1.0,0.0,1.0);
	RightBackBumper = add_quantity("RightBackBumper", 1.0,0.0,1.0);
	TopBumper = add_quantity("TopBumper", 1.0,0.0,1.0);
	Bin6 = add_quantity("Bin6", 1.0,0.0,1.0);
	Bin7 = add_quantity("Bin7", 1.0,0.0,1.0);
	LeftModLight = add_quantity("LeftModLight",255.0,0.0,0.0);
	RightModLight = add_quantity("RightModLight",255.0,0.0,0.0);
	LeftLight = add_quantity("LeftLight",255.0,0.0,0.0);
	RightLight = add_quantity("RightLight",255.0,0.0,0.0);
	Voltage = add_quantity("Voltage",255.0,0.0,0.0);
	Current = add_quantity("Current",255.0,0.0,0.0);
	An6 = add_quantity("An6",255.0,0.0,0.0);
	An7 = add_quantity("An7",255.0,0.0,0.0);
	IR0 = add_quantity("IR0",255.0,0.0,0.0);
	LeftFrontIR = add_quantity("LeftFrontIR",255.0,0.0,0.0);
	FrontIR = add_quantity("FrontIR",255.0,0.0,0.0);
	RightFrontIR = add_quantity("RightFrontIR",255.0,0.0,0.0);
	IR4 = add_quantity("IR4",255.0,0.0,0.0);
	IR5 = add_quantity("IR5",255.0,0.0,0.0);
	IR6 = add_quantity("IR6",255.0,0.0,0.0);
	IR7 = add_quantity("IR7",255.0,0.0,0.0);
	
	LeftMotor = add_quantity("LeftMotor",100.0,-100.0,0.0);
	RightMotor = add_quantity("RightMotor",100.0,-100.0,0.0);

	IREm0 = add_quantity("IREm0",200.0,0.0,0.0);
	IREm1 = add_quantity("IREm1",200.0,0.0,0.0);
	IREm2 = add_quantity("IREm2",200.0,0.0,0.0);
	IREm3 = add_quantity("IREm3",200.0,0.0,0.0);
	IREm4 = add_quantity("IREm4",200.0,0.0,0.0);
	IREm5 = add_quantity("IREm5",200.0,0.0,0.0);
	IREm6 = add_quantity("IREm6",200.0,0.0,0.0);
	IREm7 = add_quantity("IREm7",200.0,0.0,0.0);

	Disp1 = add_quantity("Disp1",255.0,0.0,0.0);
	Disp2 = add_quantity("Disp2",255.0,0.0,0.0);
	Disp3 = add_quantity("Disp3",255.0,0.0,0.0);
	Disp4 = add_quantity("Disp4",255.0,0.0,0.0);


	LeftSpeed = add_quantity("LeftSpeed",255.0,0.0,0.0);
	LeftAcceleration = add_quantity("LeftAcceleration",127.0,-127.0,0.0);
	RightSpeed = add_quantity("RightSpeed",255.0,0.0,0.0);
	RightAcceleration = add_quantity("RightAcceleration",127.0,-127.0,0.0);


	
	connect_sensor(SID_BIN0, Bin0);
	connect_sensor(SID_BIN1, LeftFrontBumper);
	connect_sensor(SID_BIN2, RightFrontBumper);
	connect_sensor(SID_BIN3, LeftBackBumper);
	connect_sensor(SID_BIN4, RightBackBumper);
	connect_sensor(SID_BIN5, TopBumper);
	connect_sensor(SID_BIN6, Bin6);
	connect_sensor(SID_BIN7, Bin7);
	connect_sensor(SID_AN0,LeftModLight);
	connect_sensor(SID_AN1,RightModLight);
	connect_sensor(SID_AN2,LeftLight);
	connect_sensor(SID_AN3,RightLight);
	connect_sensor(SID_AN4,Voltage);
	connect_sensor(SID_AN5,Current);
	connect_sensor(SID_AN6,An6);
	connect_sensor(SID_AN7,An7);
	
	connect_sensor(SID_IR0,IR0);
	connect_sensor(SID_IR1,LeftFrontIR);
	connect_sensor(SID_IR2,FrontIR);
	connect_sensor(SID_IR3,RightFrontIR);
	connect_sensor(SID_IR4,IR4);
	connect_sensor(SID_IR5,IR5);
	connect_sensor(SID_IR6,IR6);
	connect_sensor(SID_IR7,IR7);

	connect_sensor(SID_PAC1_SP,LeftSpeed);
	connect_sensor(SID_PAC1_AC,LeftAcceleration);
	connect_sensor(SID_PAC2_SP,RightSpeed);
	connect_sensor(SID_PAC2_AC,RightAcceleration);
	
	connect_actuator(AID_MOTOR1,LeftMotor);
	connect_actuator(AID_MOTOR2,RightMotor);
	
	connect_actuator(AID_IREM0,IREm0);
	connect_actuator(AID_IREM1,IREm1);
	connect_actuator(AID_IREM2,IREm2);
	connect_actuator(AID_IREM3,IREm3);
	connect_actuator(AID_IREM4,IREm4);
	connect_actuator(AID_IREM5,IREm5);
	connect_actuator(AID_IREM6,IREm6);
	connect_actuator(AID_IREM7,IREm7);

	connect_actuator(AID_DISP1, Disp1);
	connect_actuator(AID_DISP2, Disp2);
	connect_actuator(AID_DISP3, Disp3);
	connect_actuator(AID_DISP4, Disp4);

	/*Add your processes here with add_process.*/

	run_pdl(-1L);

}
	