/***********************************************************/
/* (c) Peter Stuer 1996                                    */
/*                                                         */
/* AI-LAB Vrije Universiteit Brussel                       */
/*                                                         */
/***********************************************************/
/*                                                         */
/* Smb2dlog.c vers 1.01                                    */
/*                                                         */
/***********************************************************/

/****************************************************************************/
/*                                                                          */
/* 1.01                                                                     */
/*   fixed bug causing multipart datalogs to loose the first byte of every  */
/*   but the first segment.                                                 */
/*                                                                          */
/****************************************************************************/

#include "smb2pdl1.h" 
#include "smb2io.h" 


#include <string.h> 


#include <stdlib.h>


#define MAXSTORE 49152


	struct logrec_struct;
	typedef struct logrec_struct *logrec;
	struct logrec_struct
	{
		unsigned short delay_left;
		unsigned short delay_set;
		quantity thequantity;
		logrec next_logrec;
	};

	static logrec first_logrec = (logrec)NULL;
	static logrec current_logrec = (logrec)NULL;
	static unsigned char dstore[MAXSTORE];
	static int nextfree = 0;
	static int logdisabled = 0;
	int itemstowrite;
	int itemswritten;


	void pdllogbyte(unsigned char thebyte)
	{
		if(nextfree < MAXSTORE)
		{
			dstore[nextfree] = thebyte;
			nextfree++;
		}
		else /* the robot needs to be paused and the store dumped*/
		{
			UpdateDisplay(0xC3,0x66,0x36,0x18);
			pause_pdl();
			pdllogbyte(thebyte);
		}
	}

	void pdllogstring(char * thestring)
	{
		char *workstring ;

		workstring = thestring;
		while(*workstring)
		{
			pdllogbyte((unsigned char)*workstring);
			workstring++;
		}
		pdllogbyte((unsigned char)*workstring);
	}

	void pdllogshort(unsigned short theshort)
	{
		union short_or_bytes
		{
			short s;
			unsigned char b[2];
		}StoBSwitch;

		StoBSwitch.s = theshort;
		pdllogbyte(StoBSwitch.b[1]);
		pdllogbyte(StoBSwitch.b[0]);
	}

	void pdllogfloat (float thefloat)
	{
		union float_or_bytes
		{
			float f;
			unsigned char b[4];
		}StoBSwitch;

		StoBSwitch.f = thefloat;
		pdllogbyte(StoBSwitch.b[3]);
		pdllogbyte(StoBSwitch.b[2]);
		pdllogbyte(StoBSwitch.b[1]);
		pdllogbyte(StoBSwitch.b[0]);
	}		
				
#define SEND_DELAY 0		

	void DumpStore(void)
	{
		int i;
		int j;
		for(i = 0; i < nextfree; i++)
		{
			putchar((int)dstore[i]);
			for(j = 0; j < SEND_DELAY; j++);
		}
	}
	
	void init_datalog(void)
	{
	}

	void ClearStore(void)
	{
		nextfree = 0;
	}



	void update_datalog(void)
	{

		logrec lr;

		if(!logdisabled)
		{
			for(lr = first_logrec; lr != (logrec)NULL; lr = lr->next_logrec)
			{
				if(lr-> delay_left == 0)
				{
					pdllogfloat((lr->thequantity)->value);
					lr->delay_left = lr->delay_set;
				}
				else
				{
					(lr->delay_left)--;
				}
			}
		}
	}


	void end_datalog(void)
	{
		DumpStore();
		ClearStore();
	}


	void start_datalog(void)
	{

		unsigned short int count = 0;
		char thename[1024];
		unsigned short int thedelay;
		logrec r;
		union short_or_bytes
		{
			unsigned short s;
			unsigned char b[2];
		}StoBSwitch;



		nextfree += 10; /* skip spaces where date and time used to be and skip count */

		for(r = first_logrec; r != NULL; r = r -> next_logrec)
		{
			strcpy(thename, (r->thequantity)->name);
			pdllogstring(thename);
			count++;
		}

		for(r = first_logrec; r != NULL; r = r -> next_logrec)
		{
			thedelay = r -> delay_set;
			pdllogshort(thedelay);
		}
		StoBSwitch.s = count;
		dstore[8] = StoBSwitch.b[1];
		dstore[9] = StoBSwitch.b[0];
	
	}


	void log_quantity(quantity q, unsigned short skipcycles)
	{
		logrec thelogrec;

		thelogrec = (logrec) malloc(sizeof(struct logrec_struct));
    if(thelogrec == NULL)
    {
      printf("smb2dlog\\log_quantity: malloc failed\n\r");
    }
		thelogrec->delay_left = 0;
		thelogrec->delay_set = skipcycles;
		thelogrec->thequantity = q;
		thelogrec->next_logrec = first_logrec;

		first_logrec = thelogrec;
	}

	int Log_Button_Down()
	{
		static int DownTime = 0;


		if(!(sensor[AP_BIN14]  & 0x40)) /*Sensor = 1, wich means switch is not puched (sic. dany)*/
		{
			if( (DownTime < 5))
			{
				DownTime ++;
			}

		}
		else /*sensor = 0*, according to dany's illogical mind this means the switch is pushed */
		{
			DownTime = 0;
		}

		if (DownTime == 5)
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}
