/***********************************************************/
/* (c) Peter Stuer 1996                                    */
/*                                                         */
/* AI-LAB Vrije Universiteit Brussel                       */
/*                                                         */
/* Based on work by Filip Vertommen                        */
/*                                                         */
/***********************************************************/
/*                                                         */
/* Smb2kern.h vers 1.0                                     */
/*                                                         */
/***********************************************************/


#ifndef _SMB2KERN_H_

	#define _SMB2KERN_H_
	
	typedef enum {SMB2_CHANNEL_I2C1=0,
								SMB2_CHANNEL_I2C2=1,
								SMB2_CHANNEL_SPI=2,
								SMB2_CHANNEL_Radio=3,
								SMB2_CHANNEL_RS232=4,
								SMB2_CHANNEL_CPU=5} SMB2_Channel;


	/* The type that defines device addresses. */
	typedef enum {SMB2_ADDR_IR1=0x90,
								SMB2_ADDR_IR2=0x92,
								SMB2_ADDR_AN1=0x94,
								SMB2_ADDR_AN2=0x96,
								SMB2_ADDR_BIN1=0x70,
								SMB2_ADDR_BIN2=0x72} SMB2_Dev_Addr;

	/* The type that defines the predefined device types. */
	typedef enum {SMB2_TYPE_UNDEF=0,
								SMB2_TYPE_SPI_DISPLAY=1,
								SMB2_TYPE_SPI_IR_EMIT=2,
								SMB2_TYPE_CPU_INC=1,
								SMB2_TYPE_CPU_2=2} SMB2_Dev_Type;

	typedef enum {false=0,true=1} logic;
	typedef unsigned char byte;

	#define MAX_DEVICES 32
	

	/* The SMB2-API */

	logic SMB2DefineDevice (byte DevID,
													SMB2_Dev_Type DevType,
													SMB2_Dev_Addr DevAddr,
													byte RefreshInterval,
													byte SyncGroup,
													byte RXBaseAddr,
													byte RXNmOfParam,
													byte RXFlags,
													byte RXOffset,
													byte RXInitByte,
													byte TXBaseAddr,
													byte TXNmOfParam,
													byte TXFlags,
													byte TXOffset,
													byte TXInitByte,
													SMB2_Channel Channel);            			 /* Command 0*/
	logic SMB2ExportData (byte DataBaseAddr,
												byte ToDevID,
												byte Margin);                   				   /* Command 1*/
	logic SMB2WriteDataToDev     (byte DevID,int DataCount,...); /* Command 2*/
	logic SMB2WritePartDataToDev (byte DevID,int DataCount,...); /* Command 3*/
	logic SMB2WriteData			(int NumberOfBytesAfterThis,byte StartAddress,...); /* Command 4*/
	logic SMB2UndoExport    (byte FromDataNumber,byte ToDevID);  /* Command 5*/
	logic SMB2KernelIntRate (byte Msbyte,byte Lsbyte,byte Divider);  /* Command 6*/
	logic SMB2MotorsDc      (byte MotorMask,byte DcPercentage);      /* Command 7*/
	logic SMB2MotorsPwm     (byte Msbyte,byte Lsbyte);               /* Command 8*/
	logic SMB2IRCarrier     (byte Msbyte,byte Lsbyte);               /* Command 9*/
	logic SMB2IRCarrierDc   (byte Percentage);                       /* Command 10*/
	logic SMB2IRMod         (byte Msbyte,byte Lsbyte);               /* Command 11*/
	logic SMB2IRModDc       (byte Percentage);                       /* Command 12*/
	logic SMB2Sound         (byte Msbyte,byte Lsbyte);               /* Command 13*/
	logic SMB2SoundCarrierDc(byte Percentage);                       /* Command 14*/
	logic SMB2SoundMod      (byte Msbyte,byte Lsbyte);               /* Command 15*/
	logic SMB2SoundModDc    (byte Percentage);                       /* Command 16*/
	logic SMB2Filter        (byte Msbyte,byte Lsbyte);               /* Command 17*/
	logic SMB2FilterDc      (byte Percentage);                       /* Command 18*/
  logic SMB2SetRadioMode  (byte Mode);                             /* Command 19*/
	logic SMB2Init          (void);

#endif
