/***********************************************************/
/* (c) Peter Stuer 1996                                    */
/*                                                         */
/* AI-LAB Vrije Universiteit Brussel                       */
/*                                                         */
/***********************************************************/
/*                                                         */
/* Smb2pdl1.h vers 1.0                                     */
/*                                                         */
/***********************************************************/

#ifndef _SMB2PDL1_
	#define _SMB2PDL1_

	#include "smb2kern.h"

	
	struct quantity_struct;
	typedef struct quantity_struct *quantity;
	struct quantity_struct
	{
		char *name;
		float value;
		float min_value;
		float max_value;
		float new_value;
		byte (*FloatToByte)(float theFloat);
		float (*ByteToFloat)(byte theByte);
		quantity next_quantity;
	};


	quantity add_quantity (const char *name,float max,float min,float init_value);

	#define value(q) ((q) -> value)
	#define add_value(q,v) ((q) -> new_value) += (v)


	void add_process(const char *name,void (*theprocess)());

	void connect_sensor(byte selector, quantity q);
	void connect_actuator(byte selector, quantity q);

	void init_pdl(void);
	void pause_pdl(void);
	void run_pdl(long cyclecounter);

	void pause_robot(void);

	byte PDLDefaultFloatToByte(float theFloat);
	float PDLDefaultByteToFloat(byte theByte);



#endif
