#ifndef _PDL_H
#define _PDL_H
#include <cubeos.h>
#include <softreset.h>

// should not be declared here
int sleep (unsigned int howlong);
int usleep (unsigned int howlong);
int TPU_setpwmhigh (unsigned char nr, unsigned short hightime);


//#undef FQ
//#define IQ

#if !defined(FQ) &&!defined(IQ)
#error You have to define either IQ or FQ !
#endif

#if defined(FQ) && defined(IQ)
#error You have to define either IQ or FQ !
#endif

struct quantity_struct;
typedef struct quantity_struct *quantity;
struct actuator_struct;
typedef struct actuator_struct *actuator;
struct sensor_struct;
typedef struct sensor_struct *sensor;

#ifdef IQ
struct quantity_struct
{
  char *name;
  short int value;
  short int min_value;
  short int max_value;
  short int new_value; 
  short int a_sum;
  int a_count;
  actuator act;
  short int act_arg;
  sensor   sen;
  short int sen_arg;
  quantity next;
};
#endif
#ifdef FQ
struct quantity_struct
{
  char *name;
  float value;
  float min_value;
  float max_value;
  float new_value; 
  float a_sum;
  int a_count;
  actuator act;
  short int act_arg;
  sensor   sen;
  short int sen_arg;
  quantity next;
};
#endif

struct actuator_struct
{
  char *name;
  void (*set) (actuator a,quantity q);
  short int (*update) (actuator a);
  short int update_arg;
  short int value;
  short int inuse;
  actuator next;
};

struct sensor_struct
{
  char *name;
  void (*get) (sensor s,quantity q);
  short int (*update) (sensor s);
  short int update_arg;
  short int value;
  short int inuse;
  sensor next;
};
#ifdef IQ
quantity add_quantity(const char *name,short int max,short int min,short int init_value);
#endif

#ifdef FQ
quantity add_quantity(const char *name,float max,float min,float init_value);
#endif

#define value(q) ((q) -> value)
#define add_value(q,v) ((q) -> new_value) += (v)
#define asum_value(q,v) ((q) -> a_sum) += (v);(q)->a_count++
#define set_value(q,v) (((q) -> value) = (v))
#define set_new_value(q,v) (((q) -> new_value) = (v))
#define asum_clearvalue(q) ((q) -> a_sum)=0;(q)->a_count =0

#define next(q) ((q)->next)


void add_process(const char *name,void (*theprocess)());

void connect_sensor(sensor s, short int sen_arg, quantity q);
void connect_actuator(actuator a,short int act_arg, quantity q);

void init_pdl(void);
void pause_pdl(void);
void runpdl(long cyclecounter);

void pause_robot(void);

struct process_struct;
typedef struct process_struct *pdl_process;
struct process_struct {
  char *name;
  void (*the_process) ();
  pdl_process next;
};


void show_quantities();
void show_sensors();
void show_actuators();
void run_pdl(short int n);

extern quantity qlisthead ;
extern actuator alisthead ;
extern sensor slisthead ;
extern pdl_process plisthead;

extern sensor binin[2];
extern sensor adin[24];
extern actuator daout[6];
extern actuator binout[2];
extern actuator motor[3];
extern sensor qd[2];

#endif
