#include <stdio.h>
#include <cubeos.h>
#include <rdio.h>
#include <rsm.h>
#include <ptimer.h>
#include <comframe.h>
#include <softreset.c>

int parse_cf(struct comframe * frame);
int show_cf(struct comframe * frame);


int main ()
{
	int i,framecount;
	int ts1,tt1,ts2,tt2;
	int deltats,deltatt;

	char frame[RSM_FRAMELEN];
	


	printf ("\nRoboCup ComFrame receiver\n");
	if (sizeof(struct comframe) > RSM_FRAMELEN)
		{
		printf("comframe does not fit. Increase RSM_FRAMELEN\n");
		exit(-1);
		}
	framecount = 0;
	printf ("calling init_rsm_rx()\n");
	init_rsm_rx ();
	printf ("ok\n");

	disable();
	ts1=_time_seconds;tt1=_time_ticks;
	enable();

        for (i = 0; i < 100000; i++)
        {
                if (!rsm_get_frame(frame))
                        {
//			printf("c=%d\n",((struct comframe *)frame)->cmd);
			framecount ++;
			fflush(stdout);
			}
		if (!(i % 10000)) printf(".");fflush(stdout);
	}
	disable();
	ts2=_time_seconds;tt2=_time_ticks;
	enable();
	deinit_rsm_rx ();

	deltats = ts2-ts1;
	deltatt = tt2-tt1;
	if (deltatt<0)
		{
		deltatt = deltatt + TICKS_PER_SECOND;
		deltats -=1;
		}

	printf(" received %d frames\n",framecount);
	printf(" time was %d seconds, %d ticks",deltats,deltatt);
	printf(" framerate was %f frames/second\n",(framecount /(deltats+((deltatt*1.0)/TICKS_PER_SECOND))));

	printf(" contents of last frame received are:\n");
	show_cf((struct comframe *) frame);

	printf("\n");
	softreset();

	return (0);
}


int parse_cf(struct comframe * frame)
{
int i,n;

n = frame->cmd;

if (frame->ball.x != n) printf("BallX!");
if (frame->ball.y != -n) printf("BallY!");
for (i=0;i<5;i++){
	if (frame->player[i].x != i*10) printf("player%dx!",i);
	if (frame->player[i].y != i*10) printf("player%dy!",i);
	if (frame->player[i].alpha != i*20 ) printf("player%da!",i);
}
for (i=0;i<5;i++){
	if (frame->opponent[i].x != -i*10) printf("opp%dx!",i);
	if (frame->opponent[i].y != -i*10) printf("opp%dy!",i);
	if (frame->opponent[i].alpha != -i*20) printf("opp%da!",i);
}

return(0);
}

int show_cf(struct comframe * frame)
{
int i;

printf("BallX=%d\n",frame->ball.x);
 
printf("BallY=%d\n",frame->ball.y);
for (i=0;i<5;i++){
printf("player%dx=%d\n",i,frame->player[i].x);
printf("player%dy=%d\n",i,frame->player[i].y);
printf("player%da=%d\n",i,frame->player[i].alpha);
}
for (i=0;i<5;i++){
printf("opp%dx=%d\n",i,frame->opponent[i].x);
printf("opp%dy=%d\n",i,frame->opponent[i].y);
printf("opp%da=%d\n",i,frame->opponent[i].alpha);
}
printf("cmd=%d\n",frame->cmd);
return(0);
}

