#include <stdio.h>
#include <cubeos.h>
#include <rdio.h>
#include <rsm.h>
#include <ptimer.h>
#include <comframe.h>
#include <string.h>
#include <ttyio.h>

int fill_cf(struct comframe * frame);
int show_cf(struct comframe * frame);
int mygetline(char * buffer, int length);
int keyboard_cf(struct comframe * frame);

#define CMD_REMOTE 42
#define VLENGTH 150
#define VARIGHT -450
#define VALEFT 450

int main ()
{
	int i;
	int ret;
//	char frame[RSM_FRAMELEN];

	struct comframe cf;


	printf ("\nRoboCup ComFrame transmitter\n");
	if (sizeof(cf) > RSM_FRAMELEN)
		{
		printf("comframe does not fit. Increase RSM_FRAMELEN\n");
		exit(-1);
		}

	printf ("calling init_rsm_tx()\n");
	init_rsm_tx ();
	for(i=1;i<100000;i++);
	printf ("ok\n");
	fflush(stdout);
	conecho_off();

	while(1)
	{
		
		ret=keyboard_cf(&cf);
		if (ret){
			printf("%d?",ret);fflush(stdout);
		}
		else {
			rsm_send_frame((char *)&cf);
			printf("c%d@\n",cf.cmd);
		}
		fflush(stdout);
	}


	deinit_rsm_tx ();
	printf("\n");

	return (0);
}

int keyboard_cf(struct comframe * frame)
{
int i;
char c;

frame->cmd=CMD_REMOTE;
frame->ball.x=0;
frame->ball.y=0;

for (i=0;i<5;i++) {
	frame->player[i].x=0;
	frame->player[i].y=0;
	frame->player[i].alpha=0;
	frame->opponent[i].x=0;
	frame->opponent[i].y=0;
	frame->opponent[i].alpha=0;
	}

c = inchar();

switch (c) {
	case 'w':
		frame->player[0].x=VLENGTH;
		break;
	case 'a':
		frame->player[0].alpha=VALEFT;
		break;
	case 's':
		frame->player[0].alpha=VARIGHT;
		break;
	case 'z':
		frame->player[0].x=-VLENGTH;
		break;
	case 'i':
		frame->player[1].x=VLENGTH;
		break;
	case 'j':
		frame->player[1].alpha=VALEFT;
		break;
	case 'k':
		frame->player[1].alpha=VARIGHT;
		break;
	case 'm':
		frame->player[1].x=-VLENGTH;
		break;
	case 'W':
		frame->player[0].x=VLENGTH;
		frame->player[0].y=1;
		break;
	case 'A':
		frame->player[0].alpha=VALEFT;
		frame->player[0].y=1;
		break;
	case 'S':
		frame->player[0].alpha=VARIGHT;
		frame->player[0].y=1;
		break;
	case 'Z':
		frame->player[0].x=-VLENGTH;
		frame->player[0].y=1;
		break;
	case 'I':
		frame->player[1].x=VLENGTH;
		frame->player[1].y=1;
		break;
	case 'J':
		frame->player[1].alpha=VALEFT;
		frame->player[1].y=1;
		break;
	case 'K':
		frame->player[1].alpha=VARIGHT;
		frame->player[1].y=1;
		break;
	case 'M':
		frame->player[1].x=-VLENGTH;
		frame->player[1].y=1;
		break;
	default:
		return(2);

	}

return(0);
}


int fill_cf(struct comframe * frame)
{
int i;
int t1,t2,t3;
char line[256];
char line2[256];

do{
	mygetline(line,256);
} while(strncmp(line,"strt",4)); // As long as we don't see start

//printf("got strt\n");

mygetline(line,256);
if (strncmp(line,"ball",4))
	return(-1);


if ( sscanf(line+5,"%d %d",&t1,&t2) !=2)
	return(-2);

frame->ball.x=t1;
frame->ball.y=t2;

for (i=0;i<5;i++){
	mygetline(line,256);

	sprintf(line2,"plr%d",i);
	if (strncmp(line,line2,4))
		return(-3);

	if (sscanf(line+5,"%d %d %d",&t1,&t2,&t3) != 3)
		return(-4);

	frame->player[i].x=t1;
	frame->player[i].y=t2;
	frame->player[i].alpha=t3;

}
for (i=0;i<5;i++){
	mygetline(line,256);

	sprintf(line2,"opp%d",i);
	if (strncmp(line,line2,4))
		return(-5);

	if (sscanf(line+5,"%d %d %d",&t1,&t2,&t3) != 3)
		return(-6);

	frame->opponent[i].x=t1;
	frame->opponent[i].y=t2;
	frame->opponent[i].alpha=t3;

}

mygetline(line,256);


if (strncmp(line,"cmnd",4))
	return(-7);

if (sscanf(line+5,"%d",&t1) !=1)
	return(-8);

frame->cmd=t1;

//printf("line: >%s<,line +5: >%s<,t1= %d,cmd = %d",line,line+5,t1,frame->cmd);

return(0);
}



int mygetline(char * buffer, int length) 
{
	char c;
	int count;
	c = inchar();
	count=0;
	do {
		buffer[count] = c;
		count++;
		c = inchar();
	} while((c != '\r') && (c != '\n') && (count < (length-1)));

	if (  ( (c!='\r')&&(c!='\n') ) ||(count==0))
		return(-1);

	buffer[count] = 0;
	return(0);
}



int show_cf(struct comframe * frame)
{
int i;

printf("BallX=%d\n",frame->ball.x);
 
printf("BallY=%d\n",frame->ball.y);
for (i=0;i<5;i++){
printf("player%dx=%d\n",i,frame->player[i].x);
printf("player%dy=%d\n",i,frame->player[i].y);
printf("player%da=%d\n",i,frame->player[i].alpha);
}
for (i=0;i<5;i++){
printf("opp%dx=%d\n",i,frame->opponent[i].x);
printf("opp%dy=%d\n",i,frame->opponent[i].y);
printf("opp%da=%d\n",i,frame->opponent[i].alpha);
}
printf("cmd=%d\n",frame->cmd);
return(0);
}

