#include <stdio.h>
#include <cubeos.h>
#include <rdio.h>
#include <rsm.h>
#include <ptimer.h>
#include <comframe.h>

int parse_cf(struct comframe * frame);
int show_cf(struct comframe * frame);


int main ()
{
	int i,framecount;

	char frame[RSM_FRAMELEN];
	


	printf ("\nRoboCup ComFrame receiver\n");
	if (sizeof(struct comframe) > RSM_FRAMELEN)
		{
		printf("comframe does not fit. Increase RSM_FRAMELEN\n");
		exit(-1);
		}
	framecount = 0;
	printf ("calling init_rsm_rx()\n");
	init_rsm_rx ();
	printf ("ok\n");

        for (i = 0; i < 10000000; i++)
        {
                if (!rsm_get_frame(frame))
                        {
                         parse_cf((struct comframe *)frame);
			framecount ++;
			printf(".");
			fflush(stdout);
			}
	}

	printf(" received %d frames\n",framecount);

	printf(" contents of last frame received are:\n");
	show_cf((struct comframe *) frame);
	deinit_rsm_rx ();
	printf("\n");

	return (0);
}


int parse_cf(struct comframe * frame)
{
int i,n;

n = frame->cmd;

if (frame->ball.x != n) printf("BallX!");
if (frame->ball.y != -n) printf("BallY!");
for (i=0;i<5;i++){
	if (frame->player[i].x != i*10) printf("player%dx!",i);
	if (frame->player[i].y != i*10) printf("player%dy!",i);
	if (frame->player[i].alpha != i*20 ) printf("player%da!",i);
}
for (i=0;i<5;i++){
	if (frame->opponent[i].x != -i*10) printf("opp%dx!",i);
	if (frame->opponent[i].y != -i*10) printf("opp%dy!",i);
	if (frame->opponent[i].alpha != -i*20) printf("opp%da!",i);
}

return(0);
}

int show_cf(struct comframe * frame)
{
int i;

printf("BallX=%d\n",frame->ball.x);
 
printf("BallY=%d\n",frame->ball.y);
for (i=0;i<5;i++){
printf("player%dx=%d\n",i,frame->player[i].x);
printf("player%dy=%d\n",i,frame->player[i].y);
printf("player%da=%d\n",i,frame->player[i].alpha);
}
for (i=0;i<5;i++){
printf("opp%dx=%d",i,frame->opponent[i].x);
printf("opp%dy=%d",i,frame->opponent[i].y);
printf("opp%da=%d",i,frame->opponent[i].alpha);
}
printf("cmd=%d",frame->cmd);
return(0);
}

