#include <stdio.h>
#include <cubeos.h>
#include <rdio.h>
#include <rsm.h>
#include <ptimer.h>
#include <comframe.h>

int fill_cf(struct comframe * frame, int n);



int main ()
{
	int i;
//	char frame[RSM_FRAMELEN];

	struct comframe cf;


	printf ("\nRoboCup ComFrame transmitter\n");
	if (sizeof(cf) > RSM_FRAMELEN)
		{
		printf("comframe does not fit. Increase RSM_FRAMELEN\n");
		exit(-1);
		}

	printf ("calling init_rsm_tx()\n");
	init_rsm_tx ();
	for(i=1;i<100000;i++);
	printf ("ok\n");

	printf("Sending 200 test packets");
	fflush(stdout);
	for (i = 0; i < 200; i++)
	{
		fill_cf(&cf,i);
		rsm_send_frame((char *)&cf);
		printf(".");fflush(stdout);
	}


	deinit_rsm_tx ();
	printf("\n");

	return (0);
}


int fill_cf(struct comframe * frame, int n)
{
int i;

frame->ball.x = n;
frame->ball.y = -n;
for (i=0;i<5;i++){
	frame->player[i].x = i*10;
	frame->player[i].y = i*10;
	frame->player[i].alpha = i*20;
}
for (i=0;i<5;i++){
	frame->opponent[i].x = -i*10;
	frame->opponent[i].y = -i*10;
	frame->opponent[i].alpha = -i*20;
}
frame->cmd = n;
return(0);
}

