#ifndef _RECORDER_H
#define _RECORDER_H

extern void * _REC_memblock;
extern int _REC_rnum;
extern int _REC_rsize;
extern int _REC_rpcount;
extern int _REC_rcount;

#define REC_FAIL	-1
#define REC_OK		0
#define REC_FULL	1
#define REC_END		2
#define REC_UNKNOWN	3

struct driverec {
        int posx;
        int posy;
        int ori;
        int rspeed;
        int dspeed;
        int tspeedl;
        int tspeedr;
        int speedl;
        int speedr;
        int ticks;
};
struct driverec record;

int REC_init_recorder(int records,int recordlength);
int REC_rewind_rec();
int REC_rewind_play();
int REC_this(void * record);
void * REC_next();
int REC_status();


static inline int REC_get_rsize() {return _REC_rsize;}//!< interface to internal variable
static inline int REC_get_rnum() {return _REC_rnum;}//!< interface to internal variable
static inline int REC_get_rcount() {return _REC_rcount;}//!< interface to internal variable
static inline int REC_get_rpcount() {return _REC_rpcount;}//!< interface to internal variable
static inline void * _REC_get_memblock() {return _REC_memblock;}//!< interface to internal variable
#endif
