/*  src_experimental/attic/bcopy.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
#include <string.h>


void _DEFUN (bcopy, (src_void, dst_void, length),
	     _CONST char *src_void _AND
	     char *dst_void _AND
	     size_t length)
{
	char *dst = dst_void;
	_CONST char *src = src_void;

	if (src < dst && dst < src + length) {
		/* Have to copy backwards */
		src += length;
		dst += length;
		while (length--) {
			*--dst = *--src;
		}
	} else {
		while (length--) {
			*dst++ = *src++;
		}
	}

	return;
}
