/*  src_experimental/attic/hardware.h
    CubeOS Version 0.4.90 experimental
    Copyright (C) 1999,2000 Holger Kenn

    CubeOS is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or any later version.

    CubeOS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

*/  
/* Settings for SMBII board */
#define MT1P   6      /* Motor1 Pulse Width Modulation */
#define MT1A   7      /* Motor1 Pulse Accumulation     */
#define MT2P   8      /* Motor2 Pulse Width Modulation */
#define MT2A   9      /* Motor2 Pulse Accumulation     */
#define MT3P  10      /* Motor3 Pulse Width Modulation */
#define MT3A  11      /* Motor3 Pulse Accumulation     */
#define AIR0   0      /* Adaptive IR, Modulation frequency */
#define AIR1   1      /* Adaptive IR, Carrier frequency */
#define SND0   4      /* Sound, Carrier frequency */
#define SND1   5      /* Sound, Modulation freqency */
#define USOUT  3      /* Ultra Sound, Binary Out */
#define USOC  14      /* Ultra Sound, Output Capture */
#define USITC 12      /* Ultra Sound, Input Transistion Counter */
#define PDLCK 15      /* PDL clock */

#define MT1D1 2       /* direction input 1 of motor 1 ctrl */
#define MT1D2 3       /* direction input 2 of motor 1 ctrl */
#define MT2D1 4       /* direction input 1 of motor 2 ctrl */
#define MT2D2 5       /* direction input 2 of motor 2 ctrl */
#define MT3D1 6       /* direction input 1 of motor 3 ctrl */
#define MT3D2 7       /* direction input 2 of motor 3 ctrl */

