/*  src_experimental/attic/icontrol/sincos.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
#include <math.h>


short sintab[360];
short costab[360];


void init_sincos ()
{
	short i;


	for (i = 0; i < 360; i++) {
		sintab[i] = sin ((i / 360.0) * M_PI * 2) * 10000;
		costab[i] = cos ((i / 360.0) * M_PI * 2) * 10000;
		TTY_outchar ('.');
	}

//for (i=0;i<360;i++)
	// printf ("i=%d, \tsin=%d \tcos=%d\n",i,sintab[i],costab[i]);

}


/* mysin and mycos are normalized to +-10000 */

int mysin (int x)
{
	short y1;
	short y2;
	short where;

	x = (x % 36000);
	if (x < 0)
		x += 36000;

	where = x / 100;

	y1 = sintab[where];
	y2 = sintab[where + 1];

	return (y1 + (((x % 100) * (y2 - y1)) / 100));
}

int mycos (int x)
{

	short y1;
	short y2;
	short where;


	x = (x % 36000);
	if (x < 0)
		x += 36000;
	y1 = costab[where];
	y2 = costab[where + 1];

	return (y1 + (((x % 100) * (y2 - y1)) / 100));

}
