BEGIN {filename = "none"; print "log start" >"awk.log";}
{ 
 print "line: " $0 >>"awk.log";
 if (match ($3,"^__")) { print "skipping " $3 >>"awk.log"; next }
 if (match ($3,"^gcc2_compiled")) { print "skipping " $3 >>"awk.log";next }
 if (match ($3,"^\\.")) { print "rule 3 skipping " $3 >>"awk.log";next }
 if (match ($1 , ".o:") ) { 
	split ($1,fn,"\.");
	filename =fn[1];
        print "found file " fn[1] >>"awk.log";
	}

 if (($2=="T")||($2=="t")) {
	print "found " $3 " defined in " filename >>"awk.log";
	defined[$3]=filename;
	if (match($3,"Test")) {
		component[filename]="APP";
		print "assigning " filename " to component APP" >>"awk.log";
		next;
	}
	if (match(filename,"test")) {
		component[filename]="APP";
		print "assigning " filename " to component APP" >>"awk.log";
		next;
	}
	if (match($3,"_")) {
			   fields=split($3,cn,"_");
			   if (cn[1]=="") {
				if (fields==3) component[filename]=toupper(cn[2]);
				if (fields==4) component[filename]=toupper(cn[2]);
				} else {
			        if(fields==2) component[filename]=toupper(cn[1]);
			        if(fields==3) component[filename]=toupper(cn[1]);
				}
				print "assigning " filename " to component " component[filename] >>"awk.log";
			}	

	}
 if ($1=="U") {
	print "found " $2 " undefined in " filename >>"awk.log";
	undefined[$2] = filename;
	}
 if (match ($2 ,"[ABCDabcd]") && $3!="") {
	print "found " $3 " defined in " filename >>"awk.log";
	defined[$3]=filename;
	}
}
END { 
      for (file in component) {
			print "file " file " \t\tcomponent " component[file] >>"awk.log";
#			if (file=="init"||file=="readcmd"||file="irq4wrap"||file="schedtest") {
			if (file=="init") {
				component[file]="APP";
				print "   changing to APP" >>"awk.log";
				}
			if (file=="config") {
				component[file]="APP";
				print "   changing to APP" >>"awk.log";
				}
			if (file=="io_sci") {
				component[file]="SCI";
				print "   changing to SCI" >>"awk.log";
				}
			if (file=="io_duart") {
				component[file]="DUART";
				print "   changing to DUART" >>"awk.log";
				}
			if (file=="crt0") {
				component[file]="KERN";
				print "   changing to KERN" >>"awk.log";
				}
			componentlist[component[file]]="bla";
	}
      for (c in componentlist) for (f in component) if (c==component[f]) print c " " f >>"awk.log";

      for (name in undefined) if (component[defined[name]]=="") {
			component[defined[name]]="NEWLIB";
			print "redefining " name >>"awk.log";
			}
#     print "/* object file dependency graph */";
#     print " digraph objects {";
#     print " size=\"10,10\";";
#     print " node [shape = \"box\"];";
#
#     for (name in undefined) print "\"" defined[name] "\" -> \"" undefined[name] "\"";
#     print "}";
#     print "/* object file dependency graph */";
#     print " digraph objects {";
#     print " size=\"6,6\";";
#     print " node [shape = \"box\"];";
#     for (c in componentlist) print c ";";
     for (name in undefined)

#	    (component[defined[name]]!="") &&\
	if (\
	    (component[defined[name]] != component[undefined[name]]) &&\
	    (component[undefined[name]]!="") )\
#	 print "\"" component[undefined[name]] "\" -> \"" component[defined[name]] "\" /* [label=\"" name "\"] */";
	 print "\"" component[undefined[name]] "\" -> \"" component[defined[name]] "\"";

#     print "}";
}
