# 1 "drivers/tpu/tpud.c"
 














# 1 "kernel/cubeos.h" 1
 













  



# 1 "config/config.h" 1
 













  



# 1 "config/asm_config.h" 1
 













  


# 19 "config/config.h" 2






struct config_struct {
	unsigned int  eprom_base;
	unsigned int  cpuram_base;
	unsigned int  duart_base;
	unsigned char  ptimer_vn;
	unsigned int  sci_base;
	unsigned char  sciqsm_vn;
	unsigned int  tpu_base;
	unsigned char  tpu_vn;
	unsigned int  i2ca_base;
	unsigned int  i2cb_base;
	unsigned char  i2ca_vn;
	unsigned char  i2cb_vn;
	unsigned int  fastbin_base;
	unsigned int  rcjfb_base;
	unsigned int  rcj_base;
	unsigned int  rg_base;
	unsigned char  i2ca_initcs;
	unsigned char  i2cb_initcs;
};







# 1 "config/rg_config.h" 1
 













  






 







 

 
 

 

 




 

 


# 52 "config/config.h" 2


# 87 "config/config.h"






# 19 "kernel/cubeos.h" 2

# 1 "hardware/mc68332.h" 1
 













  
 



























































# 20 "kernel/cubeos.h" 2

# 1 "kernel/sys_var.h" 1
 













  


extern int _KERN_sys_error;
extern unsigned short _KERN_sys_errorcode;
extern unsigned char TTY_Blocking_Serial_Out;
extern unsigned long _time_seconds;
extern unsigned short _time_ticks;
extern unsigned short _KERN_quantum_count;
extern unsigned short _KERN_context_srsave;
extern int __MYPID;
extern int _KERN_disablecount;
extern unsigned short KERN_srsave;
void KERN_sysvarinit();

 






# 21 "kernel/cubeos.h" 2

# 1 "kernel/schedule.h" 1
 













  




# 1 "kernel/context.h" 1
 













  
 
 

























typedef struct regs *regptr;

typedef struct regs {
	long regs[19 ];
} reglist;

 















 void KERN_contextsw(regptr oldarea,regptr newarea);



# 20 "kernel/schedule.h" 2

# 1 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/reent.h" 1 3
 

 


































 









# 1 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/sys/reent.h" 1 3
 

 









# 1 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/_ansi.h" 1 3
 

 











# 1 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/sys/config.h" 1 3



 
 
# 14 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/sys/config.h" 3


# 25 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/sys/config.h" 3


 








# 44 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/sys/config.h" 3













































 
















typedef int __int32_t;
typedef unsigned int __uint32_t;








# 15 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/_ansi.h" 2 3


 
 

























# 61 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/_ansi.h" 3


 








# 13 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/sys/reent.h" 2 3

# 1 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/time.h" 1 3
 


















 
# 1 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/machine/time.h" 1 3










# 21 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/time.h" 2 3









# 1 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 1 3






 


# 19 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3



 


 





 


# 61 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3


 





 


















 





 

 

# 131 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3


 

 


































typedef long unsigned int size_t;






















 




 

# 271 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3


# 283 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3


 

 

# 317 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3




 





















# 30 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/time.h" 2 3


 
# 1 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/machine/types.h" 1 3









# 33 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/time.h" 2 3



typedef unsigned long  clock_t;




typedef long  time_t;



struct tm
{
  int	tm_sec;
  int	tm_min;
  int	tm_hour;
  int	tm_mday;
  int	tm_mon;
  int	tm_year;
  int	tm_wday;
  int	tm_yday;
  int	tm_isdst;
};

clock_t	    clock       (void)  ;
double	    difftime    (time_t _time2, time_t _time1)  ;
time_t	    mktime      (struct tm *_timeptr)  ;
time_t	    time        (time_t *_timer)  ;

char	  *  asctime     (const struct tm *_tblock)  ;
char	  *  ctime       (const time_t *_time)  ;
struct tm *  gmtime      (const time_t *_timer)  ;
struct tm *  localtime   (const time_t *_timer)  ;

size_t	    strftime    (char *_s, size_t _maxsize, const char *_fmt, const struct tm *_t)  ;

char	  *  asctime_r   	(const struct tm *, char *)  ;
char	  *  ctime_r   	(const time_t *, char *)  ;
struct tm *  gmtime_r   	(const time_t *, struct tm *)  ;
struct tm *  localtime_r   	(const time_t *, struct tm *)  ;

# 84 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/time.h" 3







# 14 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/sys/reent.h" 2 3














typedef __uint32_t __ULong;


struct _glue 
{
  struct _glue *_next;
  int _niobs;
  struct __sFILE *_iobs;
};

struct _Bigint 
{
  struct _Bigint *_next;
  int _k, _maxwds, _sign, _wds;
  __ULong _x[1];
};

 





struct _atexit {
	struct	_atexit *_next;			 
	int	_ind;				 
	void	(*_fns[32 ])(void);	 
};

 






struct __sbuf {
	unsigned char *_base;
	int	_size;
};

 




typedef long _fpos_t;		 
				 

 
























struct __sFILE {
  unsigned char *_p;	 
  int	_r;		 
  int	_w;		 
  short	_flags;		 
  short	_file;		 
  struct __sbuf _bf;	 
  int	_lbfsize;	 

   
  void * 	_cookie;	 

  int	 (*_read)   (void *  _cookie, char *_buf, int _n)  ;
  int	 (*_write)   (void *  _cookie, const char *_buf, int _n)  ;
  _fpos_t  (*_seek)   (void *  _cookie, _fpos_t _offset, int _whence)  ;
  int	 (*_close)   (void *  _cookie)  ;

   
  struct __sbuf _ub;	 
  unsigned char *_up;	 
  int	_ur;		 

   
  unsigned char _ubuf[3];	 
  unsigned char _nbuf[1];	 

   
  struct __sbuf _lb;	 

   
  int	_blksize;	 
  int	_offset;	 

  struct _reent *_data;
};

 







struct _reent
{
   
  int _errno;

   


  struct __sFILE *_stdin, *_stdout, *_stderr;

  int  _inc;			 
  char _emergency[25];
 
  int _current_category;	 
  const  char *_current_locale;

  int __sdidinit;		 

  void  (*__cleanup)   (struct _reent *)  ;

   
  struct _Bigint *_result;
  int _result_k;
  struct _Bigint *_p5s;
  struct _Bigint **_freelist;

   
  int _cvtlen;			 
  char *_cvtbuf;

  union
    {
      struct
        {
          unsigned int _rand_next;
          char * _strtok_last;
          char _asctime_buf[26];
          struct tm _localtime_buf;
          int _gamma_signgam;
        } _reent;
   

 
      struct
        {

          unsigned char * _nextf[30 ];
          unsigned int _nmalloc[30 ];
        } _unused;
    } _new;

   
  struct _atexit *_atexit;	 
  struct _atexit _atexit0;	 

   
  void (**(_sig_func))(int);

   


  struct _glue __sglue;			 
  struct __sFILE __sf[3];		 
};






 








extern struct _reent *_impure_ptr  ;

void _reclaim_reent  (struct _reent *)  ;

 









# 48 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/reent.h" 2 3

# 1 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/sys/_types.h" 1 3
 

 








typedef long _off_t;
typedef long _ssize_t;


# 49 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/reent.h" 2 3




# 1 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 1 3






 


# 19 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3



 


 





 


# 61 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3


 





 


















 





 

 

# 131 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3


 

 


# 188 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3





 




 

# 271 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3


# 283 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3


 

 

# 317 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3




 





















# 53 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/reent.h" 2 3


 
struct stat;
struct tms;
struct timeval;
struct timezone;

 

extern int _close_r  (struct _reent *, int)  ;
extern int _execve_r  (struct _reent *, char *, char **, char **)  ;
extern int _fcntl_r  (struct _reent *, int, int, int)  ;
extern int _fork_r  (struct _reent *)  ;
extern int _fstat_r  (struct _reent *, int, struct stat *)  ;
extern int _getpid_r  (struct _reent *)  ;
extern int _kill_r  (struct _reent *, int, int)  ;
extern int _link_r  (struct _reent *, const char *, const char *)  ;
extern _off_t _lseek_r  (struct _reent *, int, _off_t, int)  ;
extern int _open_r  (struct _reent *, const char *, int, int)  ;
extern _ssize_t _read_r  (struct _reent *, int, void *, size_t)  ;
extern void *_sbrk_r  (struct _reent *, size_t)  ;
extern int _stat_r  (struct _reent *, const char *, struct stat *)  ;
extern unsigned long  _times_r  (struct _reent *, struct tms *)  ;
extern int _unlink_r  (struct _reent *, const char *)  ;
extern int _wait_r  (struct _reent *, int *)  ;
extern _ssize_t _write_r  (struct _reent *, int, const void *, size_t)  ;

 
extern int _gettimeofday_r  (struct _reent *, struct timeval *tp, struct timezone *tzp)  ;





# 21 "kernel/schedule.h" 2

# 1 "kernel/list.h" 1
 













  
 








typedef struct list_s list;
typedef struct entry_s entry;
struct entry_s {
list * list;
entry * prev;
entry * next;
void * data;
int len;
} ;

struct list_s
{
entry * head;
entry * tail;
int entries;
int type;
};

entry *LIST_head(list *l);
entry *LIST_tail(list *l);
int LIST_entries(list *l);
void LIST_init(list * l);
void LIST_insert_after(entry * e,entry *x);
void LIST_insert_before(entry * e,entry *x);
void LIST_insert_head(list *l,entry *e);
void LIST_insert_tail(list *l,entry *e);
void LIST_delete(entry *e);
void LIST_makeentry(entry *e);


# 22 "kernel/schedule.h" 2

 










 




struct process {
	reglist regs;	 
	void *stack;	 
	char state;      
	char irq;	 
	int signal;	 
	int mask;	 
	int ppid;	 
	struct _reent reent;  
	int message;	 
	struct sem_t * sem;   
	unsigned int time_delta;  

	int prio;	 
	entry me;        
	int pid;	 
	int next; 
};
extern struct process _KERN_ptable[16 ];  
 
extern list _KERN_delta;			     
extern list _KERN_prio[16 +1];
int KERN_schedinit();
int KERN_delta_handler();
int KERN_create(void * function);
void KERN_schedule(void);
int getpid();
 
 
int KERN_suspend(int i);
int wakeup(int i);

# 22 "kernel/cubeos.h" 2

# 1 "kernel/taskconst.h" 1
 













  









# 23 "kernel/cubeos.h" 2

 








 








# 63 "kernel/cubeos.h"

static inline void disable()
{
	asm("ori.w #0x0700,%sr");   
}
static inline void enable()
{
	asm("move.w #0x2000,%sr"); 
}




# 1 "kernel/seminl.h" 1
 













  




 
typedef struct sem_s {
	int init;
	int c;
	int task;
	} sem_t;
 


static inline void sem_post(sem_t x)
{
	if (!x.init) return;
	disable();
	x.c++;
	if (x.task!= -1 )
	{
		wakeup(x.task);  
						 
 		x.task=_KERN_ptable[x.task].next;
	}
	enable();
}





static inline void sem_wait(sem_t x)
{
	if (!x.init) return;
	disable();	
	x.c--;
	if (x.c<0){
		 
		if (x.task == -1 )
		{
			_KERN_ptable[getpid()].next= -1 ;
		} 
		else
		{
			_KERN_ptable[getpid()].next=x.task;
		}
		x.task=getpid();
		enable();
		KERN_suspend(getpid());
	} 
	else 
	{
		enable();  
	}
}




 
static inline int sem_init(sem_t x,int i,int v)
{
	if (x.init) return (-1);
	disable();
	x.c=v;
	x.task= -1 ;
	x.init=1;
	enable();
	return (0);
}

static inline int sem_destroy(sem_t x)
{
	if (!x.init) return (-1);
	disable();
	while(x.task!= -1 )
		{
			wakeup(x.task);  
							 
 			x.task=_KERN_ptable[x.task].next;
		}
	enable();
	return(0);
}


# 76 "kernel/cubeos.h" 2


# 100 "kernel/cubeos.h"




 
 
 
 
 
 
 
 










 












 










 



static inline void init_LED()
{
*(char *)( 0xfffa00  + 0x11  ) =  0x0  ;
*(char *)( 0xfffa00  + 0x15  ) =  0x8  ;
*(char *)( 0xfffa00  + 0x17  ) =  0xf7  ;
}
 
static inline void LED_ON()
{
*(char *)( 0xfffa00  + 0x11  ) =  0x8  ;
}

 
static inline void LED_OFF()
{
*(char *)( 0xfffa00  + 0x11  ) =  0x0  ;
}


# 16 "drivers/tpu/tpud.c" 2

# 1 "hardware/mc68681.h" 1
 













  
 
































# 17 "drivers/tpu/tpud.c" 2

# 1 "hardware/tpu.h" 1
 













  
 




































































# 18 "drivers/tpu/tpud.c" 2

# 1 "drivers/tpu/tpud.h" 1
 













  







int TPU_init();
int TPU_makepwm(unsigned char nr);
int TPU_initchannel(unsigned char nr);
int TPU_setpwmperiod(unsigned char nr, unsigned short period);
int TPU_setpwmdc(unsigned char nr, unsigned char hightime);
int TPU_makepac(unsigned char nr);
int TPU_makeqd(unsigned char ch1,unsigned char ch2);
unsigned short TPU_getpac(unsigned char nr);
short TPU_getqd(unsigned char nr);
short TPU_readqd(unsigned char nr);
int TPU_setisr(unsigned char ch, void (*isr) (void));
int TPU_clearisr(unsigned char ch, void (*isr) (void));
int TPU_makedio(unsigned char nr);
int TPU_setdio(unsigned char nr, unsigned char v);




# 19 "drivers/tpu/tpud.c" 2

# 1 "kernel/ivtab.h" 1
 













  





extern void (*(*_KERN_IVTab)[512]) (void);

extern void *_KERN_IVTab_oldvector[512];

void _KERN_IVTab_init();
int _KERN_IVTab_setvector(unsigned short vector, void (*isr) (void));
int _KERN_IVTab_clearvector(unsigned short vector, void (*isr) (void));


# 20 "drivers/tpu/tpud.c" 2




 










































int TPU_init ()
{

 
 
 
 
 
	*(short *)( (0xfffe00  +  0x0 )   ) =   0x0acd    ;  
 
 
 


 















 

	*(short *)( (0xfffe00  +  0x08 )   ) =   0x480    ;

 



	*(short *)( (0xfffe00  +  0x0a )   ) =   0  ;	 

	return (0);

}


 



int TPU_initchannel (unsigned char nr)
{
	*(short *)(  (0xfffe00  +  0x0c )   + ((3-( nr /4))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x0c )   + ((3-( nr /4))<<1)  )) 	&(~(( 0xf )<<( ( nr &0x3)<<2 )))) |((( 0xf )&   0  )<<( ( nr &0x3)<<2 ))    ;	 
	*(short *)(  (0xfffe00  +  0x18 )  +((1-( nr /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x18 )  +((1-( nr /8))<<1)  )) 	&(~(( 0x3 )<<( ( nr &0x7)<<1 )))) |((( 0x3 )&   0  )<<( ( nr &0x7)<<1 ))    ;	 
	*(short *)(  (0xfffe00  +  0x0a )    ) =  ((*(short *)(void *)(  (0xfffe00  +  0x0a )    )) 	&(~(( 0x1 )<<(  nr  )))) |((( 0x1 )&   0  )<<(  nr  ))    ;	 
	*(short *)(  (0xfffe00  +  0x1c )  +((1-( nr /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x1c )  +((1-( nr /8))<<1)  )) 	&(~(( 0x3 )<<( ( nr &0x7)<<1 )))) |((( 0x3 )&   0  )<<( ( nr &0x7)<<1 ))    ;		 
	return (0);
}

 



int TPU_makedio (unsigned char nr)
{

	*(short *)(  (0xfffe00  +  0x0c )   + ((3-( nr /4))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x0c )   + ((3-( nr /4))<<1)  )) 	&(~(( 0xf )<<( ( nr &0x3)<<2 )))) |((( 0xf )&   8  )<<( ( nr &0x3)<<2 ))    ;	 
	*(short *)(  (0xfffe00  +  0x18 )  +((1-( nr /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x18 )  +((1-( nr /8))<<1)  )) 	&(~(( 0x3 )<<( ( nr &0x7)<<1 )))) |((( 0x3 )&   2  )<<( ( nr &0x7)<<1 ))    ;	 
	*(short *)(  (0xfffe00  +  0x0a )    ) =  ((*(short *)(void *)(  (0xfffe00  +  0x0a )    )) 	&(~(( 0x1 )<<(  nr  )))) |((( 0x1 )&   0  )<<(  nr  ))    ;	 
	*(short *)(  (0xfffe00  +  0x1c )  +((1-( nr /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x1c )  +((1-( nr /8))<<1)  )) 	&(~(( 0x3 )<<( ( nr &0x7)<<1 )))) |((( 0x3 )&   1  )<<( ( nr &0x7)<<1 ))    ;		 
	return (0);
}

 




int TPU_setdio (unsigned char nr, unsigned char v)
{
	if (nr > 15) {
		return (-1);
	}
	if ((((*(short *)(void *)(  (0xfffe00  +  0x0c )   + ((3-( nr /4))<<1)  )) >>( ( nr &0x3)<<2 ))&( 0xf ))   != 8) {
		return (-1);
	}
	if (v == 255) {		 
		*(short *)(  (0xfffe00  +  0x14 )  +((1-( nr /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x14 )  +((1-( nr /8))<<1)  )) 	&(~(( 0x3 )<<( ( nr &0x7)<<1 )))) |((( 0x3 )&   0  )<<( ( nr &0x7)<<1 ))    ;
		*(short *)(  (0xfffe00  +  0x18 )  +((1-( nr /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x18 )  +((1-( nr /8))<<1)  )) 	&(~(( 0x3 )<<( ( nr &0x7)<<1 )))) |((( 0x3 )&   3  )<<( ( nr &0x7)<<1 ))    ;
	} else {
		if (v) {
			*(short *)(  (0xfffe00  +  0x18 )  +((1-( nr /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x18 )  +((1-( nr /8))<<1)  )) 	&(~(( 0x3 )<<( ( nr &0x7)<<1 )))) |((( 0x3 )&   1  )<<( ( nr &0x7)<<1 ))    ;
		} else {
			*(short *)(  (0xfffe00  +  0x18 )  +((1-( nr /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x18 )  +((1-( nr /8))<<1)  )) 	&(~(( 0x3 )<<( ( nr &0x7)<<1 )))) |((( 0x3 )&   2  )<<( ( nr &0x7)<<1 ))    ;
		}
	}
	return (0);
}

 


int TPU_makepwm_TCR1 (unsigned char nr)
{

	*(short *)(  (0xfffe00  +  0x0c )   + ((3-( nr /4))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x0c )   + ((3-( nr /4))<<1)  )) 	&(~(( 0xf )<<( ( nr &0x3)<<2 )))) |((( 0xf )&   9  )<<( ( nr &0x3)<<2 ))    ;	 
	*(short *)( (0xfffe00  +  0x100 )  +( nr *16)+(  0 <<1) ) =    0x8c    ;	 
	*(short *)( (0xfffe00  +  0x100 )  +( nr *16)+(  2 <<1) ) =    0    ;	 
	*(short *)( (0xfffe00  +  0x100 )  +( nr *16)+(  3 <<1) ) =    20875    ;	 
	*(short *)(  (0xfffe00  +  0x18 )  +((1-( nr /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x18 )  +((1-( nr /8))<<1)  )) 	&(~(( 0x3 )<<( ( nr &0x7)<<1 )))) |((( 0x3 )&   2  )<<( ( nr &0x7)<<1 ))    ;	 
	*(short *)(  (0xfffe00  +  0x0a )    ) =  ((*(short *)(void *)(  (0xfffe00  +  0x0a )    )) 	&(~(( 0x1 )<<(  nr  )))) |((( 0x1 )&   0  )<<(  nr  ))    ;	 
	*(short *)(  (0xfffe00  +  0x1c )  +((1-( nr /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x1c )  +((1-( nr /8))<<1)  )) 	&(~(( 0x3 )<<( ( nr &0x7)<<1 )))) |((( 0x3 )&   2  )<<( ( nr &0x7)<<1 ))    ;		 
	return (0);

}

 


int TPU_makepwm_TCR2 (unsigned char nr)
{

	*(short *)(  (0xfffe00  +  0x0c )   + ((3-( nr /4))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x0c )   + ((3-( nr /4))<<1)  )) 	&(~(( 0xf )<<( ( nr &0x3)<<2 )))) |((( 0xf )&   9  )<<( ( nr &0x3)<<2 ))    ;	 
	*(short *)( (0xfffe00  +  0x100 )  +( nr *16)+(  0 <<1) ) =    0xdc    ;	 
	*(short *)( (0xfffe00  +  0x100 )  +( nr *16)+(  2 <<1) ) =    0    ;	 
	*(short *)( (0xfffe00  +  0x100 )  +( nr *16)+(  3 <<1) ) =    20875    ;	 
	*(short *)(  (0xfffe00  +  0x18 )  +((1-( nr /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x18 )  +((1-( nr /8))<<1)  )) 	&(~(( 0x3 )<<( ( nr &0x7)<<1 )))) |((( 0x3 )&   2  )<<( ( nr &0x7)<<1 ))    ;	 
	*(short *)(  (0xfffe00  +  0x0a )    ) =  ((*(short *)(void *)(  (0xfffe00  +  0x0a )    )) 	&(~(( 0x1 )<<(  nr  )))) |((( 0x1 )&   0  )<<(  nr  ))    ;	 
	*(short *)(  (0xfffe00  +  0x1c )  +((1-( nr /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x1c )  +((1-( nr /8))<<1)  )) 	&(~(( 0x3 )<<( ( nr &0x7)<<1 )))) |((( 0x3 )&   2  )<<( ( nr &0x7)<<1 ))    ;		 
	return (0);

}


 


int TPU_makepwm (unsigned char nr)
{
	return TPU_makepwm_TCR2 (nr);
}

 




int TPU_setpwmperiod (unsigned char nr, unsigned short period)
{
	int i;

	if (nr > 15) {
		return (-1);
	}
	if ((((*(short *)(void *)(  (0xfffe00  +  0x0c )   + ((3-( nr /4))<<1)  )) >>( ( nr &0x3)<<2 ))&( 0xf ))   != 9) {
		return (-1);
	}
	i = 0;
	while (((((*(short *)(void *)(  (0xfffe00  +  0x18 )  +((1-( nr /8))<<1)  )) >>( ( nr &0x7)<<1 ))&( 0x3 ))   != 0) && (i < 1000 ))
		i++;
	if (i >= 1000 ) {
		return (-1);
	}
	*(short *)( (0xfffe00  +  0x100 )  +( nr *16)+(  3 <<1) ) =    period    ;	 
	*(short *)(  (0xfffe00  +  0x18 )  +((1-( nr /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x18 )  +((1-( nr /8))<<1)  )) 	&(~(( 0x3 )<<( ( nr &0x7)<<1 )))) |((( 0x3 )&   1  )<<( ( nr &0x7)<<1 ))    ;	 
	return (0);
}

int TPU_setpwmdc (unsigned char nr, unsigned char hightime)
{
	int i;
	unsigned long t;

	if (nr > 15) {
		return (-1);
	}
	if ((((*(short *)(void *)(  (0xfffe00  +  0x0c )   + ((3-( nr /4))<<1)  )) >>( ( nr &0x3)<<2 ))&( 0xf ))   != 9) {
		return (-1);
	}
	if (hightime > 100) {
		return (-1);
	}
	i = 0;
	while (((((*(short *)(void *)(  (0xfffe00  +  0x18 )  +((1-( nr /8))<<1)  )) >>( ( nr &0x7)<<1 ))&( 0x3 ))   != 0) && (i < 1000 ))
		i++;
	if (i >= 1000 ) {
		return (-1);
	}
	t = ((*(short *)(void *)( (0xfffe00  +  0x100 )  +( nr *16)+(  3 <<1) ))   * hightime) / 100;	 

	*(short *)( (0xfffe00  +  0x100 )  +( nr *16)+(  2 <<1) ) =    (unsigned short) t    ;	 
	*(short *)(  (0xfffe00  +  0x18 )  +((1-( nr /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x18 )  +((1-( nr /8))<<1)  )) 	&(~(( 0x3 )<<( ( nr &0x7)<<1 )))) |((( 0x3 )&   1  )<<( ( nr &0x7)<<1 ))    ;	 
	return (0);
}
int TPU_setpwmhigh (unsigned char nr, unsigned short hightime)
{
	if (nr > 15) {
		return (-1);
	}
	if ((((*(short *)(void *)(  (0xfffe00  +  0x0c )   + ((3-( nr /4))<<1)  )) >>( ( nr &0x3)<<2 ))&( 0xf ))   != 9) {
		return (-1);
	}
	*(short *)( (0xfffe00  +  0x100 )  +( nr *16)+(  2 <<1) ) =    (unsigned short) hightime    ;
	 
	return (0);
}

int TPU_makepac (unsigned char nr)
{
	*(short *)(  (0xfffe00  +  0x0c )   + ((3-( nr /4))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x0c )   + ((3-( nr /4))<<1)  )) 	&(~(( 0xf )<<( ( nr &0x3)<<2 )))) |((( 0xf )&   10  )<<( ( nr &0x3)<<2 ))    ;	 
	*(short *)(  (0xfffe00  +  0x14 )  +((1-( nr /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x14 )  +((1-( nr /8))<<1)  )) 	&(~(( 0x3 )<<( ( nr &0x7)<<1 )))) |((( 0x3 )&   1  )<<( ( nr &0x7)<<1 ))    ;	 
	*(short *)( (0xfffe00  +  0x100 )  +( nr *16)+(  0 <<1) ) =    0x4    ;	 
	*(short *)( (0xfffe00  +  0x100 )  +( nr *16)+(  2 <<1) ) =    0xffff    ;	 
	*(short *)(  (0xfffe00  +  0x18 )  +((1-( nr /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x18 )  +((1-( nr /8))<<1)  )) 	&(~(( 0x3 )<<( ( nr &0x7)<<1 )))) |((( 0x3 )&   1  )<<( ( nr &0x7)<<1 ))    ;	 
	*(short *)(  (0xfffe00  +  0x0a )    ) =  ((*(short *)(void *)(  (0xfffe00  +  0x0a )    )) 	&(~(( 0x1 )<<(  nr  )))) |((( 0x1 )&   0  )<<(  nr  ))    ;	 
	*(short *)(  (0xfffe00  +  0x1c )  +((1-( nr /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x1c )  +((1-( nr /8))<<1)  )) 	&(~(( 0x3 )<<( ( nr &0x7)<<1 )))) |((( 0x3 )&   2  )<<( ( nr &0x7)<<1 ))    ;		 
	return (0);

}

unsigned short TPU_getpac (unsigned char nr)
{
	unsigned short v;

	if (nr > 15) {
		return (0);
	}
	if ((((*(short *)(void *)(  (0xfffe00  +  0x0c )   + ((3-( nr /4))<<1)  )) >>( ( nr &0x3)<<2 ))&( 0xf ))   != 10) {
		return (0);
	}
	v = (*(short *)(void *)( (0xfffe00  +  0x100 )  +( nr *16)+(  3 <<1) ))  ;	 
	*(short *)(  (0xfffe00  +  0x18 )  +((1-( nr /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x18 )  +((1-( nr /8))<<1)  )) 	&(~(( 0x3 )<<( ( nr &0x7)<<1 )))) |((( 0x3 )&   1  )<<( ( nr &0x7)<<1 ))    ;	 
	return (v);

}




int TPU_makeqd (unsigned char ch1, unsigned char ch2)
{

	*(short *)(  (0xfffe00  +  0x1c )  +((1-( ch1 /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x1c )  +((1-( ch1 /8))<<1)  )) 	&(~(( 0x3 )<<( ( ch1 &0x7)<<1 )))) |((( 0x3 )&   0  )<<( ( ch1 &0x7)<<1 ))    ;	 
	*(short *)(  (0xfffe00  +  0x1c )  +((1-( ch2 /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x1c )  +((1-( ch2 /8))<<1)  )) 	&(~(( 0x3 )<<( ( ch2 &0x7)<<1 )))) |((( 0x3 )&   0  )<<( ( ch2 &0x7)<<1 ))    ;

	*(short *)(  (0xfffe00  +  0x0c )   + ((3-( ch1 /4))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x0c )   + ((3-( ch1 /4))<<1)  )) 	&(~(( 0xf )<<( ( ch1 &0x3)<<2 )))) |((( 0xf )&   0x6   )<<( ( ch1 &0x3)<<2 ))    ;	 
	*(short *)(  (0xfffe00  +  0x0c )   + ((3-( ch2 /4))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x0c )   + ((3-( ch2 /4))<<1)  )) 	&(~(( 0xf )<<( ( ch2 &0x3)<<2 )))) |((( 0xf )&   0x6   )<<( ( ch2 &0x3)<<2 ))    ;
	*(short *)( (0xfffe00  +  0x100 )  +( ch1 *16)+(  4  <<1) ) =    ch2 * 16 + 3  * 2    ;
	*(short *)( (0xfffe00  +  0x100 )  +( ch2 *16)+(  4  <<1) ) =    ch1 * 16 + 3  * 2    ;
	*(short *)( (0xfffe00  +  0x100 )  +( ch1 *16)+(  5  <<1) ) =    ch2 * 16 + 1    ;
	*(short *)( (0xfffe00  +  0x100 )  +( ch2 *16)+(  5  <<1) ) =    ch2 * 16 + 1    ;
	*(short *)( (0xfffe00  +  0x100 )  +( ch1 *16)+(  1  <<1) ) =    0x8000    ;
	*(short *)( (0xfffe00  +  0x100 )  +( ch2 *16)+(  1  <<1) ) =    0x8000    ;	 


	*(short *)(  (0xfffe00  +  0x14 )  +((1-( ch1 /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x14 )  +((1-( ch1 /8))<<1)  )) 	&(~(( 0x3 )<<( ( ch1 &0x7)<<1 )))) |((( 0x3 )&   0  )<<( ( ch1 &0x7)<<1 ))    ;
	*(short *)(  (0xfffe00  +  0x14 )  +((1-( ch2 /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x14 )  +((1-( ch2 /8))<<1)  )) 	&(~(( 0x3 )<<( ( ch2 &0x7)<<1 )))) |((( 0x3 )&   1  )<<( ( ch2 &0x7)<<1 ))    ;
	*(short *)(  (0xfffe00  +  0x18 )  +((1-( ch1 /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x18 )  +((1-( ch1 /8))<<1)  )) 	&(~(( 0x3 )<<( ( ch1 &0x7)<<1 )))) |((( 0x3 )&   3  )<<( ( ch1 &0x7)<<1 ))    ;
	*(short *)(  (0xfffe00  +  0x18 )  +((1-( ch2 /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x18 )  +((1-( ch2 /8))<<1)  )) 	&(~(( 0x3 )<<( ( ch2 &0x7)<<1 )))) |((( 0x3 )&   3  )<<( ( ch2 &0x7)<<1 ))    ;
	*(short *)(  (0xfffe00  +  0x1c )  +((1-( ch1 /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x1c )  +((1-( ch1 /8))<<1)  )) 	&(~(( 0x3 )<<( ( ch1 &0x7)<<1 )))) |((( 0x3 )&   2  )<<( ( ch1 &0x7)<<1 ))    ;	 
	*(short *)(  (0xfffe00  +  0x1c )  +((1-( ch2 /8))<<1)  ) =  ((*(short *)(void *)(  (0xfffe00  +  0x1c )  +((1-( ch2 /8))<<1)  )) 	&(~(( 0x3 )<<( ( ch2 &0x7)<<1 )))) |((( 0x3 )&   2  )<<( ( ch2 &0x7)<<1 ))    ;	 
	return (0);

}

short TPU_getqd (unsigned char nr)
{
	short v;

	if (nr > 15) {
		return (0);
	}
	if ((((*(short *)(void *)(  (0xfffe00  +  0x0c )   + ((3-( nr /4))<<1)  )) >>( ( nr &0x3)<<2 ))&( 0xf ))   != 0x6 ) {
		return (0);
	}
	v = (*(short *)(void *)( (0xfffe00  +  0x100 )  +( nr *16)+(  1  <<1) ))  ;	 
	*(short *)( (0xfffe00  +  0x100 )  +( nr *16)+(  1  <<1) ) =    0x8000    ;	 
	return (0x8000 - v);

}

short TPU_readqd (unsigned char nr)
{
	short v;

	if (nr > 15) {
		return (0);
	}
	if ((((*(short *)(void *)(  (0xfffe00  +  0x0c )   + ((3-( nr /4))<<1)  )) >>( ( nr &0x3)<<2 ))&( 0xf ))   != 0x6 ) {
		return (0);
	}
	v = (*(short *)(void *)( (0xfffe00  +  0x100 )  +( nr *16)+(  1  <<1) ))  ;	 
	return (0x8000 - v);

}

int TPU_setisr (unsigned char ch, void (*isr) (void))
{
	return _KERN_IVTab_setvector (0x80  + ch, isr);

}

int TPU_clearisr (unsigned char ch, void (*isr) (void))
{
	return _KERN_IVTab_clearvector (0x80  + ch, isr);

}
