/*  src_experimental/drivers/tty/io_duart.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
#include <stddef.h>
#include <mc68681.h>
#include <cubeos.h>
#include <sys_var.h>
#include <iobuf.h>
#include <kerror.h>
#include <ttyio.h>
#include <rsm.h>
#include <rdio.h>
#include <ivtab.h>
#include <softreset.h>

/*! \file io_duart.c
\ingroup DUART
*/

/* 
 * The DUART is mapped into the IDP address space in an unusual 
 * manner.  The mc68681 is an 8 bit device located on the least
 * significant byte (byte0) of the data bus.  Bytes 3, 2, and 
 * one have nothing in them and writes to these locations are
 * not valid.
 */

struct TTY_tty_dev *_DUART_t_a;
struct TTY_tty_dev *_DUART_t_b;

unsigned char _DUART_opcrsave; //!< saves the inaccessible internal state of OPCR


unsigned char _DUART_imrsave;  //!<

unsigned char _DUART_isr;

//void iTTY_outchar(char byte);

#ifdef DUART_BASE
void DUART_setDIMR (unsigned char bit)
{
	_DUART_imrsave |= bit;
	writebyte (DUART_IMR, _DUART_imrsave);
}


void DUART_clearDIMR (unsigned char bit)
{
	_DUART_imrsave &= (0xff - bit);
	writebyte (DUART_IMR, _DUART_imrsave);
}

void _DUART_setrts_a (int how)
{

}
void _DUART_setrts_b (int how)
{

}


void DUART_en_txirq_a ()
{
	DUART_setDIMR (0x01);
}

void DUART_dis_txirq_a ()
{
	DUART_clearDIMR (0x01);
}

void DUART_en_txirq_b ()
{
	DUART_setDIMR (0x10);
}

void DUART_dis_txirq_b ()
{
	DUART_clearDIMR (0x10);
}

void DUART_en_rxirq_a ()
{
	DUART_setDIMR (0x02);
}

void DUART_dis_rxirq_a ()
{
	DUART_clearDIMR (0x02);
}

void DUART_en_rxirq_b ()
{
	DUART_setDIMR (0x20);
}

void DUART_dis_rxirq_b ()
{
	DUART_clearDIMR (0x20);
}

void DUART_setOPCR (unsigned char bit)
{
	_DUART_opcrsave |= bit;
	writebyte (DUART_OPCR, _DUART_opcrsave);
}


void DUART_clearOPCR (unsigned char bit)
{
	_DUART_opcrsave &= (0xff - bit);
	writebyte (DUART_OPCR, _DUART_opcrsave);
}

void DUART_txbyte_b (char byte)
{
	while (!(readbyte (DUART_SRB) & 4));
	writebyte (DUART_TBB, byte);
}
void DUART_txbyte_a (char byte)
{
	while (!(readbyte (DUART_SRA) & 4));
	writebyte (DUART_TBA, byte);
}

int DUART_sethandshake_a (char handshake)
{
	switch (handshake) {
	case TTY_HS_NONE:
	case TTY_HS_XONXOFF:
	case TTY_HS_RTSCTS:
		writebyte (DUART_MR2A, readbyte (DUART_MR2A) & (0xff - 0x30));
		break;
	case TTY_HS_RTSCTSHW:
		writebyte (DUART_MR2A, readbyte (DUART_MR2A) | 0x30);
		DUART_setOPCR (0x30);
		break;
	default:
		return (-1);
	}
	_DUART_t_a->hsmode = handshake;
	return (0);
}

int DUART_setbps_a (int bpsrate)
{
	return (-1);
}
int DUART_sethandshake_b (char handshake)
{
	switch (handshake) {
	case TTY_HS_NONE:
	case TTY_HS_XONXOFF:
	case TTY_HS_RTSCTS:
		writebyte (DUART_MR2B, readbyte (DUART_MR2B) & (0xff - 0x30));
		break;
	case TTY_HS_RTSCTSHW:
		writebyte (DUART_MR2B, readbyte (DUART_MR2B) | 0x30);
		DUART_setOPCR (0x30);
		break;
	default:
		return (-1);
	}
	_DUART_t_b->hsmode = handshake;
	return (0);
}


int DUART_setbps_b (int bpsrate)
{
	return (-1);
}




void DUART_isr_a (struct iobuf *in, struct iobuf *out)
{
// This should be a while loop, but breaks SMBII and Cube1 if so.
	if (readbyte (DUART_SRA) & (char) (0x1 | 0x80)) {	/* char or break */
		if ((readbyte (DUART_SRA) & (char) (0x80)) && (_DUART_t_a->break_process)) {
			writebyte (DUART_CRA, 0x40);/* remove break condition? */
			_DUART_t_a->break_process ();
		}
//              if (!_RSM_enabled) 
		if (!_DUART_t_a->char_process) {
			if (in->cnt < (in->buflen - TTY_RTS_TRESHOLD)) {
				_DUART_setrts_a (0);
			}
			if (in->cnt < in->buflen) {
				in->data[in->head] = readbyte (DUART_RBA);
				in->head = (in->head + 1) % in->buflen;
				in->cnt++;
			} else {
				_KERN_sys_error |= SYS_ERR_DUARTABUF_OVF;
				in->data[in->head] = readbyte (DUART_RBA);
			}
		} else {
//                      RSM_process(readbyte (DUART_RBA));
			_DUART_t_a->char_process (readbyte (DUART_RBA));
		}
	}

	while ((out->cnt > 0) && (readbyte (DUART_SRA) & 4)) {
		writebyte (DUART_TBA, out->data[out->tail]);
		out->tail = (out->tail + 1) % out->buflen;
		out->cnt--;
	}
	/* hold possibly pending transmitter interrupt */
	if (out->cnt == 0) {
		DUART_clearDIMR (0x01);
	} else {
		DUART_setDIMR (0x01);
	}
}



void DUART_isr_b (struct iobuf *in, struct iobuf *out)
{
	char c;
// This should be a while loop, but breaks SMBII and Cube1 if so.
	if (readbyte (DUART_SRB) & (char) (0x1 | 0x80)) {	/* char or break */
		if ((readbyte (DUART_SRB) & (char) (0x80)) && (_DUART_t_b->break_process)){
			writebyte (DUART_CRA, 0x40);/* remove break condition? */
			_DUART_t_b->break_process ();
		}
		if (!_DUART_t_b->char_process) {
			if (in->cnt < (in->buflen - TTY_RTS_TRESHOLD)) {
				_DUART_setrts_b (0);
			}
			if (in->cnt < in->buflen) {
				c = readbyte (DUART_RBB);
//				if (c == RESET_CHAR)
//					KERN_softreset ();
				in->data[in->head] = c;
				in->head = (in->head + 1) % in->buflen;
				in->cnt++;
			} else {
				_KERN_sys_error |= SYS_ERR_DUARTBBUF_OVF;
				c = readbyte (DUART_RBB);
//				if (c == RESET_CHAR)
//					KERN_softreset ();
				in->data[in->head] = c;
			}
		} else {
			_DUART_t_b->char_process (readbyte (DUART_RBB));
		}
	}


	while ((out->cnt > 0) && (readbyte (DUART_SRB) & 4)) {
		writebyte (DUART_TBB, out->data[out->tail]);
		out->tail = (out->tail + 1) % out->buflen;
		out->cnt--;
	}
	/* hold possibly pending transmitter interrupt */
	if (out->cnt == 0)
		DUART_clearDIMR (0x10);		/* writebyte(DUART_IMR, 0x20); */

}

void DUART_int ()
{
	DUART_isr_b (_DUART_t_b->inq, _DUART_t_b->outq);
	DUART_isr_a (_DUART_t_a->inq, _DUART_t_a->outq);

}

void _DUART_duart_bugfix (void)
{
/* try to determine if we are in a bugfix condition */

	if (
	      ((_DUART_t_a->outq->cnt > 0) && (readbyte (DUART_SRA) & 4)) ||
		   ((readbyte (DUART_SRA) & (char) 0x1)) ||
	      (( _DUART_t_b->outq->cnt > 0) && (readbyte (DUART_SRB) & 4)) ||
		   ((readbyte (DUART_SRB) & (char) 0x1)) )
		DUART_int ();	/* then call the duart interrupt */

}

//void TTY_koutchar(char byte);
//
//char TTY_kinchar(void)
//{
//      char c;
//
//      /* Block until char is there */
//      while (_DUART_t_b->inq->cnt == 0);
//      disable ();
//      c = _DUART_t_b->inq->data[_DUART_t_b->inq->tail];
//      _DUART_t_b->inq->tail = (_DUART_t_b->inq->tail + 1) % _DUART_t_b->inq->buflen;
//      _DUART_t_b->inq->cnt--;
//      if (_DUART_t_b->inq->cnt > _DUART_t_b->inq->buflen) {
//              KERN_complain(ERR_PANIC, "More than _DUART_t_b->inq->buflen bytes in the buffer");
//      }
//      enable ();
//      if (_TTY_console_echo)
//              TTY_koutchar(c);
//      return (c);
//}

char TTY_rdioget (void)
{
	char c;

	while (_DUART_t_a->inq->cnt == 0);	/* Block until char is there */
	disable ();
	c = _DUART_t_a->inq->data[_DUART_t_a->inq->tail];
	_DUART_t_a->inq->tail = (_DUART_t_a->inq->tail + 1) % _DUART_t_a->inq->buflen;
	_DUART_t_a->inq->cnt--;
	enable ();
	return (c);
}


//void TTY_koutchar(char byte)
//{
//      disable ();
//
//      if (TTY_Blocking_Serial_Out) {
//              DUART_dis_txirq_b();
//              while (_DUART_t_b->outq->cnt > 0) {
//                      DUART_txbyte_b(_DUART_t_b->outq->data[_DUART_t_b->outq->tail]);
//                      _DUART_t_b->outq->tail = (_DUART_t_b->outq->tail + 1) % _DUART_t_b->outq->buflen;
//                      _DUART_t_b->outq->cnt--;
//              }
//              DUART_txbyte_b(byte);
//      } else {
//
//              if (_DUART_t_b->outq->cnt == _DUART_t_b->outq->buflen) {
//                      DUART_en_txirq_b();
//                      enable ();
//                      return;
//              }               /* Ignore overflow */
//              _DUART_t_b->outq->data[_DUART_t_b->outq->head] = byte;
//              _DUART_t_b->outq->head = (_DUART_t_b->outq->head + 1) % _DUART_t_b->outq->buflen;
//              _DUART_t_b->outq->cnt++;
//
//              /* enable pending transmitter interrupt */
//              if (_DUART_t_b->outq->cnt > 0)
//                      DUART_en_txirq_b();
//      }
//      enable ();
//
//}

//void iTTY_outchar(char byte)
//{
//
//      if (_DUART_t_b->outq->cnt == _DUART_t_b->outq->buflen) {
//              return;
//      }                       /* Ignore overflow */
//      _DUART_t_b->outq->data[_DUART_t_b->outq->head] = byte;
//      _DUART_t_b->outq->head = (_DUART_t_b->outq->head + 1) % _DUART_t_b->outq->buflen;
//      _DUART_t_b->outq->cnt++;
//
//      /* enable pending transmitter interrupt */
//      if (_DUART_t_b->outq->cnt > 0)
//                      DUART_en_txirq_b();
//              
//
//}


int TTY_rdioput (char byte)
{
	disable ();

	if (_DUART_t_a->outq->cnt == _DUART_t_a->outq->buflen) {
		DUART_en_txirq_a ();
		enable ();
		return -1;
	}			/* Ignore overflow */
	_DUART_t_a->outq->data[_DUART_t_a->outq->head] = byte;
	_DUART_t_a->outq->head = (_DUART_t_a->outq->head + 1) % _DUART_t_a->outq->buflen;
	_DUART_t_a->outq->cnt++;

/* enable pending transmitter interrupt */
	if (_DUART_t_a->outq->cnt > 0)
		DUART_en_txirq_a ();

	enable ();
	return (0);
}

void RSM_rdio_flush ()
{
	while (_DUART_t_a->outq->cnt);
}


void RSM_rdio_enable_rx ()
{
	DUART_en_rxirq_a ();
}

void RSM_rdio_disable_rx ()
{
	DUART_dis_rxirq_a ();
}

#else
void DUART_int ()
{
}

#endif

void DUART_duart (struct TTY_tty_dev *TTY_tty_a, struct TTY_tty_dev *TTY_tty_b)
{
	unsigned char temp;

	_DUART_t_a = TTY_tty_a;
	_DUART_t_b = TTY_tty_b;

	iobuf_init (_DUART_t_b->inq, BUFLEN);
	iobuf_init (_DUART_t_b->outq, BUFLEN);
	iobuf_init (_DUART_t_a->inq, BUFLEN);
	iobuf_init (_DUART_t_a->outq, 128);

#ifdef DUART_BASE
	_DUART_t_a->txchar = DUART_txbyte_a;
	_DUART_t_a->en_tx_irq = DUART_en_txirq_a;
	_DUART_t_a->dis_tx_irq = DUART_dis_txirq_a;
	_DUART_t_a->en_rx_irq = DUART_en_rxirq_a;
	_DUART_t_a->dis_rx_irq = DUART_dis_rxirq_a;
	_DUART_t_a->sethandshake = DUART_sethandshake_a;
	_DUART_t_a->setbps = DUART_setbps_a;
	_DUART_t_a->setrts = _DUART_setrts_a;
	_DUART_t_a->hsmode = TTY_HS_NONE;
	_DUART_t_a->mode = 0;
	_DUART_t_a->state = 0;
	_DUART_t_a->char_process = NULL;
	_DUART_t_a->break_process = NULL;

	_DUART_t_b->txchar = DUART_txbyte_b;
	_DUART_t_b->en_tx_irq = DUART_en_txirq_b;
	_DUART_t_b->dis_tx_irq = DUART_dis_txirq_b;
	_DUART_t_b->en_rx_irq = DUART_en_rxirq_b;
	_DUART_t_b->dis_rx_irq = DUART_dis_rxirq_b;
	_DUART_t_b->sethandshake = DUART_sethandshake_b;
	_DUART_t_b->setbps = DUART_setbps_b;
	_DUART_t_b->setrts = _DUART_setrts_b;
	_DUART_t_b->hsmode = TTY_HS_NONE;
	_DUART_t_b->mode = 0;
	_DUART_t_b->state = 0;
	_DUART_t_b->char_process = NULL;
	_DUART_t_b->break_process = NULL;

	TTY_conecho_on ();
//      _KERN_KERN_IVTab_setvector(AVEC5,DUART_Wrapper);

	writebyte (DUART_IMR, 0);
	writebyte (DUART_OPCR, 0);
	_DUART_opcrsave = 0;	/* Maybe we shouldn't do this */
	writebyte (DUART_CRA, 0x2a);
	writebyte (DUART_CRB, 0x2a);
	writebyte (DUART_CRA, 0x3a);
	writebyte (DUART_CRB, 0x3a);
	writebyte (DUART_ACR, 0xE0);	// 19.200
	// writebyte (DUART_ACR, 0x60); // 9.600

	writebyte (DUART_CTUR, 0);
	writebyte (DUART_CTLR, 2);
	temp = readbyte (DUART_STRTCC);
	writebyte (DUART_CSRA, 0xcc);
	writebyte (DUART_CSRB, 0xdd);
	writebyte (DUART_MR1A, 0x13);
	writebyte (DUART_MR1B, 0x13);
	writebyte (DUART_MR2A, 0x7);
	writebyte (DUART_MR2B, 0x7);
	writebyte (DUART_OPRRST, 0xff);
	writebyte (DUART_CRA, 5);
	writebyte (DUART_CRB, 5);
	writebyte (DUART_IMR,0x20);
	_DUART_imrsave = 0x20;
//	DUART_en_rxirq_b ();
#endif
/* now, radio reception is disabled by not setting the RxRDYA bit */
/* the tx irq is set via the TTY_rdioput(char) routine */

}
