/*  src_experimental/drivers/tty/ttyio.h
    CubeOS Version 0.4.90 experimental
    Copyright (C) 1999,2000 Holger Kenn

    CubeOS is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or any later version.

    CubeOS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

*/  
#ifndef _TTYIO_H
#define _TTYIO_H

#define TTY_HS_NONE	0
#define TTY_HS_XONXOFF	1
#define TTY_HS_RTSCTS	2
#define TTY_HS_RTSCTSHW	3 

#define TTY_MODE_RXBLOCKING	1
#define TTY_MODE_TXBLOCKING	2
#define TTY_MODE_TXUNBUF	4
#define TTY_MODE_RSM		8


#define TTY_STATE_RXEMPTY	1
#define TTY_STATE_TXFULL	2

#define TTY_RTS_TRESHOLD	8

struct TTY_tty_dev {
  struct iobuf * inq;
  struct iobuf * outq;
//  char (*rxchar) ();
  void (*txchar) (char c);
  void (*en_tx_irq) ();
  void (*dis_tx_irq) ();
  void (*en_rx_irq) ();
  void (*dis_rx_irq) ();
  void (*setrts) ();
  void (*char_process) (char c);
  void (*break_process) ();
  int (*sethandshake) (char handshake);
  int (*setbps) (int bpsrate);
  char hsmode; /* handshake mode */
  char mode;   /* io-mode */
  char state;  /* io-state */
};


extern char _TTY_console_echo;
void TTY_conecho_on();
void TTY_conecho_off();
char TTY_inchar(void);
void TTY_outchar(char byte);
void TTY_init(void);
void TTY_setcontty(int contty);

extern struct TTY_tty_dev TTY_tty[3];
extern int _TTY_contty;

#endif

