/*  src_experimental/init/camtest.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
#include "rcjtest.h"
#include <stdio.h>
#include "testmak.h"
#include <cubeos.h>
#include <fastbin.h>
#include <tpu.h>
#include <tpud.h>
#include <hw_drivers.h>
#include  <ivtab.h>
#include <sys/time.h>
#include <ptimer.h>

#define CAM_PPL 352
#define CAM_LPI 288
#define SCALE 15

void irq4wrap ();		/* wrapper code */
int int4count;
int s1, s2, t1, t2, deltatt, deltats;

int CamTest ()
{

	int i;
	unsigned short p;
	int4count = 0;

#ifndef RCJ_BASE
	failif(1,"No RCJ configured in current OS build");
#else
	LED_OFF ();
	failif (RCJ_BASE == 0, "No RCJ around...");

	printf ("in CamTest\n");
	fflush (stdout);


	failif (RCJ_init () == -1, "couldn't init RCJ");
	/* This prepares CS3 for the GAL access */
	/* maybe the waitstates are no good yet */



	_KERN_IVTab_setvector (28, irq4wrap);	/* set the IRQ 4 autovector */

/* test the SNAP command */
	LED_ON ();
	writeshort (RCJ_BASE + 6, 0);	/* Send SNAP */
	LED_OFF ();
//      while (1);

	for (i = 1; i < 100000; i++) {
		if (!(i % 10000)) {
			printf (".");
			fflush (stdout);
		}
		if (int4count)
			break;
	}

	if (int4count) {
		printf ("Got Interrupt!\n");
	} else {
		printf ("Time out\n");
	}

	printf (" One Readout ");
	fflush (stdout);
	p = readshort (RCJ_BASE + 2);

	printf ("Reading out picture...\n");
	fflush (stdout);
	disable ();
	t1 = _time_ticks;
	s1 = _time_seconds;
	enable ();

	for (i = 0; i < CAM_LPI * CAM_PPL; i++) {
//              if (!(i%10000)) {printf(".");fflush(stdout);}
		p = readshort (RCJ_BASE + 2);
	}

	disable ();
	t2 = _time_ticks;
	s2 = _time_seconds;
	enable ();
	deltats = s2 - s1;
	deltatt = t2 - t1;

	if (deltatt < 0) {
		deltatt = deltatt + TICKS_PER_SECOND;
		deltats -= 1;
	}
	printf (" time was %d seconds, %d ticks", deltats, deltatt);


	printf ("Done...\n");
	_KERN_IVTab_clearvector (28, irq4wrap);		/* set the IRQ 4 autovector */
	return (0);
#endif

}

int ViewTest ()
{

	int x, y, i;
	unsigned short p;
	int4count = 0;
#ifndef RCJ_BASE
	failif(1,"No RCJ configured in current OS build");
#else
	failif (RCJFB_BASE == 0, "No RCJ around...");

	RCJ_init ();		/* This prepares CS3 for the GAL access */
	/* maybe the waitstates are no good yet */

	_KERN_IVTab_setvector (28, irq4wrap);	/* set the IRQ 4 autovector */

/* test the SNAP command */

	writeshort (RCJ_BASE + 6, 0);	/* Send SNAP */


	for (i = 1; i < 100000; i++) {
		if (!(i % 10000)) {
			printf (".");
			fflush (stdout);
		}
		if (int4count)
			break;
	}

	if (int4count) {
		printf ("Got picture!\n");
	} else {
		printf ("Time out\n");
	}


	printf ("PICTURE START\n");
	for (y = 0; y < CAM_LPI; y++) {
		for (x = 0; x < CAM_PPL; x++) {
			p = readshort (RCJ_BASE + 2);
			if (!(y % SCALE) && !(x % SCALE)) {
//                              printf("%4hx ",p);
				printf ("%3d ", p >> 8);
//                              printf("%3d ",p&0xff);
			}
		}
		if (!(y % SCALE)) {
			printf ("\n");
			fflush (stdout);
		}
	}
//      for(y=0;y<CAM_LPI;y++){
	//              for(x=0;x<CAM_PPL;x++){  
	//                      p=readshort(RCJ_BASE+2);                
	//                      if (x<4) printf("%3d ",p>>8);
	//              }
	//              if (x<4) printf(" <\n");
	//      }

	printf ("\nPICTURE END\n");
	_KERN_IVTab_clearvector (28, irq4wrap);		/* set the IRQ 4 autovector */
	return (0);
#endif
}

int ViewuvTest ()
{

	int x, y, i;
	unsigned short p;
	int4count = 0;
#ifndef RCJ_BASE
	failif(1,"No RCJ configured in current OS build");
#else

	failif (RCJ_BASE == 0, "No RCJ around...");

	RCJ_init ();		/* This prepares CS3 for the GAL access */
	/* maybe the waitstates are no good yet */

	_KERN_IVTab_setvector (28, irq4wrap);	/* set the IRQ 4 autovector */

/* test the SNAP command */

	writeshort (RCJ_BASE + 6, 0);	/* Send SNAP */


	for (i = 1; i < 100000; i++) {
		if (!(i % 10000)) {
			printf (".");
			fflush (stdout);
		}
		if (int4count)
			break;
	}

	if (int4count) {
		printf ("Got picture!\n");
	} else {
		printf ("Time out\n");
	}


	printf ("PICTURE START\n");
	for (y = 0; y < CAM_LPI; y++) {
		for (x = 0; x < CAM_PPL; x++) {
			p = readshort (RCJ_BASE + 2);
			if (!(y % SCALE) && !(x % SCALE)) {
				printf ("%3d ", p & 0xff);
			}
		}
		if (!(y % SCALE)) {
			printf ("\n");
			fflush (stdout);
		}
	}

	printf ("\nPICTURE END\n");
	_KERN_IVTab_clearvector (28, irq4wrap);		/* set the IRQ 4 autovector */
	return (0);
#endif
}

int NoSnapTest ()
{

	int x, y, i;
	unsigned short p;
	int4count = 0;
#ifndef RCJ_BASE
	failif(1,"No RCJ configured in current OS build");
#else
	failif (RCJ_BASE == 0, "No RCJ around...");

	RCJ_init ();		/* This prepares CS3 for the GAL access */
	/* maybe the waitstates are no good yet */

	_KERN_IVTab_setvector (28, irq4wrap);	/* set the IRQ 4 autovector */

/* test the SNAP command */

//      writeshort(RCJ_BASE+6,0); /* Send SNAP */


//      for(i=1;i<100000;i++){
	//              if (!(i%10000)) {printf(".");fflush(stdout);}
	//              if (int4count) break;
	//      }

//      if (int4count) {printf("Got picture!\n");}
	//              else {printf("Time out\n");}

//      #define SCALE 10
	printf ("PICTURE START\n");
	for (y = 0; y < CAM_LPI; y++) {
		for (x = 0; x < CAM_PPL; x++) {
			p = readshort (RCJ_BASE + 2);
			if (!(y % SCALE) && !(x % SCALE)) {
				printf ("%3d ", p >> 8);
			}
		}
		if (!(y % SCALE)) {
			printf ("\n");
			fflush (stdout);
		}
	}
//      for(y=0;y<CAM_LPI;y++){
	//              for(x=0;x<CAM_PPL;x++){  
	//                      p=readshort(RCJ_BASE+2);                
	//                      if (x<4) printf("%3d ",p>>8);
	//              }
	//              if (x<4) printf(" <\n");
	//      }

	printf ("\nPICTURE END\n");
	_KERN_IVTab_clearvector (28, irq4wrap);		/* set the IRQ 4 autovector */
	return (0);
#endif
}
int PictureTest ()
{

	int x, y, i;
	int uvcount;
	int ustore;
	int vstore;
	int ystore;
	unsigned short p;
	int4count = 0;
#ifndef RCJ_BASE
	failif(1,"No RCJ configured in current OS build");
#else
	failif (RCJ_BASE == 0, "No RCJ around...");

	RCJ_init ();		/* This prepares CS3 for the GAL access */
	/* maybe the waitstates are no good yet */

	_KERN_IVTab_setvector (28, irq4wrap);	/* set the IRQ 4 autovector */

/* test the SNAP command */

	writeshort (RCJ_BASE + 6, 0);	/* Send SNAP */


	for (i = 1; i < 100000; i++) {
		if (!(i % 10000)) {
			printf (".");
			fflush (stdout);
		}
		if (int4count)
			break;
	}

	if (int4count) {
		printf ("Got picture!\n");
	} else {
		printf ("Time out\n");
		return (-1);
	}

	printf ("PICTURE START\n");
//      for(x=0;x<CAM_PPL;x++){
	//              for(y=0;y<CAM_LPI;y++){  
	//                      p=readshort(RCJ_BASE+2);                
	//                      if (!(y%10) && !(x%10))
	//                      {
	//                              printf("%hx ",p);
	//                      }
	//              }
	//              if(!(x%10)) { printf("\n");fflush(stdout);}
	//      }
	uvcount = 0;
	for (y = 0; y < CAM_LPI; y++) {
		for (x = 0; x < CAM_PPL; x++) {
			p = readshort (RCJ_BASE + 2);
			if (!((uvcount++) % 2)) {
				ustore = p & 0xff;
				ystore = p >> 8;
			} else {
				vstore = p & 0xff;
				printf ("%d %d %d %d\n", uvcount - 1, ystore, ustore, vstore);
				printf ("%d %d %d %d\n", uvcount, p >> 8, ustore, vstore);
			};
		}
	}

	printf ("\nPICTURE END\n");
	_KERN_IVTab_clearvector (28, irq4wrap);		/* set the IRQ 4 autovector */
	return (0);
#endif
}


void irq4_handler ()
{
	unsigned short d;
	int i;
#ifdef RCJ_BASE

	LED_ON ();
	for (i = 1; i < 100; i++);
	LED_OFF ();
	int4count++;
	d = readshort (RCJ_BASE + 6);	/* Confirm interrupt */
//      writeshort(RCJ_BASE+6,0); /* Send SNAP */

#endif
}
