/*  src_experimental/init/init.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
#include <stdio.h>
#include <config.h>
#include <tpu.h>
#include <tpud.h>
#include <qsm.h>
#include <rdio.h>
#include <ptimer.h>

#include "readcmd.h"
#include "testmak.h"

/* tests */
#define MAXTESTS 30

int EmptyTest ();		// tests the test facility, defined below

int TimerTest ();		// tests the timer irq and the daytime clock
#include "tputest.h"		// tests TPU interface and irq callback
#include "i2ctest.h"		// tests i2c read-write
#include "spitest.h"		// tests spi read-write
#include "schedtest.h"		// tests task scheduling/sleep/resume
#include "sleeptest.h"
#include "ttytest.h"
#include "radiotest.h"		// tests radio module
#include "listtest.h"		// tests list manager
#include "hwinfot.h"		// dump hardware infostruct
#include "flashtest.h"		// test flash rom
#include "fbintest.h"		// test the TTL fast bins
#include "floattest.h"		// tests the floats
//#include "semtest.h"   // tests semaphores between tasks
//#include "msgtest.h"   // tests message ipc
//#include "sigtest.h"   // tests signals
//#include "nettest.h"   // tests network
#include "xdrtest.h"
#include "rcjtest.h"
#include "rgtest.h"
#include "camtest.h"
#include "resettest.h"		// tests soft reset
#include "panictest.h"		// tests kerror facility
#include "timetest.h"
//#include "cplusplus.h"

/* table of tests */
struct test {
	int (*test_entry) ();
	int interactive;
	char *name;
	int success;
	int failure;
};
struct test tests[MAXTESTS];

int testnr;

void newtest (int (*test_entry) (), int interactive, char *name);

/* add your tests here */
void init_tests ()
{
	newtest (EmptyTest, 0, "Empty test");
	newtest (ListTest, 0, "List test");
	newtest (TimerTest, 0, "Timer test");
	newtest (TPUTest, 0, "TPU test");
	newtest (HWInfoTest, 0, "Hardware Info test");
	newtest (FlashTest, 0, "Flash test");
	newtest (I2CTest, 0, "I2C Test");
	newtest (SPITest, 0, "SPI Test");
	newtest (FBinTest, 0, "TTL FastBin test");
	newtest (SchedTest, 0, "Scheduler test");
	newtest (SleepTest, 0, "Sleep test");
	newtest (TTYTest, 0, "TTY test");
	newtest (RadioTestRx, 0, "Radiolink test (Rx)");
	newtest (RadioTestTx, 0, "Radiolink test (Tx)");
	newtest (XDRTest, 0, "XDR test");
	newtest (TimeTest, 0, "Time test");
	newtest (RCJTest, 1, "RCJ test");
	newtest (RGTest, 1, "RG test");
	newtest (CamTest, 1, "CamTest");
//      newtest (CPlusPlusTest,0,"C++ Test");
	newtest (ResetTest, 1, "Soft reset test");
	newtest (PanicTest, 1, "Kernel Panic test");
	newtest (FloatTest, 1, "Float Test");
}

/* don't change anything down here */

void newtest (int (*test_entry) (), int interactive, char *name)
{
	if (testnr == 0) {
		int i;
		printf ("Cleaning up tests...");
		for (i = 0; i < MAXTESTS; i++) {
			tests[i].test_entry = NULL;
			tests[i].name = NULL;
			tests[i].success = 0;
			tests[i].failure = 0;
		}
		printf ("done\n");
	}
	if (testnr < MAXTESTS) {
		tests[testnr].test_entry = test_entry;
		tests[testnr].interactive = interactive;
		tests[testnr].name = name;
		testnr++;
	}
}

void dotest (int i,int key)
{
	int ret;
	if (tests[i].test_entry == NULL) {
		printf ("no such test %d\n", i);
		return;
	}
	printf ("\nRunning test %d:", i);
	if (tests[i].name) {
		printf ("%s\n", tests[i].name);
	} else {
		printf ("\n");
	}
	fflush (stdout);

	ret = tests[i].test_entry ();

	fflush (stdout);
	printf ("\n");

	if (ret) {
		printf ("test %d FAILED:%d ", i, ret);
		if (tests[i].name) {
			printf ("%s\n", tests[i].name);
		} else {
			printf ("\n");
		}
	} else {
		printf ("test %d SUCCEDED ", i);
		if (tests[i].name) {
			printf ("%s\n", tests[i].name);
		} else {
			printf ("\n");
		}
	}
 if (key) {
       printf("press any key to continue\n");
	fflush (stdout);
	TTY_inchar (); 
 }

}


int EmptyTest ()
{
	printf ("Empty Test\n");
	return 0;
}

int TimerTest ()
{
	int i;
	unsigned long oldtime;
	int success;

	success = 0;
	printf ("watching clockticks");
	fflush (stdout);
	oldtime = _time_seconds;

	for (i = 0; i < 1000000; i++) {
		if (oldtime != _time_seconds) {
			oldtime = _time_seconds;
			printf (".");
			fflush (stdout);
			success++;
		}
	}

	printf ("seen %d ticks", success);
	failif (success == 0, "Clock is not ticking");
	return (0);

}


int main (int argc, char *argv[])
{
	int i, j;
	int quit = 0;
	unsigned long *adr;
	char test[256];
	char c;
	char *command;

	testnr = 0;
/*	init_LED ();
	LED_OFF ();
	for (i = 0; i < 100000; i++);
	LED_ON ();
	for (i = 0; i < 100000; i++);	// crash somewhere here 
	LED_OFF ();
*/


//      while(1);

/*      while(!(readshort(SCI_SCSR)&0x100));
   writeshort(SCI_SCDR,((unsigned short)'X')&0xff);
   while(!(readshort(SCI_SCSR)&0x100));
   writeshort(SCI_SCDR,((unsigned short)'\n')&0xff);
   while(!(readshort(SCI_SCSR)&0x100));
   writeshort(SCI_SCDR,((unsigned short)'\r')&0xff);
 */
/*      TTY_soutchar('Y');
   TTY_soutchar('\n');
   TTY_soutchar('\r');  */

#ifdef USE_DUART_AS_CONSOLE
	TTY_setcontty(2);
#else
	TTY_setcontty(0);
#endif
	

	TTY_outchar ('C');
	TTY_outchar ('\n');
	TTY_outchar ('\r');


	printf ("\nCubeOS Testsuite V1.0\n");
	TTY_Blocking_Serial_Out = 0;

	TTY_outchar ('U');
	TTY_outchar ('\n');
	TTY_outchar ('\r');


	printf ("NL/CR test:\nERROR\rOK   \n");
	TTY_outchar ('B');
	TTY_outchar ('\n');
	TTY_outchar ('\r');

/*disable();
   c = QSM_sci_rxchar();
   enable();

   printf("seen %x\n",c);
 */
	TTY_outchar ('E');
	TTY_outchar ('\n');
	TTY_outchar ('\r');


	printf ("please press another key to continue>");
	TTY_outchar ('\n');
	TTY_outchar ('\r');



	fflush (stdout);
	c = TTY_inchar (); 
	printf ("\nGot %c: %d\n", c, c);
	init_LED ();



	init_tests ();
//	dotest(9);

	do {
		printf ("\n\navailable tests:\n");
		for (i = 0; i < testnr; i++) {
			printf ("%2d:%c ", i, (tests[i].interactive ? 'I' : ' '));
			if (tests[i].name) {
				printf ("%s\n", tests[i].name);
			} else {
				printf ("\n");
			}
		}

		command = readcmd ("test(#/q/a)?");

		if (!strcmp (command, "q")) {
			quit = 1;
		} else {
			if (!strcmp (command, "a")) {
				printf ("\n\nRunning all noninteractive tests\n");
				LED_ON ();
				for (i = 0; i < testnr; i++)
					if (!tests[i].interactive)
						dotest (i,0);
				LED_OFF ();
			} else {

				j = sscanf (command, "%d", &i);

				if ((j == 1) && (i >= 0) && (i < testnr)) {
					LED_ON ();
					dotest (i,1);
					LED_OFF ();
				} else {
					printf ("no such test \n");
				}
			}

		}

	} while (!quit);


	return (0);
}
