/*  src_experimental/init/rcjtest.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
#include "rcjtest.h"
#include <stdio.h>
#include "testmak.h"
#include <cubeos.h>
#include <fastbin.h>
#include <tpu.h>
#include <tpud.h>

int RCJTest ()
{

	int i;

#ifndef RCJ_BASE
	failif (1, "No RCJ configured in OS build...");
#else
	failif (RCJ_BASE == 0, "No RCJ in current configuration...");

	printf ("init_fastbin\n");

	FBIN_init ();

	printf ("writing register\n");
	writebyte (RCJFB_BASE, 0xff);
	printf ("Making rcj fastbins...");
	fflush (stdout);
	for (i = 0; i < 8; i++) {
		printf ("%d ", i);
		fflush (stdout);
		checkif (FBIN_make (i, FBTYPE_RCJ, i) == 0, "couldn't make fastbin");
	}
	printf ("\n");

	printf ("Enabling rcj fastbins...");
	fflush (stdout);
	for (i = 0; i < 8; i++) {
		printf ("%d ", i);
		checkif (FBIN_set (i, 1) == 0, "couldn't enable fastbin");
	}
	printf ("\n");

	printf ("disabeling rcj fastbins...");
	fflush (stdout);
	for (i = 0; i < 8; i++) {
		printf ("%d ", i);
		checkif (FBIN_set (i, 0) == 0, "couldn't disable fastbin");
	}
	printf ("\n");

	printf ("Flashing rcj fastbins FAST");
	fflush (stdout);
	for (i = 1; i < 100000; i++) {
		writebyte (RCJFB_BASE, 0xff);
		writebyte (RCJFB_BASE, 0x00);
	}
	printf ("\nOK\n");

	printf ("Setting up motor control on RCJ\n");
	printf ("Calling TPU_INIT\n");
	TPU_init ();
	printf ("Making PWM Channels\n");
	TPU_makepwm (0);
	TPU_makepwm (3);
	TPU_makepwm (6);
	TPU_makepwm (9);
	printf ("setting frequency \n");
	TPU_setpwmperiod (0, TCR1FREQ / 100);
	TPU_setpwmperiod (3, TCR1FREQ / 100);
	TPU_setpwmperiod (6, TCR1FREQ / 100);
	TPU_setpwmperiod (9, TCR1FREQ / 100);
	printf ("setting duty cycle to 50%%\n");
	TPU_setpwmdc (0, 50);
	TPU_setpwmdc (3, 50);
	TPU_setpwmdc (6, 50);
	TPU_setpwmdc (9, 50);
	for (i = 1; i < 500000; i++);
	printf ("writing 0xaa\n");
	writebyte (RCJFB_BASE, 0xaa);	/* green */
	for (i = 1; i < 500000; i++);
	printf ("writing 0x55\n");
	writebyte (RCJFB_BASE, 0x55);	/* red */
	for (i = 1; i < 500000; i++);
	printf ("writing 0x00\n");
	writebyte (RCJFB_BASE, 0x00);
	for (i = 1; i < 500000; i++);

	printf (" Setting motors to FORWARD \n ");
	FBIN_set (0, 0);
	FBIN_set (1, 1);
	for (i = 1; i < 50000; i++);
	FBIN_set (2, 0);
	FBIN_set (3, 1);
	for (i = 1; i < 50000; i++);
	FBIN_set (4, 0);
	FBIN_set (5, 1);
	for (i = 1; i < 50000; i++);
	FBIN_set (6, 0);
	FBIN_set (7, 1);
	for (i = 1; i < 500000; i++);
	printf (" Setting motors to REVERSE \n ");
	FBIN_set (0, 1);
	FBIN_set (1, 0);
	for (i = 1; i < 50000; i++);
	FBIN_set (2, 1);
	FBIN_set (3, 0);
	for (i = 1; i < 50000; i++);
	FBIN_set (4, 1);
	FBIN_set (5, 0);
	for (i = 1; i < 50000; i++);
	FBIN_set (6, 1);
	FBIN_set (7, 0);
	for (i = 1; i < 500000; i++);
	printf (" Setting motors to OFF \n ");

	FBIN_set (0, 0);
	FBIN_set (1, 0);
	for (i = 1; i < 50000; i++);
	FBIN_set (2, 0);
	FBIN_set (3, 0);
	for (i = 1; i < 50000; i++);
	FBIN_set (4, 0);
	FBIN_set (5, 0);
	for (i = 1; i < 50000; i++);
	FBIN_set (6, 0);
	FBIN_set (7, 0);
	for (i = 1; i < 500000; i++);
	printf (" Forward, sweeping duty cycle \n ");
	TPU_setpwmdc (0, 0);
	TPU_setpwmdc (3, 0);
	TPU_setpwmdc (6, 0);
	TPU_setpwmdc (9, 0);
	FBIN_set (0, 0);
	FBIN_set (1, 1);
	FBIN_set (2, 0);
	FBIN_set (3, 1);
	FBIN_set (4, 0);
	FBIN_set (5, 1);
	FBIN_set (6, 0);
	FBIN_set (7, 1);
	for (i = 0; i < 100000; i++)
		if (!(i % 1000)) {
			TPU_setpwmdc (0, i / 1000);
			TPU_setpwmdc (3, i / 1000);
			TPU_setpwmdc (6, i / 1000);
			TPU_setpwmdc (9, i / 1000);
		}
	for (i = 100000; i > 0; i--)
		if (!(i % 1000)) {
			TPU_setpwmdc (0, i / 1000);
			TPU_setpwmdc (3, i / 1000);
			TPU_setpwmdc (6, i / 1000);
			TPU_setpwmdc (9, i / 1000);
		}
	printf (" Backward, sweeping duty cycle \n ");
	FBIN_set (0, 1);
	FBIN_set (1, 0);
	FBIN_set (2, 1);
	FBIN_set (3, 0);
	FBIN_set (4, 1);
	FBIN_set (5, 0);
	FBIN_set (6, 1);
	FBIN_set (7, 0);
	for (i = 0; i < 100000; i++)
		if (!(i % 1000)) {
			TPU_setpwmdc (0, i / 1000);
			TPU_setpwmdc (3, i / 1000);
			TPU_setpwmdc (6, i / 1000);
			TPU_setpwmdc (9, i / 1000);
		}
	for (i = 100000; i > 0; i--)
		if (!(i % 1000)) {
			TPU_setpwmdc (0, i / 1000);
			TPU_setpwmdc (3, i / 1000);
			TPU_setpwmdc (6, i / 1000);
			TPU_setpwmdc (9, i / 1000);
		}
	printf (" Setting motors to OFF \n ");
	FBIN_set (0, 0);
	FBIN_set (1, 0);
	FBIN_set (2, 0);
	FBIN_set (3, 0);
	FBIN_set (4, 0);
	FBIN_set (5, 0);
	FBIN_set (6, 0);
	FBIN_set (7, 0);
//      for (i = 1; i < 100000; i++);
	TPU_initchannel (0);
	TPU_initchannel (3);
	TPU_initchannel (6);
	TPU_initchannel (9);
#endif
	return (0);
}
