/*  src_experimental/init/rgtest.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
#include "rcjtest.h"
#include <stdio.h>
#include "testmak.h"
#include <cubeos.h>
#include <fastbin.h>
#include <tpu.h>
#include <tpud.h>
#include <i2cd.h>
#include <analog.h>
#include <digital.h>

int RGTest ()
{

	int i, j, k;
	char a;
#ifndef RCJFB_BASE
	failif(1,"No RG in current OS configuration");
#else
	failif (RCJFB_BASE == 0, "No RG around...");

	printf ("init_fastbin\n");

	FBIN_init ();

	printf ("writing register\n");
	writebyte (RCJFB_BASE, 0xff);
	printf ("Making rg fastbins...");
	fflush (stdout);
	for (i = 0; i < 4; i++) {
		printf ("%d ", i);
		fflush (stdout);
		checkif (FBIN_make (i, FBTYPE_RCJ, i) == 0, "couldn't make fastbin");
	}
	printf ("\n");

	printf ("Enabling rg fastbins...");
	fflush (stdout);
	for (i = 0; i < 4; i++) {
		printf ("%d ", i);
		checkif (FBIN_set (i, 1) == 0, "couldn't enable fastbin");
	}
	printf ("\n");

	printf ("disabeling rcj fastbins...");
	fflush (stdout);
	for (i = 0; i < 4; i++) {
		printf ("%d ", i);
		checkif (FBIN_set (i, 0) == 0, "couldn't disable fastbin");
	}
	printf ("\n");

	printf ("Flashing rcj fastbins FAST");
	fflush (stdout);
	for (i = 1; i < 100000; i++) {
		writebyte (RCJFB_BASE, 0xff);
		writebyte (RCJFB_BASE, 0x00);
	}
	printf ("\nOK\n");

	printf ("Setting up motor control on RCJ\n");
	printf ("Calling TPU_INIT\n");
	TPU_init ();
	printf ("Making PWM Channels\n");
	TPU_makepwm (0);
	TPU_makepwm (3);
	printf ("setting frequency \n");
	TPU_setpwmperiod (0, TCR1FREQ / 100);
	TPU_setpwmperiod (3, TCR1FREQ / 100);
	printf ("setting duty cycle to 50%%\n");
	TPU_setpwmdc (0, 50);
	TPU_setpwmdc (3, 50);
	for (i = 1; i < 500000; i++);
	printf ("writing 0xaa\n");
	writebyte (RCJFB_BASE, 0xaa);	/* green */
	for (i = 1; i < 500000; i++);
	printf ("writing 0x55\n");
	writebyte (RCJFB_BASE, 0x55);	/* red */
	for (i = 1; i < 500000; i++);
	printf ("writing 0x00\n");
	writebyte (RCJFB_BASE, 0x00);
	for (i = 1; i < 500000; i++);

	printf (" Setting motors to FORWARD \n ");
	FBIN_set (0, 0);
	FBIN_set (1, 1);
	for (i = 1; i < 50000; i++);
	FBIN_set (2, 0);
	FBIN_set (3, 1);
	for (i = 1; i < 500000; i++);
	printf (" Setting motors to REVERSE \n ");
	FBIN_set (0, 1);
	FBIN_set (1, 0);
	for (i = 1; i < 50000; i++);
	FBIN_set (2, 1);
	FBIN_set (3, 0);
	for (i = 1; i < 500000; i++);
	printf (" Setting motors to OFF \n ");

	FBIN_set (0, 0);
	FBIN_set (1, 0);
	for (i = 1; i < 50000; i++);
	FBIN_set (2, 0);
	FBIN_set (3, 0);
	for (i = 1; i < 500000; i++);
	printf (" Forward, sweeping duty cycle \n ");
	TPU_setpwmdc (0, 0);
	TPU_setpwmdc (3, 0);
	FBIN_set (0, 0);
	FBIN_set (1, 1);
	FBIN_set (2, 0);
	FBIN_set (3, 1);
	for (i = 0; i < 100000; i++)
		if (!(i % 1000)) {
			TPU_setpwmdc (0, i / 1000);
			TPU_setpwmdc (3, i / 1000);
		}
	for (i = 100000; i > 0; i--)
		if (!(i % 1000)) {
			TPU_setpwmdc (0, i / 1000);
			TPU_setpwmdc (3, i / 1000);
		}
	printf (" Backward, sweeping duty cycle \n ");
	FBIN_set (0, 1);
	FBIN_set (1, 0);
	FBIN_set (2, 1);
	FBIN_set (3, 0);
	for (i = 0; i < 100000; i++)
		if (!(i % 1000)) {
			TPU_setpwmdc (0, i / 1000);
			TPU_setpwmdc (3, i / 1000);
		}
	for (i = 100000; i > 0; i--)
		if (!(i % 1000)) {
			TPU_setpwmdc (0, i / 1000);
			TPU_setpwmdc (3, i / 1000);
		}
	printf (" Setting motors to OFF \n ");
	FBIN_set (0, 0);
	FBIN_set (1, 0);
	FBIN_set (2, 0);
	FBIN_set (3, 0);
//      for (i = 1; i < 100000; i++);
	TPU_makedio (0);
	TPU_makedio (3);
	TPU_setdio (0, 255);
	TPU_setdio (3, 255);

	TPU_initchannel (0);
	TPU_initchannel (3);


	printf ("Starting I2C test...");

	printf ("Calling I2C_INIT for Channel A:\n");
	printf (" Base 0x%x, IV %d\n", I2CA_BASE, I2CA_VECTORNUM);

	I2C_init (I2CA, I2CA_BASE);

	printf ("init_analog...\n");
	I2C_init_analog ();
	printf ("OK\n");
	printf (" found %d analog devices\n", _I2C_adnum);

	failif (_I2C_adnum != 2, "Wrong number of analog devices on RG");

	for (j = 0; j < 5; j++) {

		printf ("reading analog at adress 0x%x, channel 0 : ", _I2C_ad_data[0].address);

		a = I2C_ReadAnalogIn (0, 0);

		if (I2C_messagestatus (&_I2C_analog_m))
			return (-1);

		printf ("%d OK\n", a);
		for (i = 1; i < 100000; i++);
	}


	printf ("init_digital...\n");

	I2C_init_digital ();

	printf ("OK\n");
	printf (" found %d digital devices\n", _I2C_binnum);

	failif (_I2C_binnum != 3, "Wrong number of digital devices on RG");


	for (j = 0; j < 5; j++) {
		printf ("reading digital at adress 0x%x : ", _I2C_bin_data[0].address);

		a = I2C_ReadBinIn (0);

		if (I2C_messagestatus (&_I2C_digital_m))
			return (-1);

		printf ("0x%x OK\n", a);
		for (i = 1; i < 100000; i++);
	}

	printf ("reading SENSE bits\n");

	a = I2C_ReadBinIn (1);

	if (I2C_messagestatus (&_I2C_digital_m))
		return (-1);

	printf (" sense = %x ", a);

	printf ("setting OUT bits to %d\n", 0);
	a = I2C_WriteBinOut (0, 0);

	if (I2C_messagestatus (&_I2C_digital_m))
		return (-1);

	for (i = 1; i < 1000000; i++);

	for (j = 0; j < 256; j++) {
		printf ("setting OUT bits to %d\n", j);

		a = I2C_WriteBinOut (0, j);

		if (I2C_messagestatus (&_I2C_digital_m))
			return (-1);
		for (i = 1; i < 10000; i++);
	}

	for (i = 1; i < 100000; i++);

	printf ("setting OUT bits to 1\n");

	a = I2C_WriteBinOut (0, 0xff);

	if (I2C_messagestatus (&_I2C_digital_m))
		return (-1);

	for (k = 0; k < 10; k++) {

		for (j = 1; j < 256; j <<= 1) {
			a = I2C_WriteBinOut (0, 255 - j);
			if (I2C_messagestatus (&_I2C_digital_m))
				return (-1);
			for (i = 1; i < 10000; i++);
		}
		for (j = 256; j > 1; j >>= 1) {
			a = I2C_WriteBinOut (0, 255 - j);
			if (I2C_messagestatus (&_I2C_digital_m))
				return (-1);
			for (i = 1; i < 10000; i++);
		}

	}
	for (i = 1; i < 1000000; i++);

	a = I2C_WriteBinOut (0, 0xff);

	printf ("OK\n");

#endif
	return (0);
}
