/*  src_experimental/init/sleeptest.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
#include <stdio.h>
#include <signal.h>
#include <cubeos.h>
#include <schedule.h>
#include "testmak.h"

int sleep_success;

void sleeper ()
{
	int r;
	int ts1, ts2;
	int tt1, tt2;
	printf ("\nI am the sleeper\n");
	disable ();
	tt1 = _time_ticks;
	ts1 = _time_seconds;
	enable ();
	printf ("It is now %d/%d\n", ts1, tt1);
	printf ("Sleeping...\n");
	r = KERN_psleep (1025);	/* we sleep at least one second */
	printf ("Waking up (%d)\n", r);
	disable ();
	tt2 = _time_ticks;
	ts2 = _time_seconds;
	enable ();
	printf ("It is now %d/%d\n", ts2, tt2);
	if (ts1 < ts2)
		sleep_success = 1;
	while (1);		/* and block */
}

int SleepTest ()
{
	int handle1;
	int i, j;

	printf (" Testing the delta list\n");
	sleep_success = 0;
	handle1 = KERN_create (sleeper);
	for (j = 1; j < 10; j++) {
		for (i = 1; i < 100000; i++);
		if (sleep_success == 0) {
			printf ("remaining time %d\n", _KERN_ptable[handle1].time_delta);
		} else {
			printf ("completed,time %d\n", _KERN_ptable[handle1].time_delta);
		}
	}

	kill (handle1, SIGKILL);
	failif (sleep_success == 0, "Something's wrong with the sleeper !");

	return (0);
}
