/*  src_experimental/kernel/context.h
    CubeOS Version 0.4.90 experimental
    Copyright (C) 1999,2000 Holger Kenn

    CubeOS is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or any later version.

    CubeOS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

*/  
/* This defines a context for a process or thread */
/* It's simply a block for the context switch to store data */
#ifndef CONTEXT_H
#define CONTEXT_H
/*! \file context.h
\ingroup KERN
*/

#define PNREGS	19

#define POS_D0 0
#define POS_D1 1
#define POS_D2 2
#define POS_D3 3
#define POS_D4 4
#define POS_D5 5
#define POS_D6 6
#define POS_D7 7
#define POS_A0 8
#define POS_A1 9
#define POS_A2 10
#define POS_A3 11
#define POS_A4 12
#define POS_A5 13
#define POS_A6 14
#define POS_SSP 15
#define POS_SR 16
#define POS_PC 17


typedef struct regs *regptr;

/*! 
\brief register structure for context switch
\ingroup KERN
*/
typedef struct regs {
	long regs[PNREGS];
} reglist;

/*!
\brief switch CPU context
\param oldarea is a pointer to the old context area
\param newarea is a pointer to the old context area
\ingroup KERN

KERN_contextsw() saves the current CPU state in the oldarea and
restores the context from newarea into the CPU.
*/
void KERN_contextsw(regptr oldarea,regptr newarea);


#endif
