/*  src_experimental/kernel/iobuf.h
    CubeOS Version 0.4.90 experimental
    Copyright (C) 1999,2000 Holger Kenn

    CubeOS is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or any later version.

    CubeOS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

*/  
#ifndef _IOBUF_H
#define _IOBUF_H

/*! \file iobuf.h
\ingroup KERN
*/

#define BUFLEN 1024 //!< buffer space allocated for all buffers

/*!
\brief This forms an io buffer
\ingroup KERN
*/
struct iobuf {
  unsigned short head; //!< the head pointer where reading takes place
  unsigned short tail; //!< the tail pointer where writing takes place
  unsigned short cnt;  //!< the number of chars in the buffer
  unsigned short buflen; //!< the overall buffer space
  char data[BUFLEN];    //!< the data storage area
};

/*!
\brief prepares an iobuf for use
\param x is a pointer to an iobuf structure
\param bl is the bufferlength for this iobuf. 
\ingroup KERN
*/
static inline void iobuf_init(struct iobuf *x,short bl)
{

if ((bl<=0)||(bl>BUFLEN)) 
	{
		x->buflen=BUFLEN;
	}
else {
	x->buflen=bl;
}

x->head=0;
x->tail=0;
x->cnt=0;

}

/*!
\brief writes one char into an io buffer
\param x is a pointer to the iobuf structure
\param c is the char to be written
\ingroup KERN

The function returns 0 on success, -1 on failure.
*/
static inline int put(struct iobuf *x,char c) 
{
if (x->cnt < x->buflen) {
	x->data[x->head]=c;
	x->head=(x->head+1) % x->buflen;
	x->cnt++;
	return(0);
} else {
	return(-1);
	}
}

/*!
\brief reads one char from an io buffer
\param x is a pointer to the iobuf structure
\ingroup KERN

The function returns the character
\todo this function performs a spinlock busy wait on an empty buffer. 
This needs to be changed.
*/
static inline char get(struct iobuf *x)
{
char c;
while (x->cnt<=0); /* Busy waiting... Not nice...*/
c=x->data[x->tail];
x->tail=(x->tail +1) % x->buflen;
x->cnt--;
return (c);

}

#endif
