/*  src_experimental/kernel/kerror.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
#include <kerror.h>
#include <stdio.h>
#include <cubeos.h>
#include <sys_var.h>

/*! \file kerror.c
\ingroup KERN
*/

/*!
\brief This function shuts down the system the hard way.
\ingroup KERN
*/
void KERN_panic ()
{
	asm (" ori.w #0x0700,%sr");	/* disable all further interupts */

	// this will disable clkout, so we are going to get a reset 
	// when the watchdog expires. This is done so that even if the
	// e_handle fails from here on, we will still get the reset
	writeshort (SIM_MCR, readshort (SIM_MCR) | 0x8000);

	TTY_Blocking_Serial_Out = 1;	/* wait until every char is output */

	printf ("KERNEL PANIC\n\r");

	while (1);

}

/*!
\brief This is the general error-reporting function of the kernel.
\param i is the severity of the error (see kerror.h for details)
\param text is a string to be reported to the user
\ingroup KERN
*/
void KERN_complain (int i, char *text)
{

	printf ("KERNEL ERROR LEVEL %d: %s\n\r", i, text);

	if (i == ERR_PANIC)
		KERN_panic ();

}
