/*  src_experimental/kernel/kerror.h
    CubeOS Version 0.4.90 experimental
    Copyright (C) 1999,2000 Holger Kenn

    CubeOS is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or any later version.

    CubeOS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

*/  
#ifndef KERROR_H
#define KERROR_H

/*! \file kerror.h
\ingroup KERN
*/

#define ERR_PANIC   7 //!< This is bad. We won't do anything usefull anymore.
#define ERR_EMERG   6 //!< This is almost a panic, but maybe we can still recover.
#define ERR_ALERT   5 //!< Somebody has to take care of this. But we'll continue.
#define ERR_WARN    4 //!< This is a warning, it might be OK to ignore it.
#define ERR_NOTICE  3 //!< Just to let the user know...
#define ERR_LOG     2 //!< Normal operation, can be safely ignored
#define ERR_DEBUG   1 //!< this is a debug message, only interesting to the developer


#define ERR_NO_MORE_PROCESSES 1 //!< internal error code for the scheduler


void KERN_complain(int i,char * text);

#endif
