# 1 "kernel/ptimer.c"
# 1 "kernel/ptimer.h" 1



# 1 "kernel/cubeos.h" 1



# 1 "config/config.h" 1



# 1 "config/asm_config.h" 1


# 4 "config/config.h" 2






struct config_struct {
	unsigned int  eprom_base;
	unsigned int  cpuram_base;
	unsigned int  duart_base;
	unsigned char  ptimer_vn;
	unsigned int  sci_base;
	unsigned char  sciqsm_vn;
	unsigned int  tpu_base;
	unsigned char  tpu_vn;
	unsigned int  i2ca_base;
	unsigned int  i2cb_base;
	unsigned char  i2ca_vn;
	unsigned char  i2cb_vn;
	unsigned int  fastbin_base;
	unsigned int  rcjfb_base;
	unsigned int  rcj_base;
	unsigned int  rg_base;
	unsigned char  i2ca_initcs;
	unsigned char  i2cb_initcs;
};



# 1 "config/rcj_config.h" 1














 

 
 

 







 

 
 
# 33 "config/config.h" 2


# 72 "config/config.h"






# 4 "kernel/cubeos.h" 2

# 1 "hardware/mc68332.h" 1
 



























































# 5 "kernel/cubeos.h" 2

# 1 "kernel/sys_var.h" 1


extern int _KERN_sys_error;
extern unsigned short _KERN_sys_errorcode;
extern unsigned char TTY_Blocking_Serial_Out;
extern unsigned long _time_seconds;
extern unsigned short _time_ticks;
extern unsigned short _KERN_quantum_count;
extern unsigned short _KERN_context_srsave;
extern int __MYPID;
extern int _KERN_disablecount;
extern unsigned short KERN_srsave;
void KERN_sysvarinit();

 






# 6 "kernel/cubeos.h" 2

# 1 "kernel/schedule.h" 1



# 1 "kernel/context.h" 1
 
 

























typedef struct regs *regptr;

typedef struct regs {
	long regs[19 ];
} reglist;

 















 void KERN_contextsw(regptr oldarea,regptr newarea);



# 4 "kernel/schedule.h" 2

# 1 "/usr/local/m68k-coff/include/reent.h" 1 3
 

 


































 









# 1 "/usr/local/m68k-coff/include/sys/reent.h" 1 3
 

 









# 1 "/usr/local/m68k-coff/include/_ansi.h" 1 3
 

 











# 1 "/usr/local/m68k-coff/include/sys/config.h" 1 3



 
 
# 14 "/usr/local/m68k-coff/include/sys/config.h" 3


# 25 "/usr/local/m68k-coff/include/sys/config.h" 3


 








# 44 "/usr/local/m68k-coff/include/sys/config.h" 3







































 








typedef int __int32_t;
typedef unsigned int __uint32_t;







# 15 "/usr/local/m68k-coff/include/_ansi.h" 2 3


 
 

























# 61 "/usr/local/m68k-coff/include/_ansi.h" 3


 








# 13 "/usr/local/m68k-coff/include/sys/reent.h" 2 3


struct _glue 
{
  struct _glue *_next;
  int _niobs;
  struct __sFILE *_iobs;
};

struct _Bigint 
{
  struct _Bigint *_next;
  int _k, _maxwds, _sign, _wds;
  unsigned long _x[1];
};

 





struct _atexit {
	struct	_atexit *_next;			 
	int	_ind;				 
	void	(*_fns[32 ])();	 
};

 






struct __sbuf {
	unsigned char *_base;
	int	_size;
};

 




typedef long _fpos_t;		 
				 

 
























struct __sFILE {
  unsigned char *_p;	 
  int	_r;		 
  int	_w;		 
  short	_flags;		 
  short	_file;		 
  struct __sbuf _bf;	 
  int	_lbfsize;	 

   
  void * 	_cookie;	 

  int	 (*_read)   (void *  _cookie, char *_buf, int _n)  ;
  int	 (*_write)   (void *  _cookie, const char *_buf, int _n)  ;
  _fpos_t  (*_seek)   (void *  _cookie, _fpos_t _offset, int _whence)  ;
  int	 (*_close)   (void *  _cookie)  ;

   
  struct __sbuf _ub;	 
  unsigned char *_up;	 
  int	_ur;		 

   
  unsigned char _ubuf[3];	 
  unsigned char _nbuf[1];	 

   
  struct __sbuf _lb;	 

   
  int	_blksize;	 
  int	_offset;	 

  struct _reent *_data;
};

 







struct _reent
{
   
  int _errno;

   


  struct __sFILE *_stdin, *_stdout, *_stderr;

  int  _inc;			 
  char _emergency[25];
 
  int _current_category;	 
  const  char *_current_locale;

  int __sdidinit;		 

  void  (*__cleanup)   (struct _reent *)  ;

   
  struct _Bigint *_result;
  int _result_k;
  struct _Bigint *_p5s;
  struct _Bigint **_freelist;

   
  int _cvtlen;			 
  char *_cvtbuf;

   



  unsigned char * _nextf[30 ];
  unsigned int _nmalloc[30 ];

   
  struct _atexit *_atexit;	 
  struct _atexit _atexit0;	 

   
  void (**(_sig_func))();

   


  struct _glue __sglue;			 
  struct __sFILE __sf[3];		 
};




 








extern struct _reent *_impure_ptr  ;

void _reclaim_reent  (struct _reent *)  ;

 









# 48 "/usr/local/m68k-coff/include/reent.h" 2 3

# 1 "/usr/local/m68k-coff/include/sys/_types.h" 1 3
 

 








typedef long _off_t;
typedef long _ssize_t;


# 49 "/usr/local/m68k-coff/include/reent.h" 2 3

# 1 "/usr/local/m68k-coff/include/machine/types.h" 1 3









# 50 "/usr/local/m68k-coff/include/reent.h" 2 3



# 1 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stddef.h" 1 3






 


# 19 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stddef.h" 3



 


 





 


# 61 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stddef.h" 3


 





 


















 





 

 

# 131 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stddef.h" 3


 

 
































typedef long unsigned int size_t;


















 




 

# 258 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stddef.h" 3


# 270 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stddef.h" 3


 

# 302 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stddef.h" 3




 





















# 53 "/usr/local/m68k-coff/include/reent.h" 2 3


 
struct stat;
struct tms;
struct timeval;
struct timezone;

 

extern int _close_r  (struct _reent *, int)  ;
extern int _fcntl_r  (struct _reent *, int, int, int)  ;
extern int _fork_r  (struct _reent *)  ;
extern int _fstat_r  (struct _reent *, int, struct stat *)  ;
extern int _getpid_r  (struct _reent *)  ;
extern int _kill_r  (struct _reent *, int, int)  ;
extern int _link_r  (struct _reent *, const char *, const char *)  ;
extern _off_t _lseek_r  (struct _reent *, int, _off_t, int)  ;
extern int _open_r  (struct _reent *, const char *, int, int)  ;
extern _ssize_t _read_r  (struct _reent *, int, void *, size_t)  ;
extern void *_sbrk_r  (struct _reent *, size_t)  ;
extern int _stat_r  (struct _reent *, const char *, struct stat *)  ;
extern unsigned long  _times_r  (struct _reent *, struct tms *)  ;
extern int _unlink_r  (struct _reent *, const char *)  ;
extern int _wait_r  (struct _reent *, int *)  ;
extern _ssize_t _write_r  (struct _reent *, int, const void *, size_t)  ;

 
extern int _gettimeofday_r  (struct _reent *, struct timeval *tp, struct timezone *tzp)  ;





# 5 "kernel/schedule.h" 2

 









 




struct process {
	reglist regs;	 
	void *stack;	 
	char state;      
	char irq;	 
	int signal;	 
	int mask;	 
	int ppid;	 
	struct _reent reent;  
	int message;	 
	struct sem_t * sem;   
	unsigned int time_delta;  

	int prio;	 
	int next;  
};
extern struct process _KERN_ptable[16 ];  
extern int _KERN_deltahead;			     
int KERN_schedinit();
int KERN_delta_handler();
int KERN_create(void * function);
void KERN_schedule(void);
int getpid();
 
 
int KERN_suspend(int i);
int wakeup(int i);

# 7 "kernel/cubeos.h" 2

# 1 "kernel/taskconst.h" 1









# 8 "kernel/cubeos.h" 2

 






 






# 44 "kernel/cubeos.h"

static inline void disable()
{
	asm("ori.w #0x0700,%sr");   
}
static inline void enable()
{
	asm("move.w #0x2000,%sr"); 
}




# 1 "kernel/seminl.h" 1




 
typedef struct sem_s {
	int init;
	int c;
	int task;
	} sem_t;
 


static inline void sem_post(sem_t x)
{
	if (!x.init) return;
	disable();
	x.c++;
	if (x.task!= -1 )
	{
		wakeup(x.task);  
						 
 		x.task=_KERN_ptable[x.task].next;
	}
	enable();
}





static inline void sem_wait(sem_t x)
{
	if (!x.init) return;
	disable();	
	x.c--;
	if (x.c<0){
		 
		if (x.task == -1 )
		{
			_KERN_ptable[getpid()].next= -1 ;
		} 
		else
		{
			_KERN_ptable[getpid()].next=x.task;
		}
		x.task=getpid();
		enable();
		KERN_suspend(getpid());
	} 
	else 
	{
		enable();  
	}
}




 
static inline int sem_init(sem_t x,int i,int v)
{
	if (x.init) return (-1);
	disable();
	x.c=v;
	x.task= -1 ;
	x.init=1;
	enable();
	return (0);
}

static inline int sem_destroy(sem_t x)
{
	if (!x.init) return (-1);
	disable();
	while(x.task!= -1 )
		{
			wakeup(x.task);  
							 
 			x.task=_KERN_ptable[x.task].next;
		}
	enable();
	return(0);
}


# 57 "kernel/cubeos.h" 2


# 79 "kernel/cubeos.h"




 
 
 
 
 
 
 
 










 












 










 



static inline void init_LED()
{
*(char *)( 0xfffa00  + 0x11  ) =  0x0  ;
*(char *)( 0xfffa00  + 0x15  ) =  0x8  ;
*(char *)( 0xfffa00  + 0x17  ) =  0xf7  ;
}
 
static inline void LED_ON()
{
*(char *)( 0xfffa00  + 0x11  ) =  0x8  ;
}

 
static inline void LED_OFF()
{
*(char *)( 0xfffa00  + 0x11  ) =  0x0  ;
}


# 4 "kernel/ptimer.h" 2










 
 
 
 
 
 

int KERN_ptint(void);
void KERN_init_ptimer(void);
unsigned long _gettimeofday();
unsigned long _settimeofday(unsigned long val);
 

 
 
 
 
 


# 1 "kernel/ptimer.c" 2



# 1 "drivers/tty/io_duart.h" 1



# 1 "drivers/tty/ttyio.h" 1



















struct TTY_tty_dev {
  struct iobuf * inq;
  struct iobuf * outq;
 
  void (*txchar) (char c);
  void (*en_tx_irq) ();
  void (*dis_tx_irq) ();
  void (*en_rx_irq) ();
  void (*dis_rx_irq) ();
  void (*setrts) ();
  void (*char_process) (char c);
  void (*break_process) ();
  int (*sethandshake) (char handshake);
  int (*setbps) (int bpsrate);
  char hsmode;  
  char mode;    
  char state;   
};


extern char _TTY_console_echo;
void TTY_conecho_on();
void TTY_conecho_off();
char TTY_inchar(void);
void TTY_outchar(char byte);
void TTY_init(void);
void TTY_setcontty(int contty);

extern struct TTY_tty_dev TTY_tty[3];
extern int _TTY_contty;



# 4 "drivers/tty/io_duart.h" 2


void DUART_setDIMR(unsigned char bit);
void DUART_clearDIMR(unsigned char bit);
void DUART_setOPCR(unsigned char bit);
void DUART_clearOPCR(unsigned char bit);
void DUART_int(void);
void _DUART_duart_bugfix(void);
char TTY_kinchar(void);
char TTY_rdioget(void);
void TTY_koutchar(char byte);
void TTY_rdioput(char byte);
void RSM_rdio_flush();
void RSM_rdio_enable_rx();
void RSM_rdio_disable_rx();
void DUART_duart(struct TTY_tty_dev *a,struct TTY_tty_dev *b);


# 4 "kernel/ptimer.c" 2


# 1 "/usr/local/m68k-coff/include/sys/time.h" 1 3
 

 












struct timeval {
  long tv_sec;
  long tv_usec;
};

struct timezone {
  int tz_minuteswest;
  int tz_dsttime;
};


 
# 43 "/usr/local/m68k-coff/include/sys/time.h" 3






# 6 "kernel/ptimer.c" 2


 


 

int KERN_ptint(void)
{

 
	 

	 
	if ((++_time_ticks) == 1024 ) {
		_time_seconds++;
		_time_ticks = 0;
	}

if ((0xffe400 )!=0)
	_DUART_duart_bugfix();	

	if (KERN_delta_handler()) {
		 


		_KERN_quantum_count=0;  
		return(1);
	}
	if (++_KERN_quantum_count == 1024 /8 ) {
		_KERN_quantum_count = 0;
		return (1);	 
	}
	return (0);		 
}


void KERN_init_ptimer(void)
{
	_time_seconds = 0;
	_time_ticks = 0;
	*(short *)( 0xfffa00  + 0x24  ) =   0x0008   ;

	*(short *)(  0xfffa00  + 0x22   ) =  ((*(short *)(void *)(  0xfffa00  + 0x22   )) 	&(~((  0xff )<<(  0x0 )))) |(((  0xff )&  64  )<<(  0x0 ))   ;
	*(short *)(  0xfffa00  + 0x22   ) =  ((*(short *)(void *)(  0xfffa00  + 0x22   )) 	&(~((  0x7 )<<(  0x8 )))) |(((  0x7 )&  4  )<<(  0x8 ))   ;

 


 
	 
	 
	 





}

unsigned long _gettimeofday ()
{
	return _time_seconds;
}

int gettimeofday (struct timeval *tp, struct timezone *ignore)
{

tp->tv_sec = _time_seconds; 

tp->tv_usec = (_time_ticks*1000/ 1024 ); 
	return 0;
}

unsigned long _settimeofday (unsigned long val)
{
	*(short *)( 0xfffa00  + 0x24  ) =   0  ;	 
	_time_ticks = 0;
	_time_seconds = val;	 
	*(short *)( 0xfffa00  + 0x24  ) =   0x0008   ;		 
	return _time_seconds;
}
