/*  src/libc/fstat.c
   CubeOS Version 0.4.90
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
/* fstat.c -- get status of a file.

 * Copyright (c) 1995 Cygnus Support
 *
 * The authors hereby grant permission to use, copy, modify, distribute,
 * and license this software and its documentation for any purpose, provided
 * that existing copyright notices are retained in all copies and that this
 * notice is included verbatim in any distributions. No written agreement,
 * license, or royalty fee is required for any of the authorized uses.
 * Modifications to this software may be copyrighted by their authors
 * and need not follow the licensing terms described here, provided that
 * the new terms are clearly indicated on the first page of each file where
 * they apply.
 */
#include <sys/stat.h>

/*! \file fstat.c
\ingroup LIBC
*/

/*
\brief fstat -- Since we have no file system, we just return an error.
\ingroup LIBC

*/
int fstat (int fd, struct stat *buf)
{
	buf->st_mode = S_IFCHR;	/* Always pretend to be a TTY_tty */
	buf->st_blksize = 0;

	return (0);
}
