/***********************************************************/
/* (c) Peter Stuer 1996                                    */
/*                                                         */
/* AI-LAB Vrije Universiteit Brussel                       */
/*                                                         */
/***********************************************************/
/*                                                         */
/* Smb2io.c vers 1.0                                       */
/*                                                         */
/***********************************************************/

#include "smb2kern.h"
#include "smb2io.h"


#define MAXDEVICE 32

#define DID_DISPLAY 1
#define DID_BIN1 2
#define DID_BIN2 3
#define DID_AN1 4
#define DID_AN2 5
#define DID_IR1 6
#define DID_IR2 7
#define DID_IREM 8
#define DID_CPU3 9
#define DID_CLOCK 10
#define DID_MOTOR1 11
#define DID_MOTOR2 12
#define DID_MOTOR3 13
#define DID_PAC1 14
#define DID_PAC2 15
#define DID_PAC3 16
#define DID_CLOCKCONTAINER 17




static int DeviceInUse[MAXDEVICE]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
const byte SensorToDeviceMap[LASTSENSOR +1]= {	DID_BIN1,DID_BIN1,DID_BIN1,DID_BIN1,
																								DID_BIN1,DID_BIN1,DID_BIN1,DID_BIN1,
																								DID_BIN2,DID_BIN2,DID_BIN2,DID_BIN2,
																								DID_BIN2,DID_BIN2,DID_BIN2,DID_BIN2,
																								DID_IR1,DID_IR1,DID_IR1,DID_IR1,
																								DID_IR2,DID_IR2,DID_IR2,DID_IR2,
																								DID_AN1,DID_AN1,DID_AN1,DID_AN1,
																								DID_AN2,DID_AN2,DID_AN2,DID_AN2,
																								DID_PAC1,DID_PAC1,DID_PAC2,DID_PAC2,
																								DID_PAC3,DID_PAC3};
const byte ActuatorToDeviceMap[LASTACTUATOR + 1] ={	DID_DISPLAY,DID_DISPLAY,DID_DISPLAY,DID_DISPLAY,
																										DID_IREM,DID_IREM,DID_IREM,DID_IREM,
																										DID_IREM,DID_IREM,DID_IREM,DID_IREM,
																										DID_MOTOR1,DID_MOTOR2,DID_MOTOR3};	

static byte DisplayMode = 0;




void SMB2MarkSensorInUse(byte SensorID)
{
	int i;

	/*printf("trying to mark SensorInUse\n\r");*/
	
	SensorInUse[SensorID] = 1;
	
	/*for(i=0;i<=LASTSENSOR;i++)
	{
		printf("%i",(int)SensorInUse[i]);
	}
	printf("\n\r");*/
}

void SMB2MarkActuatorInUse(byte ActuatorID)
{
	ActuatorInUse[ActuatorID] = 1;
}

void SMB2IOStart(void)
{
	int i;
	int arrayloc;


	for(i=0; i <= LASTSENSOR; i++)
	{
		if(SensorInUse[i])
		{
			DeviceInUse[SensorToDeviceMap[i]] = 1;
		}
	}

	for(i=0; i<= LASTACTUATOR; i++)
	{
		if(ActuatorInUse[i])
		{
			DeviceInUse[ActuatorToDeviceMap[i]] = 1;
		}
	}


	/*printf("DevicesInUse: ");
	for(i=1; i<=17;i++)
	{
		printf("%i",(int)DeviceInUse[i]);
	}
	printf("\n\r"); */


			
	/* IR Emitters */

	if(DeviceInUse[DID_IREM])
	{
		SMB2DefineDevice(DID_IREM,SMB2_TYPE_SPI_IR_EMIT,0,0,0,0,0,0,0,0,120,2,0,0,0,SMB2_CHANNEL_SPI);
		SMB2IRCarrierDc(50);
		SMB2IRMod(0x0B,0x7D); /* period of 2941 * 2us = 170 Hz */
		SMB2IRModDc(75);
		SMB2WriteDataToDev(DID_IREM,8,0,0,0,0,0,0,0,0);		
	}
	
	/* Binary 1 */

	if(DeviceInUse[DID_BIN1])
	{
		SMB2DefineDevice(DID_BIN1,0,SMB2_ADDR_BIN1,1,0,0,1,0,0,0,132,1,0,0,0,SMB2_CHANNEL_I2C1);
		SMB2ExportData(0,DID_CPU3,1);
	}
		
		/* Binary 2 */

	if(DeviceInUse[DID_BIN2])
	{
		SMB2DefineDevice(DID_BIN2,0,SMB2_ADDR_BIN2,1,0,1,1,0,0,0,133,1,0,0,0,SMB2_CHANNEL_I2C1);
		SMB2ExportData(1,DID_CPU3,1);
	}

	/* Analogs 1 */

	if(DeviceInUse[DID_AN1])
	{
		SMB2DefineDevice(DID_AN1,0,SMB2_ADDR_AN1,1,0,10,4,7,0,5,0,0,0,0,0,SMB2_CHANNEL_I2C1);
		for(i = SID_AN0, arrayloc = 10; i <= SID_AN3; i++, arrayloc++)
		{
			if(SensorInUse[i])
			{
				SMB2ExportData(arrayloc,DID_CPU3,1);
			}
		}
	}

	/* Analogs 2 */

	if(DeviceInUse[DID_AN2])
	{
		SMB2DefineDevice(DID_AN2,0,SMB2_ADDR_AN2,1,0,14,4,7,0,5,0,0,0,0,0,SMB2_CHANNEL_I2C1);
		for(i = SID_AN4, arrayloc = 14; i <= SID_AN7; i++, arrayloc++)
		{
			if(SensorInUse[i])
			{
				SMB2ExportData(arrayloc,DID_CPU3,1);
			}
		}
	}

	/* Motor1 */

	if(DeviceInUse[DID_MOTOR1])
	{
		 SMB2DefineDevice(DID_MOTOR1,5,0,0,0,0,0,0,0,0,150,2,0,0,0,SMB2_CHANNEL_CPU);
		 SMB2WriteDataToDev(DID_MOTOR1,2,0x01,100);
	}

	/* Motor2 */

	if(DeviceInUse[DID_MOTOR2])
	{
		SMB2DefineDevice(DID_MOTOR2,5,0,0,0,0,0,0,0,0,152,2,0,0,0,SMB2_CHANNEL_CPU);
		SMB2WriteDataToDev(DID_MOTOR2,2,0x02,100);
	}
	
	/* Motor3 */

	if(DeviceInUse[DID_MOTOR3])
	{
		SMB2DefineDevice(DID_MOTOR3,5,0,0,0,0,0,0,0,0,154,2,0,0,0,SMB2_CHANNEL_CPU);
		SMB2WriteDataToDev(DID_MOTOR3,2,0x04,100);
	}

	/* PAC1 */

	if(DeviceInUse[DID_PAC1])
	{
		SMB2DefineDevice(DID_PAC1,4,0,8,0,18,2,0,0,0,123,1,0,0,0,SMB2_CHANNEL_CPU);
		SMB2WriteDataToDev(DID_PAC1,1,0x01);
		for(i = SID_PAC1_SP, arrayloc = 18; i <= SID_PAC1_AC; i++, arrayloc++)
		{
			if(SensorInUse[i])
			{
				SMB2ExportData(arrayloc,DID_CPU3,1);
			}
		}
	}

	/* PAC2 */

	if(DeviceInUse[DID_PAC2])
	{
		SMB2DefineDevice(DID_PAC2,4,0,8,0,20,2,0,0,0,124,1,0,0,0,SMB2_CHANNEL_CPU);
		SMB2WriteDataToDev(DID_PAC2,1,0x02);		
		for(i = SID_PAC2_SP, arrayloc = 20; i <= SID_PAC2_AC; i++, arrayloc++)
		{
			if(SensorInUse[i])
			{
				SMB2ExportData(arrayloc,DID_CPU3,1);
			}
		}
	}

	/* PAC3 */

	if(DeviceInUse[DID_PAC3])
	{
		SMB2DefineDevice(DID_PAC3,4,0,8,0,22,2,0,0,0,125,1,0,0,0,SMB2_CHANNEL_CPU);
		SMB2WriteDataToDev(DID_PAC3,1,0x03);
		for(i = SID_PAC3_SP, arrayloc = 22; i <= SID_PAC3_AC; i++, arrayloc++)
		{
			if(SensorInUse[i])
			{
				SMB2ExportData(arrayloc,DID_CPU3,1);
			}
		}
	}

	/* IR Receivers 1 */

	if(DeviceInUse[DID_IR1])
	{
		SMB2DefineDevice(DID_IR1,0,SMB2_ADDR_IR1,1,0,2,4,7,0,5,0,0,0,0,0,SMB2_CHANNEL_I2C1);
		for(i = SID_IR0, arrayloc = 2; i <= SID_IR3; i++, arrayloc++)
		{
			if(SensorInUse[i])
			{
				SMB2ExportData(arrayloc,DID_CPU3,1);
			}
		}
	}


	/* IR Receivers 2 */

	if(DeviceInUse[DID_IR2])
	{
		SMB2DefineDevice(DID_IR2,0,SMB2_ADDR_IR2,1,0,6,4,7,0,5,0,0,0,0,0,SMB2_CHANNEL_I2C1);
		for(i = SID_IR4, arrayloc = 6; i <= SID_IR7; i++, arrayloc++)
		{
			if(SensorInUse[i])
			{
				SMB2ExportData(arrayloc,DID_CPU3,1);
			}
		}
	}

	/* wait for start */

	while(sensor[AP_CLOCK] == 0 );
}

	
void SMB2IOInit(void)
{

	SMB2Init();

	sensor = ((unsigned char*)(*((unsigned long *)0x518)));
	sensor[AP_BIN0]=0xFF;
	sensor[AP_BIN8]=0xFF;

	/* CPU3 */

	SMB2DefineDevice(DID_CPU3,3,0,0,0,0,0,0,0,0,200,4,0,0,0,SMB2_CHANNEL_CPU);
	DeviceInUse[DID_CPU3] =1;

	/* Zet Teller op in 24 die cycled met step 1 tussen 0 en 255*/

	SMB2DefineDevice(DID_CLOCKCONTAINER,8,0,1,0,0,0,0,0,0,24,1,0,0,0,SMB2_CHANNEL_CPU);
	DeviceInUse[DID_CLOCKCONTAINER] =1;

	SMB2DefineDevice(DID_CLOCK,1,0,1,0,122,1,0,0,0,126,3,0,0,0,SMB2_CHANNEL_CPU);
	DeviceInUse[DID_CLOCK] = 1;

	SMB2WriteData(2,122,24);
	SMB2WriteData(4,126,0,255,1);

	SMB2ExportData(24,DID_CPU3,1);

	/* Display */           

	SMB2DefineDevice(DID_DISPLAY, SMB2_TYPE_SPI_DISPLAY,0,0,0,0,0,0,0,0,140,5,0,0,0,SMB2_CHANNEL_SPI);
	SMB2WriteDataToDev(DID_DISPLAY,5,0xE9,0xAD,0xAB,0xE9,0);
	DeviceInUse[DID_DISPLAY] = 1;

	SMB2SoundModDc(0x64);
	SMB2Sound(0x00,0x08);
	

}

void UpdateDisplay(byte Line1, byte Line2, byte Line3, byte Line4)
{
	static byte CurrentLine1=0xE9, CurrentLine2=0xAD, CurrentLine3=0xAB, CurrentLine4=0xE9;

	if(DeviceInUse[DID_DISPLAY])
	{
		if(	(CurrentLine1 != Line1) || (CurrentLine2 != Line2) || 
				(CurrentLine3 != Line3) || (CurrentLine4 != Line4))
		{
			SMB2WriteDataToDev(DID_DISPLAY,5,Line1,Line2,Line3,Line4,DisplayMode);
			CurrentLine1 = Line1 ;
			CurrentLine2 = Line2 ;
			CurrentLine3 = Line3 ;
			CurrentLine4 = Line4 ;
		}
	}
}

void UpdateIREmitters(byte Em0,byte Em1, byte Em2, byte Em3,
											byte Em4,byte Em5, byte Em6, byte Em7)
{
	static byte CurrentEm0=0,CurrentEm1=0,CurrentEm2=0,CurrentEm3=0,
							CurrentEm4=0,CurrentEm5=0,CurrentEm6=0,CurrentEm7=0;

	if(DeviceInUse[DID_IREM])
	{
		if(	CurrentEm0 != Em0 )
		{
			SMB2WriteDataToDev(DID_IREM,2,0x01,Em0);
			CurrentEm0  = Em0;
		}
		if(	CurrentEm1 != Em1 )
		{
			SMB2WriteDataToDev(DID_IREM,2,0x02,Em1);
			CurrentEm1  = Em1;
		}
		if(	CurrentEm2 != Em2 )
		{
			SMB2WriteDataToDev(DID_IREM,2,0x04,Em2);
			CurrentEm2  = Em2;
		}
		if(	CurrentEm3 != Em3 )
		{
			SMB2WriteDataToDev(DID_IREM,2,0x08,Em3);
			CurrentEm3  = Em3;
		}
		if(	CurrentEm4 != Em4 )
		{
			SMB2WriteDataToDev(DID_IREM,2,0x10,Em4);
			CurrentEm4  = Em4;
		}
		if(	CurrentEm5 != Em5 )
		{
			SMB2WriteDataToDev(DID_IREM,2,0x20,Em5);
			CurrentEm5  = Em5;
		}
		if(	CurrentEm6 != Em6 )
		{
			SMB2WriteDataToDev(DID_IREM,2,0x40,Em6);
			CurrentEm6  = Em6;
		}
		if(	CurrentEm7 != Em7 )
		{
			SMB2WriteDataToDev(DID_IREM,2,0xFF,Em7);
			CurrentEm7  = Em7;
		}
	}
}

void UpdateMotor1(byte Power)
{
	static byte CurrentPower=100;
	
	if(DeviceInUse[DID_MOTOR1])
	{
		if(CurrentPower != Power)
		{
			SMB2WriteDataToDev(DID_MOTOR1,2,0x01,Power);
			CurrentPower = Power;
		}
	}
}
			
void UpdateMotor2(byte Power)
{
	static byte CurrentPower=100;
	
	if(DeviceInUse[DID_MOTOR2])
	{
		if(CurrentPower != Power)
		{
			SMB2WriteDataToDev(DID_MOTOR2,2,0x02,Power);
			CurrentPower = Power;
		}
	}
}

void UpdateMotor3(byte Power)
{
	static byte CurrentPower=100;
	
	if(DeviceInUse[DID_MOTOR3])
	{
		if(CurrentPower != Power)
		{
			SMB2WriteDataToDev(DID_MOTOR3,2,0x04,Power);
			CurrentPower = Power;
		}
	}
}

int wait_for_tick(void)
{
	int counter = 0;
	static byte old_clock = 0;


	while(sensor[AP_CLOCK] == old_clock)
	{
		counter++;
	}
	if(old_clock !=255)
	{
		if(sensor[AP_CLOCK]!= old_clock + 1)
		{
			counter *= -1;
		}
	}
	else
	{
		if(sensor[AP_CLOCK] != 0)
		{
			counter *= -1;
		}
	}
	old_clock = sensor[AP_CLOCK];

	return counter;
}
 




