/***********************************************************/
/* (c) Peter Stuer 1996                                    */
/*                                                         */
/* AI-LAB Vrije Universiteit Brussel                       */
/*                                                         */
/***********************************************************/
/*                                                         */
/* Smb2io.h vers 1.0                                       */
/*                                                         */
/***********************************************************/

#ifndef _SMB2IO_
	#define _SMB2IO_

	#include "smb2kern.h"

	#define FIRSTSENSOR 0
	#define LASTSENSOR 37
	#define FIRSTACTUATOR 0
	#define LASTACTUATOR 14

	#define SID_BIN0 0
	#define SID_BIN1 1
	#define SID_BIN2 2
	#define SID_BIN3 3
	#define SID_BIN4 4
	#define SID_BIN5 5
	#define SID_BIN6 6
	#define SID_BIN7 7
	#define SID_BIN8 8
	#define SID_BIN9 9
	#define SID_BIN10 10
	#define SID_BIN11 11
	#define SID_BIN12 12
	#define SID_BIN13 13
	#define SID_BIN14 14
	#define SID_BIN15 15
	#define SID_IR0 16
	#define SID_IR1 17
	#define SID_IR2 18
	#define SID_IR3 19
	#define SID_IR4 20
	#define SID_IR5 21
	#define SID_IR6 22
	#define SID_IR7 23
	#define SID_AN0 24
	#define SID_AN1 25
	#define SID_AN2 26
	#define SID_AN3 27
	#define SID_AN4 28
	#define SID_AN5 29
	#define SID_AN6 30
	#define SID_AN7 31
	#define SID_PAC1_SP 32
	#define SID_PAC1_AC 33
	#define SID_PAC2_SP 34
	#define SID_PAC2_AC 35
	#define SID_PAC3_SP 36
	#define SID_PAC3_AC 37

	#define AID_DISP1 0
	#define AID_DISP2 1
	#define AID_DISP3 2
	#define AID_DISP4 3
	#define AID_IREM0 4
	#define AID_IREM1 5
	#define AID_IREM2 6
	#define AID_IREM3 7
	#define AID_IREM4 8
	#define AID_IREM5 9
	#define AID_IREM6 10
	#define AID_IREM7 11
	#define AID_MOTOR1 12
	#define AID_MOTOR2 13
	#define AID_MOTOR3 14

	#define AP_BIN0 0
	#define AP_BIN1 0
	#define AP_BIN2 0
	#define AP_BIN3 0
	#define AP_BIN4 0
	#define AP_BIN5 0
	#define AP_BIN6 0
	#define AP_BIN7 0
	#define AP_BIN8 1
	#define AP_BIN9 1
	#define AP_BIN10 1
	#define AP_BIN11 1
	#define AP_BIN12 1
	#define AP_BIN13 1
	#define AP_BIN14 1
	#define AP_BIN15 1
	#define AP_IR0 2
	#define AP_IR1 3
	#define AP_IR2 4
	#define AP_IR3 5
	#define AP_IR4 6
	#define AP_IR5 7
	#define AP_IR6 8
	#define AP_IR7 9
	#define AP_AN0 10
	#define AP_AN1 11
	#define AP_AN2 12
	#define AP_AN3 13
	#define AP_AN4 14
	#define AP_AN5 15
	#define AP_AN6 16
	#define AP_AN7 17
	#define AP_PAC1_SP 18
	#define AP_PAC1_AC 19
	#define AP_PAC2_SP 20
	#define AP_PAC2_AC 21
	#define AP_PAC3_SP 22
	#define AP_PAC3_AC 23
	#define AP_CLOCK 24

	int SensorInUse[LASTSENSOR + 1];/*={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};*/
	int ActuatorInUse[LASTACTUATOR + 1];/*={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}; */

	unsigned char *sensor; 

	void SMB2MarkSensorInUse(byte SensorID);
	void SMB2MarkActuatorInUse(byte actuatorID);
	void SMB2IOInit (void);
	void SMB2IOStart(void);
	void UpdateDisplay(byte Line1, byte Line2, byte Line3, byte Line4);
	void UpdateIREmitters( byte Em0, byte Em1, byte Em2, byte Em3,
												 byte Em4, byte Em5, byte Em6, byte Em7 );
	void UpdateMotor1(byte Power);
	void UpdateMotor2(byte Power);
	void UpdateMotor3(byte Power);

	int wait_for_tick(void);
	

#endif



