/***********************************************************/
/* (c) Peter Stuer 1996                                    */
/*                                                         */
/* AI-LAB Vrije Universiteit Brussel                       */
/*                                                         */
/***********************************************************/
/*                                                         */
/* Smb2rdio.c vers 1.0                                     */
/*                                                         */
/***********************************************************/


#include "smb2kern.h"
#include "smb2rdio.h"

#define DID_RADIO 75

static byte radio_mode = 0x00;

void init_radio(byte robot_id, byte number_of_robots)
{
  radio_link_tx=*(void**)0x51c;
  radio_link_rx=*(void**)0x520;

  /*define radio device */
  SMB2DefineDevice(DID_RADIO,9,0,4,4,125,0,0,0,0,110,6,0,0,0,5);
  /* initialize radio */
  SMB2WriteDataToDev(DID_RADIO,6,robot_id,number_of_robots,1,8,2,0);
}

void radio_tx_on(void)
{
  radio_mode=radio_mode | 0x02;
  SMB2SetRadioMode(radio_mode);
}

void radio_tx_off(void)
{
  radio_mode=radio_mode & 0xFD;
  SMB2SetRadioMode(radio_mode);
}

void radio_rx_on(void)
{
  radio_mode=radio_mode | 0x01;
  SMB2SetRadioMode(radio_mode);
}

void radio_rx_off(void)
{
  radio_mode=radio_mode & 0xFE;
  SMB2SetRadioMode(radio_mode);
}
