/*  src_experimental/config/config.h
    CubeOS Version 0.4.90 experimental
    Copyright (C) 1999,2000 Holger Kenn

    CubeOS is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or any later version.

    CubeOS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

*/  
#ifndef CONFIG_H

#define CONFIG_H
#include <asm_config.h>

#define ATYPE unsigned int
#define VTYPE unsigned char
#define BTYPE unsigned char

struct config_struct {
	ATYPE eprom_base;
	ATYPE cpuram_base;
	ATYPE duart_base;
	VTYPE ptimer_vn;
	ATYPE sci_base;
	VTYPE sciqsm_vn;
	ATYPE tpu_base;
	VTYPE tpu_vn;
	ATYPE i2ca_base;
	ATYPE i2cb_base;
	VTYPE i2ca_vn;
	VTYPE i2cb_vn;
	ATYPE fastbin_base;
	ATYPE rcjfb_base;
	ATYPE rcj_base;
	ATYPE rg_base;
	BTYPE i2ca_initcs;
	BTYPE i2cb_initcs;
};

#if defined(RCJ)

#include <rcj_config.h>

#elif defined (RG)

#include <rg_config.h>

#elif defined (RGD)

#include <rgd_config.h>

#elif defined(CUBE3)

#include <cube3_config.h>

#elif defined(CUBE1)

#include <cube1_config.h>

#else

#define EPROM_BASE       (config.eprom_base)
#define CPURAM_BASE      (config.cpuram_base)
#define DUART_BASE       (config.duart_base)
#define PTIMER_VECTORNUM (config.ptimer_vn)
#define SCI_BASE         (config.sci_base)
#define QSM_VECTORNUM    (config.sciqsm_vn)
#define TPU_BASE         (config.tpu_base)
#define TPU_VECTORBASE   (config.tpu_vn)
#define I2CA_BASE	 (config.i2ca_base)
#define I2CB_BASE	 (config.i2cb_base)
#define I2CA_VECTORNUM	 (config.i2ca_vn)
#define I2CB_VECTORNUM	 (config.i2cb_vn)
#define FASTBIN_BASE	 (config.fastbin_base)
#define RCJFB_BASE	 (config.rcjfb_base)
#define RCJ_BASE	 (config.rcj_base)
#define RG_BASE		 (config.rg_base)
#define I2C_INITCSA      (config.i2ca_initcs)
#define I2C_INITCSB	 (config.i2cb_initcs)

extern struct config_struct config;

#define FILL_CONFIG

#endif



#endif

