/*  src_experimental/drivers/fastbin/fastbin.h
    CubeOS Version 0.4.90 experimental
    Copyright (C) 1999,2000 Holger Kenn

    CubeOS is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or any later version.

    CubeOS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

*/  
#ifndef _FASTBIN_H
#define _FASTBIN_H

/*! \file fastbin.h
\ingroup FBIN
*/

#define FBTYPE_EMPTY 0
#define FBTYPE_DUART 1
#define FBTYPE_TPU 2
#define FBTYPE_TTL 3
#define FBTYPE_CPU 4
#define FBTYPE_RCJ 5

#define FBCPU_PCS1 1

#define setDUARTOPR(i) writebyte(DUART_OPRSET,1<<i)
#define clearDUARTOPR(i) writebyte(DUART_OPRRST,1<<i)


int FBIN_init();
int FBIN_make(int nr,char type,char id);
int FBIN_set(int nr,char v);

#endif
