/*  src_experimental/drivers/i2c/i2cd.c
   CubeOS Version 0.4.91 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
#include <config.h>
#include <mc68332.h>
#include <cubeos.h>
#include <stdio.h>
#include <flash.h>

#define WAIT 100000


/*! \file flash.c
\ingroup FLASH
*/

unsigned short FLASH_MID;
unsigned short FLASH_DID;

/*!
\brief verify the presence of a flash rom in the system
\param none
\ingroup FLASH
*/
int FLASH_init()
{
#ifdef CUBE1
return -1;
#else
  int ok=0;
  unsigned int csba;
  unsigned int csbf;

  printf("EPROM_BASE = %x\n",EPROM_BASE);
  printf("checking CSBOOT...\n");
  csba = readshort(SIM_CSBARBT);
  csbf = readshort(SIM_CSORBT);
  printf("CSBARBT = %x,CSORBT=%x\n",csba,csbf);

  FLASH_CSInfo(csba,csbf);

  if (((csba & 0xfff8)<<8)!=EPROM_BASE){
	printf("EPROM_BASE!=CSBOOT setting!\n");
	return(-1);
  }
  if (!(csbf&0x1000)) {
	printf("setting R/W mode on CSBOOT\n");
	writeshort(SIM_CSORBT,csbf|0x1000);
	csbf|=0x1000;
  } else {
	printf("CSBOOT already R/W\n");
  }

  printf("reading flash ID\n");
  fflush(stdout);

  writeshort(EPROM_BASE+(0x555<<1),0xaa);
  writeshort(EPROM_BASE+(0x2aa<<1),0x55);
  writeshort(EPROM_BASE+(0x555<<1),0x90); /* Autoselect mode */
  FLASH_MID=readshort(EPROM_BASE);
  FLASH_DID=readshort(EPROM_BASE+2);
  writeshort(EPROM_BASE,0xF0);		/* reset */
  printf("Manufacturer ID is %x\n",FLASH_MID);
  printf("DEVICE ID is %x\n",FLASH_DID);
  switch (FLASH_MID) {
	case 0x01:
		printf (" AMD");
		switch(FLASH_DID) {
			case 0x22d6:
				printf(" AM29F800B Top");
				ok=1;
				break;
			case 0x2258:
				printf(" AM29F800B Bot");
				ok=1;
				break;
			default:
				printf(" UNKNOWN");
		}
		break;
	default:
		printf (" UNKNOWN");
  }
  printf("\n");

return (ok==1?0:-1);
#endif
}

/*!
\brief rewrites the flash with data
\param s1 is the source pointer
\param s2 is the destination pointer
\param n is the number of bytes to write
*/
int FLASH_bcopy(void * s1, void * s2, size_t n)
{
  unsigned long size,addr,j;
  unsigned short int tmp1, tmp2;
  char ok,i;
  return -1;

  LED_ON();
  for(j=0;j<WAIT;j++);
  LED_OFF();
  for(j=0;j<WAIT;j++);

  /* erase chip */
  writeshort(EPROM_BASE+(0x555<<1),0xaa);
  writeshort(EPROM_BASE+(0x2aa<<1),0x55);
  writeshort(EPROM_BASE+(0x555<<1),0x80);
  writeshort(EPROM_BASE+(0x555<<1),0xaa);
  writeshort(EPROM_BASE+(0x2aa<<1),0x55);
  writeshort(EPROM_BASE+(0x555<<1),0x10);
  while(~readshort(EPROM_BASE))
        {
        LED_ON();
        LED_OFF();
	}

  LED_ON();
  for(j=0;j<WAIT;j++);
  LED_OFF();
  for(j=0;j<WAIT;j++);

  size = n;
  addr = 0;

  /* program */
  while(addr < size) {
    LED_ON();
    tmp1 = readshort(s1+addr);
    writeshort(EPROM_BASE+(0x555<<1),0xaa);
    writeshort(EPROM_BASE+(0x2aa<<1),0x55);
    writeshort(EPROM_BASE+(0x555<<1),0xa0);
    writeshort(EPROM_BASE+s2+addr,tmp1);
    LED_OFF();
    ok = 0;
    while(!ok) {
      tmp2 = readshort(EPROM_BASE+addr);
      if ((tmp1 ^ tmp2) & 0x80) {   //not finished
        if (tmp2 & 0x20) {          //time out ?
          tmp2 = readshort(EPROM_BASE+addr);
          if ((tmp1 ^ tmp2) & 0x80) {   //yes!
	    /*
            LED_ON();
            while(1);
	    */
	    return -1;
	  }
          ok = 1;
	}
      }
      else ok = 1;
    }
    addr += 2;
  }

  LED_ON();
  for(j=0;j<WAIT;j++);
  LED_OFF();
  for(j=0;j<WAIT;j++);

  /* verify */
  addr = 0;

  while(addr < size) {
    LED_ON();
    tmp1 = readshort(s1+addr);
    tmp2 = readshort(EPROM_BASE+s2+addr);
    LED_OFF();
    if(tmp1 ^ tmp2) {  //verify failed
      /*LED_ON();
      while(1);
	*/
	return (-1);
    }
    addr += 2;
  }

  /* success */
  LED_ON();
  for(j=0;j<WAIT;j++);
  LED_OFF();
  for(j=0;j<WAIT;j++);

  return 0;

}

/*!
\brief print the contents of a 68332 SIM ChipSelect register set
\param br is the content of the base address register
\param or is the content of the option register
\ingroup FLASH
*/
int FLASH_CSInfo(unsigned short br,unsigned short or)
{
  printf("CS addr = %x ",(br & 0xfff8)<<8);
  printf("CS blk = %x : ",(br & 0x0007));
  switch(br & 0x0007) {
	case 0:
		printf("2k\n");
		break;
	case 1:
		printf("8k\n");
		break;
	case 2:
		printf("16k\n");
		break;
	case 3:
		printf("64k\n");
		break;
	case 4:
		printf("128k\n");
		break;
	case 5:
		printf("256k\n");
		break;
	case 6:
		printf("512k\n");
		break;
	case 7:
		printf("1024k\n");
		break;
	default:
		printf("???\n");
  }

  printf("MODE: %s ",(or&0x8000?"SYNC":"ASYNC"));
  printf("BYTE: ");
  switch (or&0x6000) {
	case 0x0000:
		printf("off ");
	case 0x2000:
		printf("low ");
	case 0x4000:
		printf("high ");
	case 0x6000:
		printf("both ");
  }
  printf("R/W: ");
  switch (or&0x1800) {
	case 0x0000:
		printf("rsvd ");
		break;
	case 0x0800:
		printf("read ");
		break;
	case 0x1000:
		printf("write ");
		break;
	case 0x1800:
		printf("both ");
		break;
  }
  printf("\n");
  printf("STRB: %s ",((or&0x0400)?"DS":"AS"));
  printf("DSACK: %d ",((or&0x0300)>>6));
  printf("SPACE: ");
  switch (or&0x0030) {
	case 0x0000:
		printf("CPU ");
		break;
	case 0x0010:
		printf("USER ");
		break;
	case 0x0020:
		printf("SUPV ");
		break;
	case 0x0030:
		printf("both ");
  }
  printf("\n");
 return 0;

}
