/*  src_experimental/drivers/hardware/RG.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
#include <cubeos.h>


/* this is the init function for the RoboGuard hardware. */

int RG_init ()
{
#ifdef RG_BASE
	if ((RG_BASE) != 0) {
		unsigned short v;
		writeshort (SIM_CSBAR3, RG_BASE >> 8);
		writeshort (SIM_CSOR3, 0x747e);		/* ASYNC,H+L,W only,DS,1 wait, 
							   S+U SP */
		/* 0111 0100 0111 1110 */
		/* 7    4    7    e */
		v = readshort (SIM_CSPAR0);
		v |= 0x300;
		v &= 0xfeff;
		writeshort (SIM_CSPAR0, v);	/* enables CS3 as 8 bit port */

		return 0;
	} else {
		return -1;
	}
#else
	return -1;
#endif
}
