/*  src_experimental/drivers/i2c/analog.h
    CubeOS Version 0.4.90 experimental
    Copyright (C) 1999,2000 Holger Kenn

    CubeOS is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or any later version.

    CubeOS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

*/  
#ifndef _ANALOG_H
#define _ANALOG_H

/*! \file analog.h
\ingroup I2C
*/

#define MAXI2CMESSLENGTH 8

#define ANALOG_4SE    0x00;
#define ANALOG_3DI    0x10;
#define ANALOG_2S2D   0x20;
#define ANALOG_2DI    0x30;
#define ANALOG_DACOE  0x40;

/*!
\brief i2c a/d data structure
\ingroup I2C
*/
struct _I2C_ad_datas
{
char bus;
char address;
char ad[3];
char da;
char status;
char active;
};

extern struct _I2C_ad_datas _I2C_ad_data[16];
extern char _I2C_analog_mbuf[MAXI2CMESSLENGTH];
extern struct i2cmess _I2C_analog_m;
extern int _I2C_adnum;

int I2C_ReadAnalogIn(int chip,int port);
int I2C_WriteAnalogOut(int chip,int value);
int I2C_ConfigureAnalog(int chip,char how);
int I2C_init_analog();

#endif
