/*  src_experimental/drivers/i2c/digital.h
    CubeOS Version 0.4.90 experimental
    Copyright (C) 1999,2000 Holger Kenn

    CubeOS is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or any later version.

    CubeOS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

*/  
#ifndef _DIGITAL_H
#define _DIGITAL_H

/*! \file digital.h
\ingroup I2C
*/

#define MAXI2CMESSLENGTH 8

/*!
\brief I2C digital datastructure
\ingroup I2C
*/
struct _I2C_bin_datas
{
char bus;
char address;
char status;
char active;
};

extern struct _I2C_bin_datas _I2C_bin_data[32];
extern unsigned char _I2C_digital_mbuf[MAXI2CMESSLENGTH];
extern struct i2cmess _I2C_digital_m;
extern int _I2C_binnum;

unsigned char I2C_ReadBinIn(int chip);
int I2C_WriteBinOut(int chip,unsigned char value);

int I2C_init_digital();

#endif
