# 1 "drivers/i2c/i2cd.c"
# 1 "kernel/cubeos.h" 1



# 1 "config/config.h" 1







# 1 "config/rcj_config.h" 1
















 

 
 

 







 

 
 
# 8 "config/config.h" 2


# 45 "config/config.h"




# 4 "kernel/cubeos.h" 2

# 1 "hardware/mc68332.h" 1
 



























































# 5 "kernel/cubeos.h" 2

# 1 "kernel/sys_var.h" 1


extern int _KERN_sys_error;
extern unsigned short _KERN_sys_errorcode;
extern unsigned char TTY_Blocking_Serial_Out;
extern unsigned long _time_seconds;
extern unsigned short _time_ticks;
extern unsigned short _KERN_quantum_count;
extern unsigned short _KERN_context_srsave;
extern int __MYPID;
extern int _KERN_disablecount;
extern unsigned short KERN_srsave;
void KERN_sysvarinit();

 






# 6 "kernel/cubeos.h" 2

# 1 "kernel/schedule.h" 1



# 1 "kernel/context.h" 1
 
 

























typedef struct regs *regptr;

typedef struct regs {
	long regs[19 ];
} reglist;

 















 void KERN_contextsw(regptr oldarea,regptr newarea);



# 4 "kernel/schedule.h" 2

# 1 "/usr/local/m68k-coff/include/reent.h" 1 3
 

 


































 









# 1 "/usr/local/m68k-coff/include/sys/reent.h" 1 3
 

 









# 1 "/usr/local/m68k-coff/include/_ansi.h" 1 3
 

 











# 1 "/usr/local/m68k-coff/include/sys/config.h" 1 3



 
 
# 14 "/usr/local/m68k-coff/include/sys/config.h" 3


# 25 "/usr/local/m68k-coff/include/sys/config.h" 3


 








# 44 "/usr/local/m68k-coff/include/sys/config.h" 3







































 








typedef int __int32_t;
typedef unsigned int __uint32_t;







# 15 "/usr/local/m68k-coff/include/_ansi.h" 2 3


 
 

























# 61 "/usr/local/m68k-coff/include/_ansi.h" 3


 








# 13 "/usr/local/m68k-coff/include/sys/reent.h" 2 3


struct _glue 
{
  struct _glue *_next;
  int _niobs;
  struct __sFILE *_iobs;
};

struct _Bigint 
{
  struct _Bigint *_next;
  int _k, _maxwds, _sign, _wds;
  unsigned long _x[1];
};

 





struct _atexit {
	struct	_atexit *_next;			 
	int	_ind;				 
	void	(*_fns[32 ])();	 
};

 






struct __sbuf {
	unsigned char *_base;
	int	_size;
};

 




typedef long _fpos_t;		 
				 

 
























struct __sFILE {
  unsigned char *_p;	 
  int	_r;		 
  int	_w;		 
  short	_flags;		 
  short	_file;		 
  struct __sbuf _bf;	 
  int	_lbfsize;	 

   
  void * 	_cookie;	 

  int	 (*_read)   (void *  _cookie, char *_buf, int _n)  ;
  int	 (*_write)   (void *  _cookie, const char *_buf, int _n)  ;
  _fpos_t  (*_seek)   (void *  _cookie, _fpos_t _offset, int _whence)  ;
  int	 (*_close)   (void *  _cookie)  ;

   
  struct __sbuf _ub;	 
  unsigned char *_up;	 
  int	_ur;		 

   
  unsigned char _ubuf[3];	 
  unsigned char _nbuf[1];	 

   
  struct __sbuf _lb;	 

   
  int	_blksize;	 
  int	_offset;	 

  struct _reent *_data;
};

 







struct _reent
{
   
  int _errno;

   


  struct __sFILE *_stdin, *_stdout, *_stderr;

  int  _inc;			 
  char _emergency[25];
 
  int _current_category;	 
  const  char *_current_locale;

  int __sdidinit;		 

  void  (*__cleanup)   (struct _reent *)  ;

   
  struct _Bigint *_result;
  int _result_k;
  struct _Bigint *_p5s;
  struct _Bigint **_freelist;

   
  int _cvtlen;			 
  char *_cvtbuf;

   



  unsigned char * _nextf[30 ];
  unsigned int _nmalloc[30 ];

   
  struct _atexit *_atexit;	 
  struct _atexit _atexit0;	 

   
  void (**(_sig_func))();

   


  struct _glue __sglue;			 
  struct __sFILE __sf[3];		 
};




 








extern struct _reent *_impure_ptr  ;

void _reclaim_reent  (struct _reent *)  ;

 









# 48 "/usr/local/m68k-coff/include/reent.h" 2 3

# 1 "/usr/local/m68k-coff/include/sys/_types.h" 1 3
 

 








typedef long _off_t;
typedef long _ssize_t;


# 49 "/usr/local/m68k-coff/include/reent.h" 2 3

# 1 "/usr/local/m68k-coff/include/machine/types.h" 1 3









# 50 "/usr/local/m68k-coff/include/reent.h" 2 3



# 1 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stddef.h" 1 3






 


# 19 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stddef.h" 3



 


 





 


# 61 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stddef.h" 3


 





 


















 





 

 

# 131 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stddef.h" 3


 

 
































typedef long unsigned int size_t;


















 




 

# 258 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stddef.h" 3


# 270 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stddef.h" 3


 

# 302 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stddef.h" 3




 





















# 53 "/usr/local/m68k-coff/include/reent.h" 2 3


 
struct stat;
struct tms;
struct timeval;
struct timezone;

 

extern int _close_r  (struct _reent *, int)  ;
extern int _fcntl_r  (struct _reent *, int, int, int)  ;
extern int _fork_r  (struct _reent *)  ;
extern int _fstat_r  (struct _reent *, int, struct stat *)  ;
extern int _getpid_r  (struct _reent *)  ;
extern int _kill_r  (struct _reent *, int, int)  ;
extern int _link_r  (struct _reent *, const char *, const char *)  ;
extern _off_t _lseek_r  (struct _reent *, int, _off_t, int)  ;
extern int _open_r  (struct _reent *, const char *, int, int)  ;
extern _ssize_t _read_r  (struct _reent *, int, void *, size_t)  ;
extern void *_sbrk_r  (struct _reent *, size_t)  ;
extern int _stat_r  (struct _reent *, const char *, struct stat *)  ;
extern unsigned long  _times_r  (struct _reent *, struct tms *)  ;
extern int _unlink_r  (struct _reent *, const char *)  ;
extern int _wait_r  (struct _reent *, int *)  ;
extern _ssize_t _write_r  (struct _reent *, int, const void *, size_t)  ;

 
extern int _gettimeofday_r  (struct _reent *, struct timeval *tp, struct timezone *tzp)  ;





# 5 "kernel/schedule.h" 2

 









 




struct process {
	reglist regs;	 
	void *stack;	 
	char state;      
	char irq;	 
	int signal;	 
	int mask;	 
	int ppid;	 
	struct _reent reent;  
	int message;	 
	struct sem_t * sem;   
	unsigned int time_delta;  

	int prio;	 
	int next;  
};
extern struct process _KERN_ptable[16 ];  
extern int _KERN_deltahead;			     
int KERN_schedinit();
int KERN_delta_handler();
int KERN_create(void * function);
void KERN_schedule(void);
int getpid();
 
 
int KERN_suspend(int i);
int wakeup(int i);

# 7 "kernel/cubeos.h" 2

# 1 "kernel/taskconst.h" 1









# 8 "kernel/cubeos.h" 2

 






 






# 44 "kernel/cubeos.h"

static inline void disable()
{
	asm("ori.w #0x0700,%sr");   
}
static inline void enable()
{
	asm("move.w #0x2000,%sr"); 
}




# 1 "kernel/seminl.h" 1




 
typedef struct sem_s {
	int init;
	int c;
	int task;
	} sem_t;
 


static inline void sem_post(sem_t x)
{
	if (!x.init) return;
	disable();
	x.c++;
	if (x.task!= -1 )
	{
		wakeup(x.task);  
						 
 		x.task=_KERN_ptable[x.task].next;
	}
	enable();
}





static inline void sem_wait(sem_t x)
{
	if (!x.init) return;
	disable();	
	x.c--;
	if (x.c<0){
		 
		if (x.task == -1 )
		{
			_KERN_ptable[getpid()].next= -1 ;
		} 
		else
		{
			_KERN_ptable[getpid()].next=x.task;
		}
		x.task=getpid();
		enable();
		KERN_suspend(getpid());
	} 
	else 
	{
		enable();  
	}
}




 
static inline int sem_init(sem_t x,int i,int v)
{
	if (x.init) return (-1);
	disable();
	x.c=v;
	x.task= -1 ;
	x.init=1;
	enable();
	return (0);
}

static inline int sem_destroy(sem_t x)
{
	if (!x.init) return (-1);
	disable();
	while(x.task!= -1 )
		{
			wakeup(x.task);  
							 
 			x.task=_KERN_ptable[x.task].next;
		}
	enable();
	return(0);
}


# 57 "kernel/cubeos.h" 2


# 79 "kernel/cubeos.h"




 
 
 
 
 
 
 
 










 












 










 



static inline void init_LED()
{
*(char *)( 0xfffa00  + 0x11  ) =  0x0  ;
*(char *)( 0xfffa00  + 0x15  ) =  0x8  ;
*(char *)( 0xfffa00  + 0x17  ) =  0xf7  ;
}
 
static inline void LED_ON()
{
*(char *)( 0xfffa00  + 0x11  ) =  0x8  ;
}

 
static inline void LED_OFF()
{
*(char *)( 0xfffa00  + 0x11  ) =  0x0  ;
}


# 1 "drivers/i2c/i2cd.c" 2

# 1 "hardware/mc68332.h" 1
 



























































# 2 "drivers/i2c/i2cd.c" 2

# 1 "kernel/ivtab.h" 1





extern void (*(*_KERN_IVTab)[512]) (void);

extern void *_KERN_IVTab_oldvector[512];

void _KERN_IVTab_init();
int _KERN_IVTab_setvector(unsigned short vector, void (*isr) (void));
int _KERN_IVTab_clearvector(unsigned short vector, void (*isr) (void));


# 3 "drivers/i2c/i2cd.c" 2

# 1 "drivers/i2c/i2cd.h" 1

# 1 "kernel/ssem.h" 1




 
 



typedef int ssem_t;




 


 




 




# 2 "drivers/i2c/i2cd.h" 2
















 







 









 











 





struct i2cmess {
  unsigned char address;      
  unsigned char nrBytes;      
  unsigned char procBytes;    
  unsigned char *buf;         
  unsigned char status;       
};

 

struct	i2c {
  struct i2c_device *ioaddr;		    
  int  mode;				    
  int  m_head;			            
  int  m_tail;			            
  struct i2cmess* m_buff[10 ];	    
  ssem_t  m_sem;				    
  int  m_cnt;			            
  int  m_dcnt;                              
  void (*m_state_handler)(struct i2c *ptr); 
  int  m_state;                             
  int  s_iptr;	                            
  int  s_icnt;                              
  ssem_t  s_isem;                              
  char s_ibuff[10 ];                    
  int  s_optr;                              
  int  s_ocnt;				    
  ssem_t  s_osem;				    
  char s_obuff[10 ];                    
  void (*s_state_handler)(struct i2c *ptr); 
  int  s_state;                             
  char s_status;                            
};

 

void I2C_inthandler(unsigned long minor);
void _I2C_master_handler(struct i2c *p);
void _I2C_slave_handler(struct i2c *p);
int I2C_init(int which, unsigned long ioaddr);
int I2C_process(unsigned char whichBus, unsigned char whichQueue, struct i2cmess *msg);
int I2C_messagestatus(struct i2cmess * msg);
int I2C_scanbus(unsigned char whichBus);
extern struct i2c i2c[];

 

void I2C_int_a(void);
void I2C_int_b(void);
# 4 "drivers/i2c/i2cd.c" 2

# 1 "hardware/pcf8584.h" 1
 







 









struct i2c_device {
  unsigned char	data;
  unsigned char	control;
};
# 5 "drivers/i2c/i2cd.c" 2

# 1 "/usr/local/m68k-coff/include/stdio.h" 1 3
 


















 
















# 1 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stddef.h" 1 3






 


# 19 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stddef.h" 3



 


 





 


# 61 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stddef.h" 3


 





 


















 





 

 

# 131 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stddef.h" 3


 

 


# 182 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stddef.h" 3





 




 

# 258 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stddef.h" 3


# 270 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stddef.h" 3


 

# 302 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stddef.h" 3




 





















# 37 "/usr/local/m68k-coff/include/stdio.h" 2 3



# 1 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stdarg.h" 1 3
 





























































 






typedef void *__gnuc_va_list;



 

# 116 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stdarg.h" 3



















# 202 "/usr/local/lib/gcc-lib/m68k-coff/2.8.1/include/stdarg.h" 3




# 40 "/usr/local/m68k-coff/include/stdio.h" 2 3


 







typedef _fpos_t fpos_t;

typedef struct __sFILE FILE;





	 











 














































 










int	 remove    (const char *)  ;
int	 rename    (const char *, const char *)  ;

FILE *	 tmpfile    (void)  ;
char *	 tmpnam    (char *)  ;
int	 fclose    (FILE *)  ;
int	 fflush    (FILE *)  ;
FILE *	 freopen    (const char *, const char *, FILE *)  ;
void	 setbuf    (FILE *, char *)  ;
int	 setvbuf    (FILE *, char *, int, size_t)  ;
int	 fprintf    (FILE *, const char *, ...)  ;
int	 fscanf    (FILE *, const char *, ...)  ;
int	 printf    (const char *, ...)  ;
int	 scanf    (const char *, ...)  ;
int	 sscanf    (const char *, const char *, ...)  ;
int	 vfprintf    (FILE *, const char *, __gnuc_va_list )  ;
int	 vprintf    (const char *, __gnuc_va_list )  ;
int	 vsprintf    (char *, const char *, __gnuc_va_list )  ;
int	 fgetc    (FILE *)  ;
char *   fgets    (char *, int, FILE *)  ;
int	 fputc    (int, FILE *)  ;
int	 fputs    (const char *, FILE *)  ;
int	 getc    (FILE *)  ;
int	 getchar    (void)  ;
char *   gets    (char *)  ;
int	 putc    (int, FILE *)  ;
int	 putchar    (int)  ;
int	 puts    (const char *)  ;
int	 ungetc    (int, FILE *)  ;
size_t	 fread    (void * , size_t _size, size_t _n, FILE *)  ;
size_t	 fwrite    (const void *  , size_t _size, size_t _n, FILE *)  ;
int	 fgetpos    (FILE *, fpos_t *)  ;
int	 fseek    (FILE *, long, int)  ;
int	 fsetpos    (FILE *, const fpos_t *)  ;
long	 ftell    ( FILE *)  ;
void	 rewind    (FILE *)  ;
void	 clearerr    (FILE *)  ;
int	 feof    (FILE *)  ;
int	 ferror    (FILE *)  ;
void     perror    (const char *)  ;

FILE *	 fopen    (const char *_name, const char *_type)  ;
int	 sprintf    (char *, const char *, ...)  ;


int	 vfiprintf    (FILE *, const char *, __gnuc_va_list )  ;
int	 iprintf    (const char *, ...)  ;
int	 fiprintf    (FILE *, const char *, ...)  ;
int	 siprintf    (char *, const char *, ...)  ;


 





FILE *	 fdopen    (int, const char *)  ;

int	 fileno    (FILE *)  ;
int	 getw    (FILE *)  ;
int	 pclose    (FILE *)  ;
FILE *   popen    (const char *, const char *)  ;
int	 putw    (int, FILE *)  ;
void     setbuffer    (FILE *, char *, int)  ;
int	 setlinebuf    (FILE *)  ;


 



FILE *	 _fdopen_r    (struct _reent *, int, const char *)  ;
FILE *	 _fopen_r    (struct _reent *, const char *, const char *)  ;
int	 _getchar_r    (struct _reent *)  ;
char *	 _gets_r    (struct _reent *, char *)  ;
int	 _iprintf_r    (struct _reent *, const char *, ...)  ;
int	 _mkstemp_r    (struct _reent *, char *)  ;
char *	 _mktemp_r    (struct _reent *, char *)  ;
void	 _perror_r    (struct _reent *, const char *)  ;
int	 _printf_r    (struct _reent *, const char *, ...)  ;
int	 _putchar_r    (struct _reent *, int)  ;
int	 _puts_r    (struct _reent *, const char *)  ;
int	 _remove_r    (struct _reent *, const char *)  ;
int	 _rename_r    (struct _reent *,
			   const char *_old, const char *_new)  ;
int	 _scanf_r    (struct _reent *, const char *, ...)  ;
int	 _sprintf_r    (struct _reent *, char *, const char *, ...)  ;
char *	 _tempnam_r    (struct _reent *, char *, char *)  ;
FILE *	 _tmpfile_r    (struct _reent *)  ;
char *	 _tmpnam_r    (struct _reent *, char *)  ;
int	 _vfprintf_r    (struct _reent *, FILE *, const char *, __gnuc_va_list )  ;
int	 _vprintf_r    (struct _reent *, const char *, __gnuc_va_list )  ;
int	 _vsprintf_r    (struct _reent *, char *, const char *, __gnuc_va_list )  ;

 



int	 __srget    (FILE *)  ;
int	 __swbuf    (int, FILE *)  ;

 




FILE	*  funopen   (const void *  _cookie,
		int (*readfn)(void *  _cookie, char *_buf, int _n),
		int (*writefn)(void *  _cookie, const char *_buf, int _n),
		fpos_t (*seekfn)(void *  _cookie, fpos_t _off, int _whence),
		int (*closefn)(void *  _cookie))  ;





 




# 259 "/usr/local/m68k-coff/include/stdio.h" 3

 


































 













# 6 "drivers/i2c/i2cd.c" 2


struct i2c i2c[2];

static void GenerateStop (struct i2c *p, unsigned char mess)
{
	p->m_state = 0 ;
	p->m_buff[p->m_tail]->status = mess;	 
	p->m_buff[p->m_tail]->procBytes = p->m_dcnt;
	if (++p->m_tail >= 10 )
		p->m_tail = 0;
	p->m_cnt--;
	  p->m_sem  ++;  ;

	 

	if (p->m_cnt == 0) {
		p->mode = 1 ;
	} else {
		(p->m_state_handler) (p);
	}
}

void _I2C_master_handler(struct i2c *p)
{
	struct i2c_device *dev;
	struct i2cmess *msg;
	unsigned long timeoutcnt;
	unsigned char dummy;

	dev = p->ioaddr;
	msg = p->m_buff[p->m_tail];

	switch (p->m_state) {
	case 0 :
		timeoutcnt = 1000 ;
		while (!(dev->control & 0x01 ) && timeoutcnt--);	 

		if (timeoutcnt) {
			p->m_dcnt = 0;
			p->m_state = (msg->address & 1) ? 2  : 1 ;
			dev->data = msg->address;
			dev->control = 0x80  | 0x40  | 0x08  | 0x04  | 0x01 ;	 

		} else {
			GenerateStop (p, 7 );
		}
		return;
	case 1 :
		if (dev->control & 0x02 ) {	 
			p->mode = 1 ;
			(p->s_state_handler) (p);	 
			p->mode = 0 ;
			GenerateStop (p, 6 );		 
			return;
		}
		if (dev->control & 0x08 ) {
			dev->control = 0x80  | 0x40  | 0x08  | 0x02  | 0x01 ;
			GenerateStop (p, 4 );	 

		} else if (p->m_dcnt < msg->nrBytes)
			dev->data = msg->buf[p->m_dcnt++];	 
		else {
			dev->control = 0x80  | 0x40  | 0x08  | 0x02  | 0x01 ;
			GenerateStop (p, 1 );	 
		}
		break;
	case 2 :
		if (dev->control & 0x02 ) {	 
			p->mode = 1 ;
			(p->s_state_handler) (p);	 
			p->mode = 0 ;
			GenerateStop (p, 6 );		 
			return;
		}
		if (dev->control & 0x08 ) {
			dev->control = 0x80  | 0x40  | 0x08  | 0x02  | 0x01 ;
			GenerateStop (p, 5 );
		} else {
			if (msg->nrBytes == 1) {
				p->m_state = 4 ;
				dev->control = 0x40  | 0x08 ;
			} else {
				p->m_state = 3 ;
			}
			dummy = dev->data;	 

		}
		break;
	case 3 :
		if (p->m_dcnt + 2 == msg->nrBytes) {
			dev->control = 0x40  | 0x08 ;	 
			p->m_state = 4 ;
		}
		msg->buf[p->m_dcnt++] = dev->data;
		break;
	case 4 :
		dev->control = 0x80  | 0x40  | 0x08  | 0x02  | 0x01 ;
		msg->buf[p->m_dcnt++] = dev->data;
		GenerateStop (p, 1 );	 
		break;
	default:		 
		GenerateStop (p, 3 );
		break;
	}
}

void _I2C_slave_handler(struct i2c *p)
{
	register struct i2c_device *dev;

	dev = p->ioaddr;

	switch (p->s_state) {
	case 0 :
		if (dev->control & 0x04 ) {	 
			if (dev->data & 1) {	 
				p->s_state = 1 ;
			} else {	 
				if (p->s_icnt >= 10 ) {
					p->s_status |= 2 ;
					dev->control = 0x80  | 0x40  | 0x08 ;
					  p->s_isem  ++;  ;
				} else {
					p->s_state = 2 ;
				}
			}
		} else {	 
			dev->control = 0x80  | 0x40  | 0x08 ;
		}
		return;
	case 1 :
		if (dev->control & 0x08 ) {	 
			p->s_state = 0 ;
			  p->s_osem  ++;  ;
		}
		if (p->s_ocnt == 0) {
			dev->data = 0xff;
			p->s_status |= 1 ;
		} else {
			dev->data = p->s_obuff[p->s_optr++];
			p->s_ocnt--;
		}
		return;
	case 2 :
		if (dev->control & 0x20 ) {	 
			p->s_state = 0 ;
			dev->control = 0x80  | 0x40  | 0x08  | 0x01 ;
			  p->s_isem  ++;  ;
		} else if (p->s_icnt == 10 ) {
			dev->control = 0x80  | 0x40  | 0x08 ;		 
			p->s_state = 0 ;
			  p->s_isem  ++;  ;
		} else {
			p->s_ibuff[p->s_iptr++] = dev->data;
			p->s_icnt++;
		}
		return;
	default:
		dev->control = 0x80  | 0x40  | 0x08  | 0x01 ;	 
		p->s_status |= 4 ;
		return;
	}
}


void I2C_inthandler(unsigned long minor)
{
	struct i2c *p;

	p = &i2c[minor];
	if (p->mode == 0 )
		(p->m_state_handler) (p);	 
	else
		(p->s_state_handler) (p);	 
}

int I2C_init(int which, unsigned long ioaddr)
{
	register struct i2c *iptr;
	register struct i2c_device *chip;
	unsigned short v;

	 
	if (which == 0x41 ) {
		if (0xffe200  ==0)
			return(-1);


		_KERN_IVTab_setvector(27 , I2C_int_a);


if ( ) {
		*(short *)( 0xfffa00  + 0x5c  ) =   ioaddr >> 8  ;	 
		*(short *)( 0xfffa00  + 0x5e  ) =   0x7ffa  ;		 

		v = (*(short *)(void *)( 0xfffa00  + 0x44  )) ;
		v |= 0xc00;
		v &= 0xfbff;
		*(short *)( 0xfffa00  + 0x44  ) =   v  ;	 
		}

		iptr = &(i2c[0]);
	} else if (which == 0x42 ) {
		if (0  ==0)
			return(-1);
		_KERN_IVTab_setvector(0 , I2C_int_b);

# 224 "drivers/i2c/i2cd.c"

		iptr = &(i2c[1]);
	} else
		return(-1);

	 
	iptr->ioaddr = (struct i2c_device *) ioaddr;	 
	iptr->mode = 1 ;
	iptr->m_head = iptr->m_tail = 0;	 
	 
	iptr->m_sem = 10 ;
	iptr->m_cnt = 0;
	iptr->m_dcnt = 0;
	iptr->m_state_handler = &_I2C_master_handler;
	iptr->m_state = 0 ;

	iptr->s_iptr = 0;
	iptr->s_isem = 0;
	iptr->s_icnt = 0;
	iptr->s_optr = 0;
	iptr->s_osem = 0;
	iptr->s_ocnt = 0;
	iptr->s_state_handler = &_I2C_slave_handler;
	iptr->s_state = 0 ;
	iptr->s_status = 0;

	 
	chip = iptr->ioaddr;
	chip->control = 0x80;	 
	if (which == 0x41 )
		chip->data = 0x55 ;	 
	else
		chip->data = 0x56 ;	 
	chip->control = 0xa0;	 
	chip->data = 0x1c ;
	chip->control = 0x80  | 0x40  | 0x08  | 0x01 ;	 
	return(0);
}

 

int I2C_Start_I2C_Transfer(unsigned char which, struct i2cmess *msg)
{
	struct i2c *hdl;
	int timeout;

	if (which == 0x41 )
		hdl = &i2c[0];
	else
		hdl = &i2c[1];

	if (!(hdl->ioaddr)) {
			msg->status= 8 ;
			return(-1);
	}

	 
	msg->status = 0 ;
	 hdl->m_sem --;while( hdl->m_sem <0) ;
	hdl->m_buff[hdl->m_head++] = msg;
	++hdl->m_cnt;
	if (hdl->m_head >= 10 )
		hdl->m_head = 0;

	 
	if ((hdl->mode == 1 ) && (hdl->s_state == 0 )) {
		hdl->mode = 0 ;
		disable ();
		(hdl->m_state_handler) (hdl);	 
		enable ();
	}
	timeout = 0;
	while ((msg->status == 0 ) && (++timeout < 1000000));
	if (timeout > 0)
		return (-1);

	switch (msg->status) {
	case 1 :
		return (0);
		break;
	case 4 :
		return (-1);
		break;
	case 5 :
		return (-1);
		break;
	case 6 :
		return (-1);
		break;
	case 7 :
		return (-1);
		break;
	case 3 :
		return (-1);
		break;
	default:
		return (-1);
		break;
	}

}

int I2C_slprocess(unsigned char which, struct i2cmess *msg)
{
	struct i2c *hdl;
	int i;

	if (which == 0x41 )
		hdl = &i2c[0];
	else
		hdl = &i2c[1];

	if (!(hdl->ioaddr)) {
			msg->status= 8 ;
			return(-1);
	}

	 
	msg->status = 0 ;

	if (msg->nrBytes != 10 )
		return (-1);

	if (msg->address & 1) {	 
		 hdl->s_isem --;while( hdl->s_isem <0) ;
		disable ();
		for (i = 0; i < hdl->s_icnt; i++)
			msg->buf[i] = hdl->s_ibuff[i];
		msg->procBytes = hdl->s_icnt;
		hdl->s_icnt = 0;
		hdl->s_iptr = 0;
		if (hdl->s_status == 0)
			msg->status = 1 ;
		if (hdl->s_status & 2 ) {
			msg->status = 3 ;
			hdl->s_status &= ~2 ;
		}
		enable ();
	} else {		 
		disable ();
		for (i = 0; i < 10 ; i++)
			hdl->s_obuff[i] = msg->buf[i];
		hdl->s_ocnt = 10 ;
		hdl->s_optr = 0;
		enable ();
		 hdl->s_osem --;while( hdl->s_osem <0) ;
		disable ();
		msg->procBytes = hdl->s_ocnt;
		hdl->s_ocnt = 0;
		hdl->s_optr = 0;
		if (hdl->s_status == 0)
			msg->status = 1 ;
		if (hdl->s_status & 1 ) {
			msg->status = 3 ;
			hdl->s_status &= ~1 ;
		}
		enable ();
	}
	return (0);
}

int I2C_process(unsigned char whichBus, unsigned char whichQueue, struct i2cmess *msg)
{
	if (whichQueue == 0 )
		return I2C_Start_I2C_Transfer(whichBus, msg);
	else
		return I2C_slprocess(whichBus, msg);
}

int I2C_messagestatus(struct i2cmess *msg)
{
	switch (msg->status) {
	case 1 :
		return (0);
		break;
	case 4 :
		printf ("I2C: transfer interupted\n");
		return (-1);
		break;
	case 5 :
		printf ("I2C: device not present\n");
		return (-1);
		break;
	case 6 :
		printf ("I2C: arbitration lost\n");
		return (-1);
		break;
	case 7 :
		printf ("I2C: time-out\n\r");
		return (-1);
		break;
	case 3 :
		printf ("I2C: master handler in strange state\n");
		return (-1);
		break;
	case 8 :
		printf ("I2C: there is no such bus\n");
		return (-1);
		break;
	default:
		printf ("I2C: unknown status (%d)\n\r", msg->status);
		return (-1);
		break;
	}

}

int I2C_scanbus(unsigned char bus)
{

	struct i2cmess msg;
	unsigned char buf[10];
	int i, j;
	int count = 0;
	int ret;

	for (i = 0; i < 127; i++) {

		msg.address = i << 1;
		msg.nrBytes = 1;
		msg.buf = buf;
		for (j = 0; j < 10; j++)
			buf[j] = 0;

		ret = I2C_process(bus, 0 , &msg);

		switch (msg.status) {
		case 1 :
			printf ("found device at adress 0x%x \n", msg.address);
			count++;
			break;
		case 7 :
		case 5 :
		case 4 :
			printf (".");
			fflush ((_impure_ptr->_stdout) );
			break;
		case 8 :
			I2C_messagestatus(&msg);
			return(-1);
			break;
		default:
			I2C_messagestatus(&msg);
		}

	}
	return (count);
}
