/*  src_experimental/drivers/tty/qsm.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
#include <cubeos.h>
#include <mc68332.h>
#include <ivtab.h>
#include <qsm.h>
#include <spi.h>
#include <io_sci.h>

extern void QSM_qspiWrapper ();
extern void QSM_sciWrapper ();

int QSM_init ()
{
	unsigned short v;

	writeshort (QSM_QSMCR, 0x8e);
	/* Bit15: STOP  (QSM clock stopped)
	   Bit14: FRZ1  (Halt QSM)
	   Bit7 : SUPV  (all QSM registers in supervisor space)
	   Bit3..0: IARB (of the QSM module)
	 */
	_KERN_IVTab_setvector (QSM_VECTORNUM, QSM_sciWrapper);
	_KERN_IVTab_setvector (QSM_VECTORNUM + 1, QSM_qspiWrapper);

	writebyte (QSM_QIVR, QSM_VECTORNUM);

	/* Bit7..0  INTV (interrupt vector for the QSM module) */
	v = readbyte (QSM_QILR);
	writebyte (QSM_QILR, (v & 0xf8) | 0x6);
	/* Bit13..11: ILQSPI (internal iarb level of QSPI)
	   Bit10..8 : ILSCI  (internal iarb level of SCI)
	 */
	return 0;
}
