#include <spi.h>
#include <stdio.h>
#include <cubeos.h>
#include <mc68332.h>
#include <qsm.h>

int _SPI_cmdcnt=0;


int SPI_init()
{
int i;

printf("SPI init\n");

QSM_init();


writeshort (QSM_PQSPAR, (readshort (QSM_PQSPAR)|0x1b01E)&0xFFFE );
/* Use PCS1,PCS0,MISO,MOSI for SCI*/
/* PCS1,0,SCK,MOSI output MISO input */

writeshort(SPI_SPCR1,readshort(SPI_SPCR1)&0x7FFF); /* disable QSPI */

/* SMBII code */
writeshort(SPI_SPCR0,0xA811);	/* Master mode, Normal outputs, 10 bits */
				/* CPOL=0 CPHA=0  493Khz clock freq. */
writeshort(SPI_SPCR2,0x300);    /* int disabled, wrap disabled, wrap to 0 */
				/* start pointer is 0, end pointer is 3 */
writeshort(SPI_SPCR3,0x0);
				/* loop mode off,HALTA and MODF irqs off */
				/* halt off, status register all 0 */

for (i=0;i<16;i+=2){ /* clear out dual ported RAM */
	writeshort(SPI_RDRAM+i,0);
	writeshort(SPI_TDRAM+i,0);
	writeshort(SPI_CMDRAM+i,0);
}


/* SMBII code */
//  writebyte(SPI_CMDRAM,0xdc);	/* CONT BITSE /DT DSCK  PCS3 PCS2 /PCS1 /PCS0 */
//  writebyte(SPI_CMDRAM+1,0x8c); /* CONT /BITSE /DT /DSCK  PCS3 PCS2 /PCS1 /PCS0 */
//  writebyte(SPI_CMDRAM+2,0xcc); /* CONT BITSE /DT /DSCK  PCS3 PCS2 /PCS1 /PCS0 */
//  writebyte(SPI_CMDRAM+3,0x4c); /* /CONT BITSE /DT /DSCK  PCS3 PCS2 /PCS1 /PCS0 */



//  writeshort(SPI_SPCR1,0x8000); /* enable QSPI */

//  while ((readshort(SPI_SPSR) & 0x80) == 0); /* wait for finished */
//  writeshort(SPI_SPSR,0);		     /* reset status */
//  writeshort(SPI_TDRAM,0x100);		     /* Send 0x100 */ 

//  writeshort(SPI_SPCR1,0x8000);
//  while ((readshort(SPI_SPSR) & 0x80) == 0);
//  writeshort(SPI_SPSR,0);

//  writeshort(SPI_SPCR0,0xB811);
//  writebyte(SPI_CMDRAM+4,0x4e);
//  writeshort(SPI_SPCR2,0x404);
//  writebyte(SPI_QPDR,0xf8);
//  for (i = 1; i <= 8; i++) {
//    writebyte(SPI_CMDRAM+4,i << 8);
//    writeshort(SPI_SPCR1,0x8000);
//    while ((readshort(SPI_SPCR1) & 0x8000) != 0);
//  }

return 0;
}


int SPI_resetcmd()
{
  writeshort(SPI_SPCR1,0x0000); /* disable QSPI */
  _SPI_cmdcnt=0;
  return(0);
}

int SPI_newcommand(unsigned char command)
{
 if (_SPI_cmdcnt<16)
{
	writebyte(SPI_CMDRAM+(_SPI_cmdcnt++),command);
	return(_SPI_cmdcnt-1);
} else {
	return(-1);
}
}

int SPI_init_analog()
{

printf("SPI init analog\n");

return 0;

}

int SPI_ReadAnalogIn(int chip, int channel)
{

print ("SPI ReadAnalogIn %d %d\n",chip,channel);

return 15;
}

void QSM_qspi_int ()
{


}
